/*
**	@(#)z8536.h	1.2 88/03/19 
**
**	Definitions for 386 on-board Z8536 (counter/timer & parallel i/o).
**	Copyright 1987, ALTOS Computers.
**
*/


/*
 * Initalize clock constant for 50msec clock interrupts.
 * Magic value to cause proper interrupt interval.
 * We don't need a fudge factor, because the clock is
 * free-running square wave.
 *
 * For a 16 MHz 80386, we assume a 4.0MHz clock input into the CIO.
 * clknumb = (int)(4000000L/(long)HZ); 
 * CIO internally clocked at half frequency .:
 * clknumb = (int)((4000000L/(long)HZ)*0.5);
 *
 * For a 20 MHz 80386, we assume a 5.0MHz clock input into the CIO.
 * clknumb = (int)(5000000L/(long)HZ); 
 * CIO internally clocked at half frequency .:
 * clknumb = (int)((5000000L/(long)HZ)*0.5);
 *
 * CIO talks in base 16 .: convert clknumb to hex
 */
#define CLKNUM16 0x9c40	/* timer constant for 16MHz 386 (i.e. 4.0MHz for CIO)*/
#define CLKNUM20 0xc350	/* timer constant for 20MHz 386 (i.e. 5.0MHz for CIO)*/


#define MICR	0x00	/* Master Interrupt Control Register */
#define MCCR	0x01	/* Master Configuration Control Register */
#define PTASPEC 0x20	/* Port A specification register */
#define PTBSPEC 0x28	/* Port B Specification register */
#define APOLARITY 0x22 	/* Port A Data Path Polarity Register */
#define BPOLARITY 0x2a 	/* Port B Data Path Polarity Register */
#define ADIRECTION 0x23 /* Port A Data Direction Register */
#define BDIRECTION 0x2b /* Port B Data Direction Register */
#define IOCTLA	   0x24 /* Port A Special I/O Control Register */
#define IOCTLB	   0x2c /* Port B Special I/O Control Register */
#define PTAVECTOR  0x02 /* Port A Interrupt Vector */
#define PTASTAT   0x08 /* Port A Command and Status Register */
#define PTBSTAT   0x09 /* Port B Command and Status Register */
#define PPRA 	0x25	/* Port A Pattern Polartiy Register */
#define PPTA 	0x26	/* Port A Pattern Transition Register */
#define PPMA 	0x27	/* Port A Pattern Mask Register */


/* additional defines for counter/timers and real time clock utility */

/* MICR bits */
#define CT_VIS	0x04	/* CT Vector Includes Status  in MICR */
#define CT_MIE	0x80	/* Master Interrupt Enable */

/* MCCR bits */
#define CT_INDEP	0x00	/* CT1, CT2 independent */
#define CT_GATE		0x01	/* CT1 output gates CT2 */
#define CT_TRIG		0x02	/* CT1 output triggers CT2 */
#define CT_COUNT	0x03	/* CT1 output is CT2 count input */
#define CT_E1		0x40	/* CT1 Enable in MCCR */
#define CT_E2		0x20	/* CT2 Enable in MCCR */
#define CT_E3		0x10	/* CT3 Enable in MCCR */

/* CT Registers */
#define CTM1SPEC 0x1c	/* CT1 Mode Specification Register */
#define CTM2SPEC 0x1d	/* CT2 Mode Specification Register */
#define CTM3SPEC 0x1e	/* CT3 Mode Specification Register */
#define CT1STAT 0x0a	/* CT1 Command and Status Register */
#define CT2STAT 0x0b	/* CT2 Command and Status Register */
#define CT3STAT 0x0c	/* CT3 Command and Status Register */
#define CT1TCRH 0x16 	/* CT1 Time Constant Register low byte */
#define CT1TCRL 0x17 	/* CT1 Time Constant Register high byte */
#define CT2TCRH 0x18 	/* CT2 Time Constant Register low byte */
#define CT2TCRL 0x19 	/* CT2 Time Constant Register high byte */
#define CT3TCRH 0x1a 	/* CT3 Time Constant Register low byte */
#define CT3TCRL 0x1b 	/* CT3 Time Constant Register high byte */
#define CT1CCRH 0x10 	/* CT1 Current Count Register high byte */
#define CT1CCRL 0x11 	/* CT1 Current Count Register low byte */
#define CT2CCRH 0x12 	/* CT2 Current Count Register high byte */
#define CT2CCRL 0x13 	/* CT2 Current Count Register low byte */
#define CT3CCRH 0x14 	/* CT3 Current Count Register high byte */
#define CT3CCRL 0x15 	/* CT3 Current Count Register low byte */
#define CTVECTOR 0x04 	/* CT Interrupt Vector Register */

/* CT Mode Specification Register bits */
#define CT_PULSE	0x00	/* Pulse Output Duty Cycle */
#define CT_1SHOT	0x01	/* One-Shot Output Duty Cycle */
#define CT_SQUARE	0x02	/* Square Wave Output Duty Cycle */
#define CT_NODCS	0x03	/* No Output Duty Cycle Specified */
#define CT_REB		0x04	/* Retrigger Enable bit */
#define CT_EGE		0x08	/* External Gate Enable bit */
#define CT_ETE		0x10	/* External Trigger Enable bit */
#define CT_ECE		0x20	/* External Count Enable bit */
#define CT_EOE		0x40	/* External Output Enable bit */
#define CT_CC 		0x80	/* Continuous cycle */

/* CT Command and Status Register bits */
#define CT_CLIPIUS 	0x20	/* Write: Clear IP, IUS */
#define CT_SETIE   	0xc0	/* Write: set IE */
#define CT_CLIE		0xe0	/* Write: clear IE */
#define CT_ISBITS  	0xe0	/* Mask for Interrupt Status bits */

#define CT_CIP		0x01	/* RW: Count In Progress Bit */
#define CT_TCB		0x02	/* RW: Trigger Command Bit */
#define CT_GCB		0x04	/* RW: Gate Command Bit */
#define CT_RCC		0x08	/* Read/set: Read Counter Control */
#define CT_ERR		0x10	/* Read (only): Interrupt Error */
#define CT_IP		0x20	/* Read: IP */
#define CT_IE		0x40	/* Read: IE */
#define CT_IUS		0x80	/* Read: IUS */

/* end CT defines */
