/*
 *  Include file for low level net drivers
 *  Also used by user mode net servers
 */
#ident	"@(#)wnet.h	1.28	2/19/88 08:45:16"

#ifndef NMAXSEG	/* don't include file more than once */

/*  Transmit and receive buffers and control structures */
#define  NMAXSEG	(RECLIM+sizeof(struct nshead))	/* maximum packet size */
#define  WHEAD	4	/* first 4 bytes of nethdr structure */
#define	 WRECTAIL	2	/* CRC(2) */
#define  WSENDLIM	(WHEAD+NMAXSEG)  	/* transmit buffer length */
#define  WRECLIM	(WHEAD+NMAXSEG+WRECTAIL) /* receive buffer length */

#ifdef INKERNEL

/* NS packet type (used by low level net drivers) */
#define NStype0	'\6'
#define NStype1	'\0'
#define NStype	6
#define  NUMWRBUFS	7	/* number of WorkNet receive buffers */

/*  Misc constants */
#define  KLUDGETIME	10	/* every 1/2 second */
#define  LEADFLAGS	20	/* leading flags (must be <=63) */
#define  TRAILFLAGS	3	/* trailing flags (must be <=31) */

/* a pointer to this struct is returned by the nd_getb routines */
struct pckt {
	struct pckt *pforwrd;
	struct nshead *data;
	unchar flags;
	unchar seq;
};

/*	Note: the host number is stored in the ip->i_fsptr field, since
	we have no need for a struct WNinode, other than the host # */
extern short WNfstyp;	/* fstypsw[] index for worknet */

extern unchar initwnet[LIMDRIVER];	/* flag if running WorkNet */

extern unchar wnetvers[LIMDRIVER];	/* version # of board running
	worknet (set to the version number of the board when net
	initialized) */

/* host address, allows for different address for each board */
extern unchar wnetaddr[LIMDRIVER][6];

extern char *getnblk();
struct file *WNnet_fp();

#if i386
# define	NUMWXBUFS	16	/* MAX number of WorkNet transmit buffers,
	actual number may be less, depending on amount of RAM installed.
	The variable numwxbufs should be used in all runtime code.
	Olson 7/86 */
# define	LONGSWAP(x) (ulong)((ulong)(x)>>16 | (ulong)(x)<<16)
# define	byteswap(x) (x)
# define	bbyteswap(x,n)
# define	swaplong(x)	(x)
# define	WNMAGIC		0xDCBA
# define	round(r) (((r)+sizeof(int)-1)&(~(sizeof(int)-1)))
/* physical address base of buffers. Initialized in wnetinit.c */
extern paddr_t	netbase;
extern paddr_t netoffset;	/* offset of next avail mem in net data */
extern int numwxbufs;	/* declared in wnetinit.c */
#else m68k
# define	NUMWXBUFS	8
# define	numwxbufs NUMWXBUFS
# define	LONGSWAP(x)	(x)
# define	NCONDSWAP(x)	(x)
# define	wzero		bzero
# define	WNMAGIC		0xBADC
extern char		*local_name;
#endif i386

#ifdef DEBUG
/*	be sure you watch out for 'else' clauses when using this. Invoke
	as:
		NETDEBUG(level ("message %d, error %s, mid, errtype));
	noting the extra parentheses.  This allows an arbitrary # of
	arguments to get past the pre-processor.
*/
#define NETDEBUG(lev, args) if(netdebug & (lev)) WNprintf args
extern int	netdebug;
#else
#define NETDEBUG(lev, args)
#endif DEBUG

#endif /* INKERNEL */

#endif NMAXSEG	/* don't include file more than once */
