/*
 *	@(#) wd1010.h 1.1 88/03/19 
 *
 *	Copyright (C) The Santa Cruz Operation, 1985, 1986.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 *
 */

/*
 * definitions for the western digital 1010 winchester controller
 */
 
/*
 * I/O port addresses
 */
#define WDSDATA		0x01F0	/* r/w data */
#define	WDSERROR	0x01F1	/*  r  error flags */
#define WDSPRECOMP	0x01F1	/*  w  write precomp cylinder */
#define WDSCOUNT	0x01F2	/* r/w sector count */
#define WDSSECTOR	0x01F3	/* r/w sector number */
#define WDSCYL_LOW	0x01F4	/* r/w cylinder low */
#define WDSCYL_HI	0x01F5	/* r/w cylinder high */
#define WDSSDH		0x01F6	/* r/w drive and head */
#define WDSSTATUS	0x01F7	/*  r  controller status */
#define WDSCMD		0x01F7	/*  w  controller command */

#define	WDSCTRL		0x03F6	/* controller control port */

#define WDSSTEP		0x00	/* step time 35us */
#define	WDSESZ		0xA0	/* ECC, 512 byte sectors */

#define SECSIZ		512	/* physical sector size on disk */
#define NSECTORS	17	/* sectors per track */

/*
 * commands
 */
#define	RESTORE		0x10	/* restore command */
#define READ_SECTOR	0x20	/* read one or more sectores */
#define WRITE_SECTOR	0x30	/* write one or more sectors */
#define	WRITE_FORMAT	0x50	/* format one track */
#define SEEK		0x70	/* seek command */
#define SET_PARM	0x91	/* set drive parameters */

/*
 * error register
 */
#define	BAD_BLOCK	0x80	/* bad block detect */
#define	HARD_ECC	0x40	/* uncorrectable ECC error in data field */
#define	NOT_FOUND	0x10	/* id not found */
#define	ABORTED_CMD	0x04	/* aborted command */
#define	TK0000		0x02	/* track 000 error */
#define	DAM_NF		0x01	/* DAM not found */

/*
 * Status register
 */
#define ERROR		0x01	/* bits in error register are set */
#define	INDEX		0x02	/* index mark detected */
#define	SOFT_ECC	0x04	/* corrected ECC error in data field */
#define	DATA_REQUEST	0x08	/* data request */
#define	SEEK_COMPLETE	0x10	/* seek complete */
#define	WRITE_FAULT	0x20	/* write fault */
#define	READY		0x40	/* ready */
#define	BUSY		0x80	/* busy */

