
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)vmtest.h	1.2 88/03/19   */

/*
 *         INTEL CORPORATION PROPRIETARY INFORMATION
 *
 *     This software is supplied under the terms of a license 
 *    agreement or nondisclosure agreement with Intel Corpo-
 *    ration and may not be copied or disclosed except in
 *    accordance with the terms of that agreement.
 */

/*  @(#)vmtest.h	1.2 88/03/19   */

/* Virtual Memory Tester Data Structures (Kernel) */

/* This structure identifies the page whose state is modified 
 * by the vmctl() system call. pg_optflg defines how the state
 * of the page is modified
 */

struct pginfo {
	int	pg_pid;	/* pid of process to whom this page belongs */
	int	pg_optflg;	/* option flag. See defines below */
	char	*pg_vaddr;	/* virtual address of page */
};

/* Defines for pg_optflg */

#define PG_NULL	0x0	/* Null request */
#define	PG_MKP	0x1	/* Mark the page at pg_vaddr present */
#define	PG_MKNP	0x2	/* Mark the page at pg_vaddr not present */
#define	PG_MKFL	0x4	/* Flush page frame at phys address pg_vaddr */
#define	PG_MKRO	0x8	/* Mark page read-only */
#define	PG_MKSO	0x10	/* Mark page supervisor only */
#define	PG_MKUS	0x20	/* Mark page user/supervisor */
#define	PG_MKRW	0x40	/* Mark page read/write */
#define	PT_MKP	0x80	/* Mark page table present */
#define	PT_MKNP	0x100	/* Mark page table not present */

/* The data that is passed to vmctl() system call.
 * Actually a pointer to this structure in user space
 * is passed as a parameter
 */
struct vmctldat {
	struct pginfo vm_primary;	/* primary page whose state
					 * is modified 
					 */
	struct pginfo vm_onfault;	/* page whose state is modified
					 * when handling fault for
					 * vm_primary page
					 */
};

/* declaration of the Global_On_Fault_Data_Table.
 * This table is searched everytime you get a page fault.
 * When you handle a page which resides in the table in the vm_primary
 * position you go and fiddle with page referred to by the
 * corrosponding vm_onfault field
 */ 

#define	ONFLTSZ	100
extern	struct	vmctldat onflttab[];


/* Definitions for VM Subsystem Trace Package */

/* Maximum length of pathname for the trace file */
#define VNMSZ 100

/* structure definition for data that is written out to the VM Trace
 * file for every trace generated. Structure is such that it's size is a
 * power of 2(to allow integral number of such records to fit a buffer)
 */

struct vmtr{
	unsigned int tr_id;	/* id for the trace record */
	int	tr_gen;		/* process that generated this trace */
	int	tr_pid;		/* process to whom the page belongs */
	paddr_t tr_paddr;	/* page frame address of page */
	caddr_t tr_vaddr;	/* virtual address of page */
	int	tr_pte;		/* page table entry of the page */
	int	tr_transition;	/* what's happening. Defines below */
	daddr_t	tr_block;	/* Disk bloxk number */
	ino_t	tr_inode;	/* inode number that is associated with
				 * this page */
	dev_t	tr_device;	/* device on which block resides */
#define PAD 28
	char	tr_pad[PAD];	/* Round size to next power of two */
};

/* Defines for tr_transition */
#define	TR_NP	0x1		/* fault happened due to the page being
				 * not present */
#define	TR_CW	0x2		/* fault due to page marked copy on
				 * write */
#define	TR_PF	0x4		/* protection fault */
#define	TR_FL	0x8		/* page being flushed to disk */
#define	TR_FR	0x10		/* page frame being freed */

/* defines for tr_gen. Who generated this trace */
#define TR_PFAULT 0x01		/* pfault() */
#define TR_VFAULT 0x02		/* vafult() */
#define TR_VHAND  0x04		/* vhand() */
#define TR_VMCTL  0x08		/* vmctl() */
#define TR_PFREE  0x10		/* pfree() */

/* structure for vm trace attributes */

struct vmtattr {
	int	vmt_lev;	/* trace level */
	int	vmt_pid;	/* trace process with this pid */
	char	vmt_file[VNMSZ];/* trace file name */
	struct inode *vmt_inode;/* inode pointer of trace file */
	struct buf *vmt_buf;	/* buffer pointer of tace data */
	int	vmt_bufoff;	/* offset in buffer for next rec */
	int	vmt_filesz;	/* max size of vm trace file */
	off_t	vmt_off;	/* current offset into the file */
	unsigned int vmt_trid;	/* trace id for the next trace */
	int	vmt_state;	/* see defines below */
};

/* defines for vmt_lev */

#define	TR_INVALID 0x0		/* invalid request */
#define TR_DISABLE 0x1		/* Disable Trace */
#define TR_ENABLE  0x2		/* Enable trace for all processes */
#define TR_ONEPROC 0x4		/* Trace a single process */
#define TR_FILE	   0x8		/* Use given file name for trace */
#define TR_DEBUG   0x10		/* Print debug messages on console */
#define TR_SIZE	   0x20		/* set max trace file size */

/* defines for vmtattr.vmt_state */

#define V_LOCK	0x1		/* vm trace package mutually excluded */
#define V_WANT  0x2		/* process is waiting to enter */
