/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	@(#)user.h	1.42 88/03/19  */


/*
 * The user structure.
 * One allocated per process.
 * Contains all per process data that doesn't need to be referenced
 * while the process is swapped.
 * The user block is USIZE*click bytes long; resides at virtual kernel
 * address 0xff800000 for the 386;
 * contains the system stack per user for exec system call only;
 * is cross referenced with the proc structure for the same process.
 * NOTE: any fields references by user programs, such as adb, ps,
 * etc., should go at the start of the struct, so their offsets
 * don't change when members are added or removed.  If you add a 
 * new field that will be used by user programs, put it near the
 * front!
 */

#ifndef NBPP
#include "sys/immu.h"
#endif
 
#define	PSARGSZ	80	/* Space in u-block for exec arguments.	*/
			/* Used by ps command.			*/

#define	PSCOMSIZ	DIRSIZ	/* For the time being set PSCOMSIZ */
				/* to DIRSIZ until we can get rid of */
				/* struct direct u_dent */

#define	SYSMASKLEN	4	/* Number of longs in syscall bit masks */

#define	KSTKSZ		4096

#define MAXWNPATH	64	/* maximum pathlen for filenames on WORKNET */

typedef	struct	user
{
	char	u_stack[KSTKSZ];/* kernel stack */
/* !!! DON'T MOVE u_ubptbl[6] WITHIN user.h, IT IS EXPECTED HERE !!! */
	pde_t	u_ubptbl[6];		/* Store the ublock page table pointer*/
					/* in the u-area rather than in a */
					/* page.*/
					/* u_ubptbl[0] points to the stack */
					/* u_ubptbl[1] points to the uarea */
					/* u_ubptbl[2] is an extra entry   */

	struct tss386 *u_tss;		/* pointer to user TSS */
	char	u_psargs[PSARGSZ];	/* arguments from exec system call */

	char	u_comm[PSCOMSIZ];
	unchar	u_error;	/* return error code, must be unsigned, errs
		> 127 now exist! */
	char    u_fpvalid;	/* flag if saved floating pt state is valid */
	ushort	u_sztss;		/* size of tss (including bit map) */

	ushort	u_fcsel;		/* first code selector (286) */
	ushort	u_fdsel;		/* first data selector (286) */
	ushort	u_ldsel;		/* last data selector (286) */
	short	u_segflg;		/* IO flag: see below for values */

	label_t	u_rsav;		/* label variable for save/resume */
	unsigned *u_ar0;	/* address of users saved registers */
	struct proc *u_procp;	/* pointer to proc structure */

	/* put new fields accessed by user programs BEFORE this comment */

	/* put all other char variables here */
	char	u_sdsaved;		/* set if xenix shared data is saved */
	char	u_acflag;
	char	u_nshmseg;	/* Nbr of shared memory currently attached
		to the process.	*/
	char	u_WNkernfd;	/* rem fd to use during WORKNET remote exec/core */

	ushort 		u_rflags;	/* flags for distribution DU */
	ushort	u_uid;		/* effective user id */
	ushort	u_gid;		/* effective group id */
	ushort	u_ruid;		/* real user id */
	ushort	u_rgid;		/* real group id */
	short	u_fmode;	/* file mode for IO */
	ushort	u_pbsize;	/* Bytes in block for IO */
	ushort	u_pboff;	/* offset in block for IO */
	short	u_errcnt;	/* syscall error count */
	short	u_retry;		/* Retry page fault instruction */
	short	u_cmask;		/* mask for file creation */
	short	u_lock;			/* process/text locking flags */
	ushort	u_remtty;		/* remote /dev/tty WORKNET */

	dev_t	u_pbdev;	/* real device for IO */
	dev_t	u_ttyd;			/* controlling tty dev */

	ushort u_fdlimit;		/* size of first data segment (286) */

	/* seg:off bottom of user data before brks (286) */
	ushort	u_initseg;		/* initial segment (286) */
	ushort	u_initoff;		/* offset (286) */

	short	u_lockcnt;		/* count of multi-processors locks held
				by this process.  MUST be zero at switch */

	char	*u_comp;	/* pointer to current component */
	char	*u_nextcp;	/* pointer to beginning of next */
	int	*u_qsav;	/* label variable for signals and (on stack in
		systrap() to keep in local memory) */

	ulong	u_sub; /* stack upper and lower bounds.  They are USER */
	ulong	u_slb; /* VIRTUAL addresses, NOT kernel linear addresses. */
	
	int	u_caddrflt;	/* Ptr to function to handle user space
		external memory faults encountered in the kernel. */

		/* following for Distributed UNIX */
	unsigned 		u_syscall;	/* system call number */
	int		u_mntindx;	/* mount index from sysid */
	struct sndd	*u_gift;	/* gift from message      */
	struct response	*u_copymsg;	/* copyout unfinished business */
	struct msgb	*u_copybp;	/* copyin premeditated send    */
	char 		*u_msgend;	/* last byte of copymsg + 1    */
		/* end of Distributed UNIX */
	
	long	u_bsize;		/* block size of device */

	ulong	u_renv;	/* runtime environment, for V7/Xenix3/Xenix5
		system calls that are different (low word same meaning
		as 286/386cindy, for bits in high word see below) */

	union {			/* syscall return values */
		struct	{
			int	r_val1;
			int	r_val2;
		}r_reg;
		off_t	r_off;
		time_t	r_time;
	} u_r;

	caddr_t	u_base;		/* base address for IO */
	unsigned u_count;	/* bytes remaining for IO */
	off_t	u_offset;	/* offset in file for IO */
	daddr_t	u_rablock;	/* read ahead block address */

	struct inode *u_ttyip;	/* inode of controlling tty (streams) */
	struct inode *u_cdir;	/* current directory */
	struct inode *u_rdir;	/* root directory */
	struct inode *u_pdir;	/* inode of parent directory of dirp */
	caddr_t	u_dirp;		/* pathname pointer */
	struct direct u_dent;	/* current directory entry */
	int	u_sysabort;	/* Debugging: if set, abort syscall */
	int	u_systrap;	/* Are any syscall mask bits set? */ 
	long	u_entrymask[SYSMASKLEN]; /* syscall stop-on-entry mask */
	long	u_exitmask[SYSMASKLEN];	/* syscall stop-on-exit mask */
	long 	u_rcstat; 	/* Client cache status flags */

	int	*u_ap;		/* pointer to arglist */
	char 	*u_ldtp;	/* used by adb to read core files */

	void (*u_signal[MAXSIG])();	/* disposition of signals */
	void (*u_sigreturn)();		/* for cleanup */

	time_t	u_utime;	/* this process user time */
	time_t	u_stime;	/* this process system time */
	time_t	u_cutime;	/* sum of childs' utimes */
	time_t	u_cstime;	/* sum of childs' stimes */

	/* The offsets of these elements must be reflected in ttrap.s
		and misc.s */
	struct {			/* profile arguments */
		short	*pr_base;	/* buffer base */
		unsigned pr_size;	/* buffer size */
		unsigned pr_off;	/* pc offset */
		unsigned pr_scale;	/* pc scaling */
	} u_prof;

	short  *u_ttyp;			/* pointer to pgrp in "tty" struct */

	/* Executable file info.  */
	struct exdata {
			struct	inode  *ip;
			ulong	ux_tsize;	/* text size (bytes) */
			ulong	ux_dsize;	/* data size (bytes) */
			ulong	ux_bsize;	/* bss size  (bytes) */
			ulong	ux_lsize;  	/* lib size  (bytes) */
			long	ux_nshlibs; 	/* number of shared libs needed */
			ulong	ux_toffset;	/* file offset to raw text      */
			ulong	ux_doffset;	/* file offset to raw data      */
			ulong	ux_loffset;	/* file offset to lib sctn      */
			ulong	ux_txtorg;	/* start addr. of text in mem   */
			ulong	ux_datorg;	/* start addr. of data in mem   */
			ulong	ux_entloc;	/* entry location               */
			short	ux_mag;   	/* magic number */
			short	ux_FILL;   	/* fill to long align */
	} u_exdata;

	unsigned u_tsize;	/* text size (clicks) */
	unsigned u_dsize;	/* data size (clicks) */
	unsigned u_ssize;	/* stack size (clicks) */
	long   u_execsz;	/* size in clicks at exec */

	time_t	u_start;
	time_t	u_ticks;
	long	u_mem;
	long	u_ior;
	long	u_iow;
	long	u_iosw;
	long	u_ioch;

	daddr_t	u_limit;		/* maximum write address */

	int	u_cpubits;		/* List of processors allowed at resume */

	/* begin WORKNET stuff */
	unchar u_sockref[LIMHOST];	/* ref count per host WORKNET */
	short u_osocket[LIMHOST];	/* sockets for other hosts WORKNET */
	char u_sysname[DIRSIZ];	/* current system name WORKNET */
	char u_WNtmpbuf[MAXWNPATH];	/* WORKNET for WNaccess, and remote symlinks */
	long	u_netmap;		/* network permission map WORKNET */
	char	*u_wbp;		/* for WORKNET buff writes */
	/* end WORKNET stuff */

	int     u_fper;             /* FP error register */
	struct {                    /* floating point work area */
		/*
		 *  If a numeric processor is present in the system,
		 *  this area is used to hold the floating point
		 *  registers and environment.
		 *
		 *  If the floating point emulator is being used,
		 *  this area is the data segment for the emulator.
		 *  Only the control word and the status word are
		 *  needed by the kernel.
		 */
		char	fp_spare1[2];	/* (used by emulator) */
		ushort	fp_cntrl;	/* control word */
		ushort	fp_stat;	/* status word */
		ushort	fp_icntrl;	/* initial setting of control word */
		char    fp_spare2[260]; /* (used by emulator) */
	} u_fps;

	 /* NOTE: any fields references by user programs, such as adb, ps,
	 * etc., should go at the start of the struct, so their offsets
	 * don't change when members are added or removed.  If you add a 
	 * new field that will be used by user programs, put it near the
	 * front! (However, sdb looks at u_fps... so put new field after
	 * this comment until next time the world requires re-compiling
	 */

	int	(*u_send)();		/* function to send a buffered write */
	int	u_sarg1;		/* args for u_send */
	int	u_sarg2;		/* args for u_send */
	int	u_sarg3;		/* args for u_send */
	char	*u_pofile;	/* Ptr to open file flag array.	 */
	struct file	*u_ofile[1];	/* Start of array of pointers	*/
					/* to file table entries for open files.	*/
	/* note that ofile is actually an array whose size is determined
		by v.v_nofiles.  u.u_pofile points immediately after the end
		of this array, and it's size is determined the same way.
		The LDT table immediately follows the pofile array.
	*/
} user_t;

extern struct user u;

#define	u_rval1	u_r.r_reg.r_val1
#define	u_rval2	u_r.r_reg.r_val2
#define	u_roff	u_r.r_off
#define	u_rtime	u_r.r_time

/* u_segflg values: defines the address space to be used by copyin/copyout */

#define	U_UD	0		/* User data space */
#define	U_KD	1		/* Kernel data space, pagefaults not allowed */
#define	U_UI	2		/* User instruction space */
#define	U_KDF	3		/* Kernel data space, (used for loading user) */

#define	EXCLOSE	01

/* distribution: values for u_rflags */
#define FREMOTE	0x0040	/* file is remote(unix rfs). */

/* rcstat values: for client caching */
#define	U_RCACHE	0x1
#define	U_RSYS		0x0004	/* system call has gone remote */
#define	U_DOTDOT	0x0200
#define U_RCOPY		0x0400	/*used by copyout for non-delay copy*/

#ifdef INKERNEL
	/* some, like ISCOFF, conflict with other include
	files, and these apply only in the kernel anyway */

/*	defines for high word of u_renv; they do NOT correspond to x.out.h.
	low byte of high word corresponds to x_cpu in x.out.h.
*/
#define U_CPUTYPE	(XC_CPU<<16)
#define U_IS386	(XC_386<<16)
#define U_IS286	(XC_286<<16)
#define U_IS8086	(XC_8086<<16)
#define U_ISWSWAP	(XC_WSWAP<<16)	/* see wordswap.h */
#define U_ISCOFF	0x1000000
#define U_ISAOUT	0x2000000
#define U_ISOLDAOUT	0x4000000	/* needs extra seg for jam area */
#define U_FIXEDSTK	0x8000000	/* 286 lg model has fixed stk */
#define U_ISATS52       0x10000000	/* altos 386 V5.2 binary */
					/* It has small jame area : 128 bytes */
					/* long, int, float... are aligned to 
					   2 bytes boundary */

#define ISALTOS52	(u.u_renv & U_ISATS52)	/* is a Altos 5.2 binary ? */
#define IS386 ((u.u_renv&U_CPUTYPE)==U_IS386) /* binary is compiled for the 386 */
#define ISCOFF (u.u_renv & U_ISCOFF)	/* is a 386 COFF binary */

#define IS_AOUT	(u.u_renv & U_ISAOUT)	/* OLD xenix binary with an a.out NOT x.out header */
#endif
