/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)tty.h	1.15 88/03/19 	*/

/*
 * A clist structure is the head of a linked list queue of characters.
 * The routines getc* and putc* manipulate these structures.
 */

struct clist {
	int	c_cc;		/* character count */
	struct cblock *c_cf;	/* pointer to first */
	struct cblock *c_cl;	/* pointer to last */
};

/**** WARNING: make sure non-contiguous cblocks are allocated in right place! */
#define CMATCH(pointer)		(unsigned char *)(cfree + (pointer - cfree))

/* Character control block for interrupt level control	*/

struct ccblock {
	caddr_t	c_ptr;		/* buffer address	*/
	ushort	c_count;	/* character count	*/
	ushort	c_size;		/* buffer size		*/
};

/* transparent printer info */
struct xprinfo {
	struct proc	*xprocp;	/* printing process */
	struct inode *xip;		/* fifo file associated with this tty */
	short	xpgrp;		/* save process group */
	short	xoflag; 	/* save output flags */
	char	xstate;		/* save tty state -- IASLP value only */
	char	xcol;		/* save column -- for software tab expansion */
};

/*
 * A tty structure is needed for each UNIX character device that
 * is used for normal terminal IO.
 */
#define	NCC	8
struct tty {
	struct	clist t_rawq;	/* raw input queue */
	struct	clist t_canq;	/* canonical queue */
	struct	clist t_outq;	/* output queue */
	struct	ccblock	t_tbuf;	/* tx control block */
	struct	ccblock t_rbuf;	/* rx control block */
	int	(* t_proc)();	/* routine for device functions */
	ushort	t_iflag;	/* input modes */
	ushort	t_oflag;	/* output modes */
	ushort	t_cflag;	/* control modes */
	ushort	t_lflag;	/* line discipline modes */
	short	t_state;	/* internal state */
	short	t_pgrp;		/* process group name */
	dev_t	t_dev;		/* major/minor dev number */
	struct xprinfo t_xpr;
	char	t_line;		/* line discipline */
	char	t_delct;	/* delimiter count */
	char	t_term;		/* terminal type */	
	char	t_tmflag;	/* terminal flags */
	char	t_col;		/* current column */
	char	t_row;		/* current row */
	char	t_vrow;		/* variable row */
	char	t_lrow;		/* last physical row */
	char	t_hqcnt;	/* no. high queue packets on t_outq */	
	char	t_dstat;	/* used by terminal handlers
						and line disciplines */
	unsigned char	t_cc[NCC+2];	/* settable control chars */
	unsigned char	t_modem;	/* for [GS]ETMODEM and MIOB[GS]ET ioctl's,
		controls whether HUPCLS and CLOCAL can be changed
		(MDM_* are in bits 4 and 5, CTS/DSR in bits 0 and 1) */
	unsigned char	t_flow;	/* type of flow control.  */
	unsigned char t_nxmit;	/* number of characters currently being
		transmitted by 'intelligent' comm board.  Used by transmit 
		interrupt handlers. */
};

/*
 * The structure of a clist block
 */
#define	CLSIZE	122	/* a cblock is 128 chars */
struct cblock {
	struct cblock *c_next;
	char	c_first;
	char	c_last;
	char	c_data[CLSIZE];
};

extern struct cblock	*cfree;
extern struct cblock	*getcb();
extern struct cblock	*getcf();
extern struct clist	ttnulq;
extern int		cfreecnt;

struct chead {
	struct cblock *c_next;
	int	c_size;
	int	c_flag;
};
extern struct chead cfreelist;

struct inter {
	int	cnt;
};

#define	QESC	0200	/* queue escape */
#define	HQEND	01	/* high queue end */

#define	TTIPRI	28
#define	TTOPRI	29

#ifdef u3b5
/* following defs allow for job control in both vpm and stand-alone
   tty environments */
#define VPMTTY	1
#define SATTY	2
#endif

/* limits */
extern int ttlowat[], tthiwat[];
#define	TTYHOG	256
#define	TTXOLO	132
#define	TTXOHI	180
#define	TTECHI	80

/* Hardware bits */
#define	DONE	0200
#define	IENABLE	0100
#define	OVERRUN	040000
#define	FRERROR	020000
#define	PERROR	010000

/* Internal state */
#define	TIMEOUT	01		/* Delay timeout in progress */
#define	WOPEN	02		/* Waiting for open to complete */
#define	ISOPEN	04		/* Device is open */
#define	TBLOCK	010
#define	CARR_ON	020		/* Software copy of carrier-present */
#define	BUSY	040		/* Output in progress */
#define	OASLP	0100		/* Wakeup when output done */
#define	IASLP	0200		/* Wakeup when input done */
#define	TTSTOP	0400		/* Output stopped by ctl-s */
#define	EXTPROC	01000		/* External processing */
#define	TACT	02000
#define	CLESC	04000		/* Last char escape */
#define	RTO	010000		/* Raw Timeout */
#define	TTIOW	020000
#define	TTXON	040000
#define	TTXOFF	0100000

/* l_output status */
#define	CPRES	0100000

/* device commands */
#define	T_OUTPUT	0
#define	T_TIME		1
#define	T_SUSPEND	2
#define	T_RESUME	3
#define	T_BLOCK		4
#define	T_UNBLOCK	5
#define	T_RFLUSH	6
#define	T_WFLUSH	7
#define	T_BREAK		8
#define	T_INPUT		9
#define T_DISCONNECT	10
#define	T_PARM		11
#define	T_SWTCH		12
#define	T_WSWTCH	13	/* for window driver */
#define	T_WAIT		14	/* for Ethernet pty driver */

/*
 * Terminal flags (set in t_tmflgs).
 */

#define SNL	1		/* non-standard new-line needed */
#define ANL	2		/* automatic new-line */
#define LCF	4		/* Special treatment of last col, row */
#define TERM_CTLECHO	010	/* Echo terminal control characters */
#define TERM_INVIS	020	/* do not send escape sequences to user */
#define QLOCKB		040	/* high queue locked for base level */
#define QLOCKI		0100	/* high queue locked for interrupts */
#define	TERM_BIT 0200		/* Bit reserved for terminal drivers. */
				/* Usually used to indicate that an esc*/
				/* character has arrived and that the  */
				/* next character is special.          */
				/* This bit is the same as the TM_SET  */
				/* bit which may never be set by a user*/
/*
 *	device reports
 */
#define	L_BUF		0
#define	L_BREAK		3

#ifdef INKERNEL

struct xpr_info {
	struct tty * tp;
	int maxd;	/* highest minor number supported */
};

extern	struct cblock	*cfree;
extern	struct clist	ttnulq;
extern	struct chead	cfreelist;
extern	int	ttlowat[], tthiwat[];
extern	struct cblock	*getcb();
extern	struct cblock	*getcf();
extern struct xpr_info ttys[];	/* array of pointers to tty structs.  Points to
	the base of each 'tty' type device's tty struct array.  One
	for each char device.  Allocated in space.h.  Used for
	transparent printer garbage.  Must be filled in by devices
	initialization routine or first open of device.  If non-null,
	transparent printers will be allowed on the device */
#endif /* INKERNEL */
