/*
 *	@(#) ttold.h 1.2 86/10/13 
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/*
/*  @(#)ttold.h	1.9 88/03/19 	*/




/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.
 */



/*
 * Structure for stty and gtty system calls.
 */
/****** XENIX binary version *******/
#pragma pack(2)
struct sgttyb_xenix {
	char	sg_ispeed;
	char	sg_ospeed;
	char	sg_erase;
	char	sg_kill;
	short	sg_flags;
};
#pragma pack()

/******* COFF binary version *******/
struct sgttyb_coff {
	char	sg_ispeed;
	char	sg_ospeed;
	char	sg_erase;
	char	sg_kill;
	int	sg_flags;
};

/*
 * List of special characters
 */
struct tc	{
	char	t_intrc;
	char	t_quitc;
	char	t_startc;
	char	t_stopc;
	char	t_eofc;
	char	t_brkc;
};

/* modes */
#define	O_TANDEM	01			/* Xenix binaries only */
#define	N_HUPCL		01

#define	O_CBREAK	02			/* Xenix binaries only */
#define	N_XTABS		02			/* COFF  binaries only */

#define	O_LCASE		04
#define	O_ECHO		010
#define	O_CRMOD		020
#define	O_RAW		040
#define	O_ODDP		0100
#define	O_EVENP		0200
#define O_ANYP		0300

#define	O_NL1		000400
#define	O_NL2		001000
#define	O_NLDELAY	001400

#define	O_TAB1		002000
#define	O_TAB2		004000			/* Xenix binaries only */
#define N_NOAL		004000			/* COFF  binaries only */
#define	N_TBDELAY	002000			/* COFF  binaries only */
#define	O_TBDELAY	006000			/* Xenix binaries only */
#define	O_XTABS		006000			/* Xenix binaries only */

#define	O_CR1		010000
#define	O_CR2		020000
#define	O_CRDELAY	030000

#define	O_VTDELAY	040000
#define	O_BSDELAY	0100000
#define O_ALLDELAY 	0177400

#define N_CBREAK	0x80000000		/* COFF binaries only */
