
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)trap.h	1.3 88/03/19   */

/*
 * Trap type values
 */

#define	DIVERR		0	/* divide by 0 error		*/
#define	SGLSTP		1	/* single step			*/
#define	NMIFLT		2	/* NMI				*/
#define	BPTFLT		3	/* breakpoint fault		*/
#define	INTOFLT		4	/* INTO overflow fault		*/
#define	BOUNDFLT	5	/* BOUND instruction fault	*/
#define	INVOPFLT	6	/* invalid opcode fault		*/
#define	NOEXTFLT	7	/* extension not available fault*/
#define	DBLFLT		8	/* double fault			*/
#define	EXTOVRFLT	9	/* extension overrun fault	*/
#define	INVTSSFLT	10	/* invalid TSS fault		*/
#define	SEGNPFLT	11	/* segment not present fault	*/
#define	STKFLT		12	/* stack fault			*/
#define	GPFLT		13	/* general protection fault	*/
#define	PGFLT		14	/* page fault			*/
#define	EXTERRFLT	16	/* extension error fault	*/

/*
 *  Values of error code on stack in case of page fault 
 */

#define	PF_ERR_MASK	0x01	/* Mask for error bit */
#define PF_ERR_PAGE	0	/* page not present */
#define PF_ERR_PROT	1	/* protection error */
#define PF_ERR_WRITE	2	/* fault caused by write (else read) */
#define PF_ERR_USER	4	/* processor was in user mode
					(else supervisor) */

/*
 * floating point traps
 */
#define TR_SW240	240
#define TR_SW241	241
#define TR_SW242	242
#define TR_SW243	243
#define TR_SW244	244
#define TR_SW245	245
#define TR_SW246	246
#define TR_SW247	247
#define TR_SW248	248
#define TR_SW249	249
#define TR_SW250	250
#define TR_SW251	251
#define TR_SW252	252
#define TR_SW253	253
#define TR_SW254	254
#define TR_SW255	255
