/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)systm.h	1.9 88/03/19   */

/*
 * Random set of variables used by more than one routine.
 */

extern struct inode *rootdir;	/* pointer to inode of root directory */
extern short cputype;		/* type of cpu = 40, 45, 70, 780, 0x3b5 */
extern time_t lbolt;		/* time in HZ since last boot */
extern time_t time;		/* time in sec from 1970 */
extern int     Timezone;        /* configurable timezone */
extern int     Dstflag;         /* configurable DST flag  */

extern char runin;		/* scheduling flag */
extern char runout;		/* scheduling flag */
extern char runrun[];		/* scheduling flag - one per processor */
extern char curpri[];		/* current priority - one per processor */
extern struct proc *curproc[];	/* current proc - one per processor */
extern struct proc *oldproc[];	/* previous proc that exited - per processor */
extern struct proc *runq;	/* head of linked list of running processes */

extern		maxmem;		/* max available memory (clicks) */
extern		physmem;	/* physical memory (clicks) on this CPU */
extern		maxclick;	/* Highest physical click + 1.		*/
extern daddr_t	swplo;		/* block number of start of swap space */
extern		nswap;		/* size of swap space in blocks*/
extern dev_t	rootdev;	/* device of the root */
extern dev_t	swapdev;	/* swapping device */
extern dev_t	pipedev;	/* pipe device */
extern dev_t	dumpdev;	/* dump device */
extern char	*panicstr;	/* panic string pointer */
extern		blkacty;	/* active block devices */
extern		pwr_cnt, pwr_act;
extern int 	(*pwr_clr[])();

dev_t getmdev();
struct inode *iget();
struct inode *namei();
struct inode *remote_call();
struct buf *getblk();
struct buf *geteblk();
struct buf *bread();
struct buf *breada();
struct file *falloc();
int	upath(), spath();
struct proc *prfind();

#define XENIX_ENT (int (*)()) 0	/* use cxsysent table */
#define XUTS_ENT (int (*)()) 1	/* use xutssysent table */
#define ALTOS_ENT (int (*)()) 2	/* use clsysent table */
#define SYSENTSW 2	/* highest index of tertiary tables */

/*
 * Structure of the system-entry table
 */
extern struct sysent {
	char	sy_narg;		/* total number of arguments */
	char	sy_setjmp;		/* 1 if systrap() should NOT do a setjmp() */
	ushort	sy_amask;	/* mask for converting args for 286 programs */
	int	(*sy_call)();		/* handler */
}	sysent[], v7sysent[], s3sysent[], s53sysent[], *sysent_sw[];

extern int maxsyscall;	/* maximum index in sysent */
extern int maxsys_sw[];	/* array of max indices in tertiary tables */

/*	Argument types for converting 286 syscall args. Types not here,
	or values of zero in the mask do not need to be sign extended
	or otherwise adjusted.
*/
#define	DATAP	 (unchar)0x01		/* argument is a DATA pointer */
#define TEXTP	 (unchar)0x02		/* argument is a TEXT pointer */
#define	SIGNED	 (unchar)0x03		/* argument must be sign extended */
#define	LONG	 (unchar)0x04		/* argument is a long constant */

/* sy_mask is used only in sysent.c */
#define sy_mask(arg1,arg2,arg3,arg4)	\
	(ushort)(((((((arg4) << 3) | arg3) << 3) | arg2) << 3) | arg1 )
