/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)sysmacros.h	1.8 88/05/13   */

/*
 * Some macros for units conversion
 */

/* Core clicks to page tables and vice versa */
/* This is still called ctos, etc to avoid large scale
 * changes in the code. "Segment" here means the
 * memory spanned by a page table.
 */

#define ctos(x)		(((x) + (NCPPT-1)) >> CPPTSHIFT)
#define	ctost(x)	((x) >> CPPTSHIFT)
#define	stoc(x)	((x) * NCPPT)

/* Core clicks to disk blocks */
#define	ctod(x) ((x)*NDPC)

/* inumber to disk address */
#ifdef INOSHIFT
#define	itod(x)	(daddr_t)(((unsigned)(x)+(2*INOPB-1))>>INOSHIFT)
#else
#define	itod(x)	(daddr_t)(((unsigned)(x)+(2*INOPB-1))/INOPB)
#endif

/* inumber to disk offset */
#ifdef INOSHIFT
#define	itoo(x)	(int)(((unsigned)(x)+(2*INOPB-1))&(INOPB-1))
#else
#define	itoo(x)	(int)(((unsigned)(x)+(2*INOPB-1))%INOPB)
#endif

/* clicks to bytes */
#ifdef BPCSHIFT
#define	ctob(x)	((x)<<BPCSHIFT)
#else
#define	ctob(x)	((x)*NBPC)
#endif

/* bytes to clicks */
#ifdef BPCSHIFT
#define	btoc(x)	(((unsigned)(x)+(NBPC-1))>>BPCSHIFT)
#define	btoct(x)	((unsigned)(x)>>BPCSHIFT)
#else
#define	btoc(x)	(((unsigned)(x)+(NBPC-1))/NBPC)
#define	btoct(x)	((unsigned)(x)/NBPC)
#endif

#if INKERNEL && u3b2

/* major part of a device internal to the kernel */

extern char MAJOR[128];
#define	major(x)	(int)(MAJOR[(unsigned)((x)>>8)&0x7F])
#define	bmajor(x)	(int)(MAJOR[(unsigned)((x)>>8)&0x7F])

/* minor part of a device internal to the kernel */
extern char MINOR[128];
#define	minor(x)	(int)(MINOR[(unsigned)((x)>>8)&0x7F]+((x)&0xFF))

#else

/* major part of a device external from the kernel */
#define	major(x)	(int)((unsigned)((x)>>8)&0x7F)
#define	bmajor(x)	(int)((unsigned)((x)>>8)&0x7F)

/* minor part of a device external from the kernel */
#define	minor(x)	(int)(x&0xFF)
#endif	/* INKERNEL && u3b2 */

/* make a device number */
#define	makedev(x,y)	(dev_t)(((x)<<8) | (y))

/*
 *   emajor() allows kernel/driver code to print external major numbers
 *   eminor() allows kernel/driver code to print external minor numbers
 */
#define emajor(x)	(int)(((unsigned)(x)>>8)&0x7F)
#define eminor(x)	(int)((x)&0xFF)

/*	Calculate user process priority.
*/

#define calcppri(p)	((p->p_cpu) >> 1) +  p->p_nice + (PUSER - NZERO)

/*
 *  Evaluate to true if the process is a server - Distributed UNIX
 */
#define	server()	(u.u_procp->p_sysid != 0)

#define	STRUCTOFF(structure, field)	(int) &(((struct structure *) 0)->field)

/* same as STRUCTOFF, but no & required, (avoids error messages from cc) */
#define	ARRAYOFF(structure, field)	(int) (((struct structure *) 0)->field)

#define	btodb(x)	(x / DEV_BSIZE)

/*
 * bit map related macros
 */
#define	setbit(a,i)	((a)[(i)/NBBY] |= (uchar_t)(1<<((i)%NBBY)))
#define	clrbit(a,i)	((a)[(i)/NBBY] &= (uchar_t)(~(1<<((i)%NBBY))))
#define	isset(a,i)	((a)[(i)/NBBY] & (uchar_t)(1<<((i)%NBBY)))
#define	isclr(a,i)	(((a)[(i)/NBBY] & (uchar_t)(1<<((i)%NBBY))) == 0)


/*	these generate better code, at least with the RCC compiler as of
	4/88.  assumes NBBY is a power of 2 */
#define BBYSHFT 3 /* log2(NBBY) */
#define BBYMSK ((unchar)(NBBY-1))
#define BITINBYTE(n) ((((unchar)1)<<((n)&BBYMSK)))
#define	nsetbit(a,i)	((a)[(i)>>BBYSHFT] |= BITINBYTE(i))
#define	nclrbit(a,i)	((a)[(i)>>BBYSHFT] &= ~BITINBYTE(i))
#define	nisset(a,i)	((a)[(i)>>BBYSHFT] & BITINBYTE(i))
#define	nisclr(a,i)	(!nisset((a), (i)))

/*
 * Defined for RFS client caching
 */

extern int rcacheinit;			/* RFS client caching flag */
extern unsigned long rfs_vcode;		/* version code for RFS caching */

#define CLOSEI(ip, fp) \
{ \
	if (rcacheinit && (ip)->i_ftype == IFREG && (fp)->f_count == 1 \
		&& !server() && (fp)->f_flag & FWRITE) { \
		(ip)->i_wcnt--; \
		if ((ip)->i_flag & IWROTE && (ip)->i_wcnt == 0) { \
			(ip)->i_flag &= ~IWROTE; \
			if ((ip)->i_rcvd) \
				enable_cache((ip)->i_rcvd); \
		} \
	} \
	FS_CLOSEI(ip, fp); \
}

#define OPENI(ip, mode) \
{ \
	if (rcacheinit && (ip)->i_ftype == IFREG && !server() && (mode) & FWRITE) \
		(ip)->i_wcnt++; \
	FS_OPENI(ip, mode); \
}

#define WRITEI(ip) \
{ \
	if (rcacheinit && (ip)->i_ftype == IFREG) { \
		if (!server()) (ip)->i_flag |= IWROTE; \
		(ip)->i_vcode = ++rfs_vcode; \
		if ((ip)->i_rcvd) disable_cache(ip); \
	} \
	FS_WRITEI(ip); \
}

#define ITRUNC(ip, len) \
{ \
	if (rcacheinit && (ip)->i_ftype == IFREG) { \
		if (!server()) (ip)->i_flag |= IWROTE; \
		(ip)->i_vcode = ++rfs_vcode; \
		if ((ip)->i_rcvd) disable_cache(ip); \
	} \
	FS_ITRUNC(ip, len); \
}

#define IPUT(ip) \
{ \
	if(rcacheinit && (ip)->i_nlink <= 0 && (ip)->i_count == 1) \
		(ip)->i_vcode = ++rfs_vcode; \
	FS_IPUT(ip); \
}

#define FREESP(ip, arg, flag, offset) \
{ \
	if (rcacheinit && (ip)->i_ftype == IFREG) { \
		if (!server()) \
			(ip)->i_flag |= IWROTE; \
		(ip)->i_vcode = ++rfs_vcode; \
		if ((ip)->i_rcvd) \
			disable_cache(ip); \
	} \
	FS_FCNTL(ip, F_FREESP, arg, flag, offset); \
}
