/*
 *	@(#) sysconf.h 1.3 88/03/19 
*/

/* Union for sysconf() system call.  Returns information about
 * the system configuration.  Unused portion of u_maxsize is
 * for future expansion.  Be SURE you use the whole union, or
 * programs using this system call may fail under future
 * releases.
 */

union u_sysconf {
	struct usysinfo {
		/* Comm-board types indexed by board jumper, NOT physical */
		/* slot position.  See bootinfo.h for board types.        */
		unsigned char comtype[16];
		short nprocs;	/* Maximum number of processes allowed. */
		unsigned long physize;	/* Size physical of memory (bytes). */
		unsigned long freemem;	/* Size of free memory (bytes). */
		unsigned long fpinstall; /* Floating point processor present. */
		char version[16];	/* version number */
		unsigned long cpupresent;	/* cpu present bitmask */
		/* Number of ttys per comm-board, indexed by board jumper */
		/* This is used by the devinfo command. Particularly useful */
		/* on the Series 1000. */
		short ttysperbrd[16];
	} u_info;
	char u_maxsize[128];
};
