
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)seg.h	1.19 88/03/19 	*/

/*
 * The segment structure is prototype and place holder for segment descriptors
 * s_base contains the 32 bit base field of the descriptor.
 * s_limacc contains 20 limit bits and 12 accbits in this order
 *
 * 0                      19  20  21      22   23   24  25,26 27-31
 * _____________________________________________________________________________
 * |                                                                           |
 * |   20 bit limit field   | G | B or D | 0 | AVL | P | DPL | Other Attributes|
 * |___________________________________________________________________________|
 * 
 *	The structure gets fixed up at run time to look like a descriptor
 *
 */

/* segment */
struct seg_desc {
	unsigned long s_base;	/* segment base */
	unsigned long s_limacc;	/* 4 limit and access bytes */
};

/* descriptor */
struct dscr {
	unsigned short	a_lim0015,
		 	a_base0015;
	unsigned char  	a_base1623,
			a_acc0007;
	unsigned char	a_lim1619:4,
			a_acc0811:4;
	unsigned char	a_base2431;
};

extern struct dscr *ldtp;	/* global pointer to ldt array, which
	is located immediately after the user structure */

/* access rights for data segments */ 
#define UDATA_ACC1	0xF2 	/* present dpl=3 writable */
#define UDATA_RACC1	0xF0 	
#define KDATA_ACC1	0x92	/* present dpl=0 writable */
#define DATA_ACC2	0xC	/* page gran. 4Gb limit avl=0 */
#define UTEXT_ACC1	0xFA 	/* present dpl=3 readable */
#define KTEXT_ACC1	0x9A 	/* present dpl=0 readable */
#define TEXT_ACC2	0xC	/* page gran., 32 bit operands avl=0 */
#define LDT_UACC1	0xE2	/* present dpl=3 type=ldt */
#define LDT_KACC1	0x82	/* present dpl=0 type=ldt */
#define LDT_ACC2	0x0	/* G=0 avl=0*/
#define TSS3_KACC1	0x89 	/* present dpl=0 type=available 386 TSS */
#define	TSS2_KACC1	0x81 	/* present dpl=0 type=available 286 TSS */
#define TSS3_KBACC1     0x8B    /* present dpl=0 type=busy 386 TSS      */
#define TSS3_UACC1	0xE9 	/* present dpl=3 type=available 386 TSS */
#define	TSS2_UACC1	0xE1 	/* present dpl=3 type=available 286 TSS */
#define TSS_ACC2	0x0	/* g=0 avl=0 */
#define GRANBIT	0x8	/* bit in acc0811 for granularity */
#define DEFBIT	0x4	/* code defaults to 32 bit if set in acc0811 */

#define MKDSCR(base, limit, acc1, acc2) {(long)base, ((long)limit|(acc2<<20)|(acc1<<24))}

/* selector definitions */
#define GDT_SEL		0x8	/* alias for gdt itself */
#define IDT_SEL		0x10	/* alias for idt itself */
#define EMULU_SEL	0x2B	/* User selector for [23]87 emulator */
#define LDTSEL		0x58	/* LDT for the current process */
#define DFTSSSEL	0x60	/* TSS for double fault handler */
#define JTSSSEL		0x68	/* Junk TSS to jump thru */
#define KCSSEL		0x70	/* kernel code segment selector */
#define KDSSEL		0x78	/* kernel data segment selector */
#define KSSSEL		0x80	/* kernel stack segment selector */
#define KTSSSEL 	0x88	/* TSS for each potential CPU (plus next 5) */
#ifdef VPIX
#define XTSSSEL         0xC0	/* XTSS for dual-mode processes */
#define UTSSSEL		0xC8	/* TSS for the current vpix process */
#endif
#define DBWORK		0xF8	/* temp for use of kernel debugger */

/* user selectors */
#define	USER_CS		0x17	/* user's code segment */
#define	USER_DS		0x1F	/* user's data segment */
#define	X52_SCALL	0x30	/* call gate for x52 system calls */
#define	USER_SCALL	0x07	/* call gate for system calls */
#define	USER_SIGCALL	0x0F	/* call gate for sigreturn */
#define USTKFP_SEL	0x27	/* used by fp emulator for stack selector */
#define USERFP_SEL	0x2F	/* used by fp emulator for data selector */
/*
 *	The next define is used in xdata.c. CSALIAS_SEL
 *	is a hardwired selector used as the CS alias when execseg
 *	is called from a 386 program. 
 */
#define CSALIAS_SEL	0x37	/* CS alias to DS for 386 programs */

#define IDTSZ		256
extern int _ldtsize;	/* _ldtsize is set in p0init */
#define LDTSZ           _ldtsize
#define GDTSZ 0x40	/* up to seg 0x1F8 */

#define SEL_LDT		4 /* mask to determine if selector is in LDT or GDT */
#define SEL_PRIV	3 /* mask to determine privilege level of selector */

/*
 *  Call/Interrupt/Trap Gate table descriptions
 *
 *	This is the structure used for declaration of Gates.
 *	If this is changed in any way, the code in uprt.s
 *	must be changed to match.  It is especially important
 *	that the type byte be in the last position so that the
 *	real mode start up code can determine if the gate is
 *	intended to be a gate or segment descriptor.
 */

struct gate_desc {
	unsigned long  g_off;		/* offset */
	unsigned short g_sel;		/* selector */
	unsigned char  g_wcount;	/* word count */
	unsigned char  g_type;		/* type of gate and access rights */
};
 
/* what the gate struct looks like after it has been set up in
	start.asm.  This is the 'real' form
*/
struct callgate {
	unsigned short g_offlow;		/* offset */
	unsigned short g_sel;		/* selector */
	unsigned char  g_wcount;	/* word count */
	unsigned char  g_type;		/* type of gate and access */
	unsigned short g_offhi;		/* offset */
};


/* access rights field for gates */

#define GATE_UACC	0xE0		/* present and dpl = 3 */
#define GATE_KACC	0x80		/* present and dpl = 0 */
#define GATE_386CALL	0xC		/* 386 call gate */
#define GATE_386INT	0xE		/* 386 int gate */
#define GATE_386TRP	0xF		/* 386 trap gate */
#define GATE_TSS	0x5		/* Task gate */

/* make an interrupt gate */
#define MKINTG(rtn) {(long)rtn,(short)KCSSEL,(char)0,(char)(GATE_KACC|GATE_386INT)} 
#define MKKTRPG(rtn) {(long)rtn,(short)KCSSEL,(char)0,(char)(GATE_KACC|GATE_386TRP)} 
#define MKUTRPG(rtn) {(long)rtn,(short)KCSSEL,(char)0,(char)(GATE_UACC|GATE_386TRP)} 

#define	seltoi(sel)		((unsigned short)(sel) >> 3)
#define SELSZ sizeof(struct dscr)


/* set the base for a descriptor */
#define SETBASE(dscr, base) { \
	(dscr)->a_base0015 = (ushort)(base); \
	(dscr)->a_base1623 = ((base)>>16) & 0xFF; \
	(dscr)->a_base2431 = ((base)>>24) & 0xFF; \
}

/* set the limit for a descriptor.  Set granularity to one
	byte if limit less than 1Mb.  limit does NOT have one
	subtracted, caller is supposed to set it up correctly.
*/
#define SETLIMIT(dscrp, limit) { \
	register struct dscr *__dscr__ = (dscrp); \
	register unsigned __lim__ = (limit); \
	if(__lim__ < 0x100000) \
		__dscr__->a_acc0811 &= 7;	/* byte granularity */ \
	else { \
		__lim__ >>= BPCSHIFT; \
		__dscr__->a_acc0811 |= 8;	/* page granularity */ \
	} \
	__dscr__->a_lim0015 = __lim__; \
	__dscr__->a_lim1619 = (__lim__>>16)&0xf; \
}
