/*  @(#) scsi.h 1.10 88/03/19 %Q */

/*
 * scsi.h
 *	SCSI Host Driver declarations.
 *	Support for Common Command Set only.
 *
 * Details of the I/O Channel hardware may be found in the internal
 * reference spec for 386e I/O Channel Controller
 *
 */

#define NSCSI		8	/* Number of target controllers */
#define MAXWINI		7	/* Max number of winchesters supported */
#define	NUMSPINDLE	2	/* # spindles per controller */
#define	NUMPAR		16	/* # partitions per spindle */

#define	MAX_TARGET	7
#define	MAX_RETRY	10
#ifndef SECTSZ
#define	SECTSZ		512L
#endif

#define VMAGIC		0xd6d1		/* volume info magic number */

/*******  Values needed but not defined in Unix 5.3 standard header files */
#define B_LOCKED	0x020000	/* locked (not usable) */
#define B_INIT		0x040000	/* initializing with download code */

/*
 * Device Codes.
 */
#define	DEV_HD  	0	/* hard disk */
#define	DEV_FD  	1	/* floppy disk */
#define	DEV_TP  	2	/* tape */		/* KSAM */
#define	STREAMER	2	/* streamer tape (QIC-2)  */
#define DEV_PP  	3	/* parallel printer */
#define	DEV_SC  	4	/* SCSI */
#define STARTSTOP	5	/* start/stop tape (9-track) not used */
#define INITIATOR	7	/* host computer */
#define DEVMASK		7	/* mask to get actual device */
#define INVALID		0xF	/* invalid device code */


/*
 * 	Mapping of minor device number liiipppp is the following:
 *
 *	l       	the logical unit number	(bit  7)
 *	 iii        	the scsi bus id		(bits 6-4)
 *	    pppp	the partition number	(bits 3-0)
 */

#define DEVICE(dev)	(((dev) & 0x0f00) >>8)	/* major device number */
#define SCSIDEV(dev)	(((dev) & 0x0f00) >>8)	/* major device number */
#define SCSILUN(dev)	(0)			/* logical unit number */

/* bus id */
#define SCSIID(dev)	((DEVICE(dev) == DEV_HD) \
			     	? (((dev) & 0x0070) >>4) \
				: (6 - (((dev) & 0x0070) >>4)))
			                 

#define	UNIT(dev)	SCSIID(dev)		/* lun & bus id */
#define	PARTITION(dev)	((dev)  & 0x000f)	/* partition number */
#define SCSIPART(dev)	((dev)  & 0x000f)	/* partition number */


/*
 * Macros to make things easier to read/code/maintain/etc...
 */
#define	IO_OP(bp)	(((bp)->b_flags & B_READ) ? READ_OP : WRITE_OP)
#define ISTAPE(dd) 	((dd)->d_tab.io_devcod == STREAMER)
#define DRIVE(dev)    	(DEVICE(dev) == DEV_HD ? UNIT(dev) : STREAMER)

#define SC_MASK(x)	(((x) >> 8) & 0xfc)
#define SC_TAPE(x)	(((x) >> 8) == 2)
#define SC_STREAM(x)	(((x) & 0xf) == 0xf)

#define	LOW(x)		((x)&0xFF)		/* "low" byte */
#define	HIGH(x)		(((x)>>8)&0xFF)		/* "high" byte */


/*
 * Error Status-Structure, Returned on status inquiry.
 * Note another alignment problem
 */

struct xsense {	/* extended request sense structure */

    unsigned char	x_adval;	/* address valid	*/
    unsigned char	x_resv;		/* reserved		*/
    unsigned char	x_skey;		/* sense key		*/
    unsigned char	x_ibyte[4];	/* information bytes	*/
    unsigned char	x_adlen;	/* additional length	*/
    unsigned char	x_null[4];	/* always zero		*/
    unsigned char	x_ecode;	/* error code		*/
    unsigned char	x_null1[5];	/* more zeros		*/

};


/*
 * Scsi Disk Driver Extensions.  One per controller.  Contains
 * information about the transfer in progress.
 */
struct  scsiext {
	ulong   xfer_addr;      /* current transfer address */
	ulong   xfer_count;     /* current transfer count */
};


/*
 * Partition structure on hard disk layout sector.
 */

struct hd_layout {
	daddr_t	hd_soff;		/* sector offset */
	daddr_t	hd_ssize;		/* size in sectors of the area */
};

/*
 * Partition structure in memory.
 */

struct partition {
	long	p_flags;		/* partition flags */
	daddr_t	p_soff;			/* partition sector offset */
	daddr_t	p_ssize;		/* size in sectors of the partition */
};


/*
 * Bad sector mapping information
 */

#pragma pack(2)
struct mapsec {
	unsigned long	ms_logical;
	unsigned short	ms_bump;
};
#pragma pack()

/* flag for ms_bump, shows added bad sector */
# define	MS_ADDED	0x80000000
# define	MS_SPARE	0x40000000
# define	MS_LSEC(s)	(s & 0x3fffffffL)

/* maximum number of bad sectors (80Mbyte drive, 2 bad secs per Mbyte) */
# define	MAXBAD	256


/*
 * Per-Scsi Device-Data.  One per target controller.
 *
 * These registers reside in host memory; they control
 * the data interchange between the host and the scsi subchannels.
 */
#pragma pack(2)
struct	scsidev {
	struct	iobuf		d_tab; 		/* per-target "dynamic" data */
	struct	xsense		d_sense;	/* per-target err sense date */
	struct  scsiext         d_ext;		/* scsi scatter-gather TBD */
	struct	partition	d_layout[NUMPAR]; /* partition data */
	struct  mapsec 		d_alts[MAXBAD];	/* wini alternate sector map */
};
#pragma pack()

extern struct scsidev scsidev[];


/*
 * Values of buffer-header b_active, used for mutual-exclusion of
 * opens and other I/O requests.
 */
#define	IO_IDLE		0		/* idle -- anything goes */
#define	IO_BUSY		1		/* something going on */
#define	IO_WAIT		2		/* waiting for controller to be idle */
#define	IO_DONE		0x80		/* buffer request if done */

/*
 * Values of internal driver state.
 */

#define	NORMAL		0	/* normal situation */
#define	GET_BAD_STATUS	1	/* retrieving status on hard error */
#define	RESTORING	2	/* recalibrating to track 0 for retry */
#define	INITIALIZING	3	/* going through init-sweep */
#define	READING_LABEL	4	/* reading device label - unused */
#define FORMAT		5	/* unused */
#define T_INIT		9	/* initializing tape controller */
#define T_RESET		10	/* resetting tape drive */
#define T_SOFT_STATUS	11	/* soft status check (for TS_READING) */
#define T_READING_TO_FM	12	/* dumping data to get out of read mode */
#define T_RTFM_STATUS	13	/* status check in T_READING_TO_FM */
#define WRITEFM		14	/* handle end of media		*/


/*
 * Group 0 cmds for direct-access devices
 */
#define TST_UNT_RDY	0x00
#define REZERO_UNT	0x01
#define REQ_SENSE	0x03
#define FORMAT_UNT	0x04
#define REASSIGN_BLK	0x07
#define READ		0x08
#define WRITE		0x0a
#define SEEK		0x0b
#define INQUIRY		0x12
#define MODE_SELECT	0x15
#define MODE_SENSE	0x1a
#define START_STOP	0x1b

#define	IMMED		1	/* return status before complete */
#define	START		1	/* make ready for use */
#define	PRE_LONG	2
#define	TP_OPENOK	1
#define	BUFFER_MODE	0x10
#define	MSENSE_LEN	4
#define	DLIST_LEN	8

/*
 * Important minor devices
 */
#define	PHYSDEV		0	/* physical drive device (nomap) */
#define	SPAREDEV	9	/* spare bad sector map */
#define	DCDEV		10	/* drive configuration device */
#define BADLIST		11	/* bad sector list */
#define BOOTDEV		12	/* wini pri-boot area */
#define	RSTDEV		13	/* restart information */
#define	LAYDEV		14	/* layout information */
#define	MAPDEV		15	/* bad sector map */

/*
 * Where those minor devices are on the hard disk
 */

#define	DROFF		0	/* drive configuration information */
#define	DRSIZ		2	/* really is only one sector */

#define	LAYOFF		1	/* skip drive information */
#define	LAYSIZ		2	/* possible it may be only 1 sector */

#define	MAPOFF		3	/* bad sector map */
#define	MAPSIZ		4	/* maps logical to physical sectors */

#define	BADOFF		6	/* bad sector list */
#define	BADSIZ		2	/* not used, except to build map */

#define	BOOTOFF		8	/* skip config, bad sec list, etc. */
#define	BOOTSIZ	 	8  	/* secondary boot size */


/* general equates */
#define LONGWAIT	0x3fffffff
#define MEDWAIT		0x001fffff
#define TINYWAIT	0x0000ffff
#define SHORTWAIT	0x1fff
#define M_HNIBBLE	0x0f
#define M_5BITS		0xe0	/* keep only highest three bits */
#define K_2BITS		0x03
#define K_3BITS		0x07
#define K_4BITS		0x0f
#define K_5BITS		0x1f
#define K_8BITS		0xff
#define K_20BITS	0x000fffff	/* keep 20 lower bits */
#define BIT_0		1
#define BIT_1		2
#define BIT_2		4
#define BIT_3		8
#define BIT_4		0x10
#define BIT_5		0x20
#define BIT_6		0x40
#define BIT_7		0x80

/* high-level user call defines */
#define GRP_MASK	0xe0	/* bit 7-5 */	
#define GRPBITS		0xe0		/* bit 7-5 */
#define GRP0		0
#define NBPGRP0		6		/* group 0 cmds = 6 bytes */	
#define NBPGRP1		10		/* group 1 cmds = 10 bytes */	

#define FIXED		1
#define BCNT_H		0
#define BCNT_M		0
#define BCNT_L		0x10	/* 16 blocks */
#define FLAG		0
#define LINK		0

/* wantek scsi tape drive op code */
#define S_TUNITRDY	0
#define S_REWIND	1
#define S_REQSENSE	3
#define S_FORMAT	4
#define S_RDLIMIT	5
#define S_SETPARAM	6
#define S_READ		8
#define S_WRITE		0x0a
#define S_PARSEL	0x0c
#define S_PARSENSE	0x0d
#define S_WRFMARK	0x10
#define S_SPACE		0x11
#define S_INQUIRY	0x12
#define S_VERIFY	0x13
#define S_RECOVER	0x14
#define S_MODESEL	0x15
#define S_RESERVE	0x16
#define S_RELEASE	0x17
#define S_ERASE		0x19
#define S_MODESENSE	0x1a
#define S_LDUNIT	0x1b
#define S_LKUNIT	0x1e

/* system configuration flag */
#define SEL_EN		1
#define RESEL_EN	2
#define PAR_EN		4


/* special support */
#define	SELECT_EN	1
#define	RESEL_EN	2
#define	PARITY_EN	4

/* scsi status defines */
#define	GOOD		0x00		/* sucessful completion */
#define	CHK_CONDITION	0x02		/* abnormal condition */
#define	TGT_BUSY	0x08		/* target is busy */
#define	INTERMED_GOOD	0x10		/* linked cmd completion */
#define	RESV_CONFLT	0x18		/* target is reserved */
#define	SCSI_ERR	0x80		/* target is reserved */

/* error defines */
# define	HE_CMDERR	0x01	/* scsi phase error */
# define	HE_HOSTERR	0x02	/* N5385 controller error */
# define	HE_TOUTERR	0x04	/* timeout error */
# define	HE_BUSERR	0x08	/* scsi bus error */
# define	HE_INTERR	0x10
# define	HE_CHKSTAT	0x20
# define	HE_TARERR	0x40	/* target error */

/* target controller error */
#define T_NOSENSE	0x0
#define T_RCVRYERR	0x1
#define T_DEVNRDY	0x2
#define T_MEDIAERR	0x3
#define T_HWERR		0x4
#define T_ILREQ		0x5
#define T_UNITATN	0x6
#define T_WRPROT	0x7
#define T_ENDMEDIA	0x8
#define T_STCFLT	0xa
#define T_ABORTCMD	0xb
#define T_REQDCON	0xc
#define T_VOLOVER	0xd
#define T_MISCMP	0xe
#define T_BUSY		0xf

/* status byte 2 */
#define CNI	0x40

/* KSAM */
/* scsi tape-flag's definition */
#define FMARK 	0x80	/* bit 7 =1= file mark detected */
#define EOM	0x40	/* bit 6 =1= end of media */
#define WP	0x20	/* bit 5 =1= write protect */
#define PREMEDIA 0x10	/* bit 4 =1= previous end of media cmd */
#define PREWR	8	/* bit 3 =1= previous write cmd */
#define TWOFMARK 4	/* bit 2 =1= previous write cmd */
#define RETEN	2	/* bit 1 =1= Rentension */
#define LOAD	1	/* bit 0 =1= load unit */
#define	STREAM		0x80
#define	MASK_STREAM  	0xff7f

