/*
 *	@(#)sc.h	1.12 88/03/19 
 *
 *	intelligent serial board device structure
 */

#define CONSOLE		0	/* minor device # for console */
/*	Note that if RBSIZE ever exceeds 256, the driver must be changed
	to deal with chrouth and chrinh, which are both set to 0 ONCE ONLY
	and then ignored in the current driver! */
#define RBSIZE		128	/* receive buffer size -- must be power of 2 */
#define TBSIZE		128	/* transmit buffer size -- must be at least */
				/* as big as a clist data block */
#if SYS_TYPE == SYS_500
#define SCMAX		1	/* maximum number of SIO boards in any case */
#else
#define SCMAX		4	/* maximum number of SIO boards in any case */
#endif
#define PROFILING	/* update sysinfo for interrupts, etc */

/* all the CONTROL structures must live in the same 256K (although
	not the data addresses) must be in the same 256K segment in order
	for "old" comm products to work.  They are therefor allocated at
	runtime in ttyspace(), same as the multidrop.
	Olson, 5/86.
*/
typedef struct device *sccntrl;
typedef struct schan  *scchan;


	/*	Get actual physical address to pass to board. (Note
		assumption that all terminal i/o is via clists!) */
#if SYS_TYPE == SYS_500

#define NSCPCONT	8	/* number of serial channels per concentrator */
#define HWINTRES	0x30A	/* clears int latch from commbd interrupt  */ 
/* no WorkNet port on S500 SIO's, but need dummy define for fs/wnet/scwnet.c */
# define NETPORT	9	/* port number on controller */
# define SCNETCHAN NETPORT	/* m68k compat */

/* SIO board dual-port memory size (64K) */
#define SIOSIZ		((long)0x10000)	

/* physical address in the SIO board's memory space where dual-port
 * memory starts
 */
#define DPMSIO		((long)(0x100000 - SIOSIZ))	

/* physical address in the kernel's memory space where dual-port
 * memory starts for 1st SIO board at bottom of 0xD0000 segment
 */
#define DPMKERN	((long)(0xE0000 - SIOSIZ))
		
/* convert kernel virtual address a to corresponding SIO board
 *  physical address in dual-port memory: get physical offset
 *  from beginning of dual-port memory then add sio segment
 */ 
#define DPMKVBASE	((long)(&sccont[0]))
#define kvtosio(a)	((long)((long)a - DPMKVBASE + DPMSIO))

/* convert physical kernel address a to SIO board address
 * in dual-port memory segment
 */
#define pktosio(a)	((long)((long)a - DPMKERN + DPMSIO))

#else	/* other SIO's */

# define NSCPCONT	10	/* number of serial channels per concentrator */
# define SIOVEC	2		/* first SIO interrupt vector */

	/* The WorkNet port is always channel 9 (tty09, tty19, ...) */
# define NETPORT	9	/* port number on controller */
# define SCNETCHAN NETPORT	/* m68k compat */

#endif

#pragma pack(2)
struct schan {
	unchar chparm0, chparm1;
	unchar chstat0, chstat1;
	unchar chcmnd;
	unchar chxadl, chxadm, chxadh;	/* high byte not used */
	unchar chxlenl, chxlenh;
	unchar chradl, chradm, chradh;	/* high byte not used */
	unchar chrlen, chrlenh;
	unchar chrin, chrinh;
	unchar chrout, chrouth;
	unchar chratel, chrateh;
	unchar chfcode;			/* foreign code version */
};

struct device  {
	unchar scver;
	unchar sccmnd;
	unchar scstat;
	unchar scivec0, scivec1;
	unchar scdummy;
	struct schan sc_chan[NSCPCONT];
};

#pragma pack()

/* get the board's attention */
# define SC_ATTN(board) int_ioproc(sc_attn[board])

/* wait until sc board finishs previous command on this channel */
#define WAIT(chan) {while((chan)->chcmnd & CHBUSY)	;}

/* wait until we can issue a 'system command' to the board */
#define WAITBD(cont) {while((cont)->sccmnd & CNBUSY) ;}

#define	SCVER(cont)	(cont.scver >> 3)
#define MAX_SC_VERS 0x10	/* temporary, fix later. 2/86 */

#define	CNBUSY	0x80
#define	DISABLE	( 0 | CNBUSY)
#define	ENABLE	( 1 | CNBUSY)
#define	INTDIS	( 2 | CNBUSY)
#define	INTEN	( 3 | CNBUSY)
#define	RESINT	( 4 | CNBUSY)
#define	RESTART	( 5 | CNBUSY)

/* CHANNEL PARAMETER 0 */
#define	PENABLE	0x01		/* parity enable */
#define	EVENPAR	0x02		/* even parity */
#define	ONESTOP	0x04		/* one stop bit */
#define	TWOSTOP	0x0C		/* two stop bits */
#define	BITS5	0x00		/* five bits/char */
#define	BITS6	0x20		/* six bits/char */
#define	BITS7	0x10		/* seven bits/char */
#define	BITS8	0x30		/* eight bits/char */
#define	BREAKON	0x40		/* break on/off */
#define	MRECV	0x80		/* multiple character receive */

/* CHANNEL PARAMETER 1 */
#define	BAUD	0x0F		/* mask for baud rate field */
#define	CTSBIT	0x40		/* clear to send */
#define	DSRBIT	0x80		/* data set ready */

/* CHANNEL STATUS 0 */
#define	XEMPTY	0x01		/* xmitter empty */
#define	DTRBIT	0x02		/* data xmit ready */
#define	BRK	0x04		/* break in progress */
#define	RTSBIT	0x08		/* request to send, also used as carrier det */
#define	PERRSC	0x10		/* parity error */
#define	OVERRSC	0x20		/* receiver overrun */
#define	FERROR	0x40		/* framing error */

/* CHANNEL STATUS 1 */
#define	RAVAIL	0x01		/* receive character avail in tty reg */
#define RFREE	0x02		/* not sending receive interrupt */
#define XFREE	0x04		/* not sending transmit interrupt */
#define MDMFREE	0x08		/* not sending modem interrupt */
#define	XREADY	0x10		/* xmitter ready */

/* CHANNEL COMMAND */
#define	CHBUSY	0x80		/* channel command reg busy (or'ed in) */
#define	XINTEN	0x40		/* xmit interrupt enable (or'ed in) */
#define	RINTEN	0x20		/* receive interrupt enable (or'ed in) */
#define	MINTEN	0x10		/* modem interrupt enable (or'ed in) */
#define	CHMASK	0x0F		/* channel command mask (for bits that
	are 'volatile'; the high nibble is supposed to remain unchanged
	by the board. */
#define	CHCMASK	(CHMASK | CHBUSY)	/* channel command mask with busy */
#define	NOP	CHBUSY	/* channel nop comand */
#define	CHINIT	(1 | CHBUSY)	/* channel initialize */
#define	XMIT	(2 | CHBUSY)	/* start xmit operation */
#define	RCVACK	(3 | CHBUSY)	/* acknowledge receiver */
#define	XABORT	(4 | CHBUSY)	/* abort xmit operation */
#define	FLOWCMD	(5 | CHBUSY)	/* abort receive operation */
#define	BRKCTRL	(6 | CHBUSY)	/* send break operation */
#define	CHPARM	(8 | CHBUSY)	/* change parameter */
#define	RESERR	(9 | CHBUSY)	/* reset error */
#define	RESMOD	(10 | CHBUSY)	/* reset modem interrupt */
#define	RMULTI	(11 | CHBUSY)	/* run over multibus */

#define	PTRINVL	0x80		/* set in high byte of chrin if ptr invalid */

/*  Network commands and defines for sio board */
#define NETCMD  (7 | CHBUSY)	/* network command */

/*  Top 3 bits of high parameter byte ... */
#define NETNOP		0x00	/* no operation */
#define NETENABLE 	0x20	/* enable the network */
#define NETXMIT		0x40	/* transmit a packet */
#define NETACKREC	0x60	/* acknowledge received packet(s) */
#define NETDISABLE	0x80	/* disable the network */
#define NETXFAST	0xa0	/* transmit a high-speed packet */

/*  Top 2 bits of low parameter byte ... */
#define NETXINTEN	0x40	/* transmit interrupt enable */
#define NETRINTEN	0x80	/* receive interrupt enable */

/*  Channel status byte ... */
#define  TxEMPTY	0x01	/* transmitter empty */
#define  TxUNDER	0x02	/* transmitter early underrun */
#define  TxDEFER	0x04	/* deferred too many times */
#define  TxNoUNDER	0x08	/* transmitter never underrun */
#define  RxLOST		0x20	/* receive packet has been lost */
#define  RxREADY	0x40	/* receive packet available */

/*  Receive packet status byte ... */
#define  RxCRCERR	0x40	/* CRC error */
#define  RxOVRERR	0x20	/* overrun error*/
#define  RxRCVFULL	0x01	/* receive buffer has data to be processed */
/* End of network defines */

#define DEVCONT(mdev)  (&sccont[(mdev)/NSCPCONT])
#define DEVCHAN(mdev)  (&(sccont[(mdev)/NSCPCONT].sc_chan[(mdev)%NSCPCONT]))
#define CHANNEL(pdev,mdev)	(&((pdev)->sc_chan[(mdev)%NSCPCONT]))


#define	TXHARDFLO	0x01		/* Tx DTR flow control */
#define	TXRTS	0x02		/* Tx RTS flow control */
#define TXSOFT	0x04		/* Tx software flow control */
#define	RXHARDFLO	0x10		/* Rx hardware flow control */
#define RXSOFT	0x40		/* Rx software flow control */

struct sc_netrcb {	/* sio net receive control block */
	unchar  	wnradrl, wnradrm, wnradrh;  /* address of receive buffer */
	unchar  	wnrlim, wnrlimh;  	    /* limit of packet length */
	unchar  	wnrstat;		    /* receive status */	
	unchar  	wnract, wnracth;            /* actual packet length */
};

struct sc_netxcb {	/* sio net xmit control block and buffers */
	paddr_t xmt_paddr;	/* packet data physical address */
	short	xmt_length;	/* packet length (-1 indicates available) */
	short	xmt_flags;	/* packet flags */
	unchar *xmt_data;	/* packet data */
};


/*
 *  structure for handling the print-screen function
 *
 *  There is a copy of this structure for each serial channel.
 *
 *  for speed reasons, the first character of the print-screen key
 *  sequence is stored in "psflag".  If
 *  there is a match on the first character, then the appropriate entry
 *  for this structure is used.
 *  pskey is first in struct for faster dereferencing
 */
struct psstruct {
	char pskey[10];		/* print-screen key sequence */
	unchar  psindx;		/* index of current char in key sequence */
		/* number of chars in print-screen key and esc sequences */
	unchar pskeylen:4, psesclen:4;
	char psesc[10];		/* print-screen escape sequence */
};

#ifdef INKERNEL
extern struct psstruct *psbuf;
extern unchar scvecs[SCMAX];	/* see io_init() in machdep.c */
#define SC_NUM(x) (scvecs[x])	/* see io_init() */
extern char *scflowstr;
extern char *scrbuf;	/* base of receive buffers */
extern struct device *sccont;
extern struct tty *sc_tty;
extern unchar scdevnum;	/* major device number of sio driver.  Used
	by the xpr code */
extern unchar sc_attn[]; /* defined in sc.c */
extern char scwnport[];	/* flag if running async on WorkNet port */
#endif /* INKERNEL */
