/*
 *	@(#) relsym86.h 1.1 88/03/19 
 *
 *	Copyright (C) The Santa Cruz Operation, 1985, 1986.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation, Microsoft Corporation
 *	and AT&T, and should be treated as Confidential.
 *
 */

/*
 * THIS FILE CONTAINS CODE SPECIFIC TO THE INTEL CPUS.
 * IT MAY REQUIRE MODIFICATION WHEN MOVING XENIX TO
 * DIFFERENT MACHINE ARCHITECTURES OR CONFIGURATIONS.
 */

/*
 *	<sys/relsym86.h> - Declarations for 8086/80286 symbol
 *		table and relocation record structures.
 */

/*
 *	Combined symbol and relocation for relocatable files,
 *		(XR_R86REL | XR_S86REL).
 *
 *	This format is a series of distinct records.  Each record
 *	is made up of:
 *		1) 1 byte record type
 *		2) 2 byte record length (low byte first)
 *		3) record contents
 *		4) 1 byte checksum
 *
 *	The record length is the number of bytes in 3 & 4.
 *	When ALL of the bytes in the record are summed, the
 *	the low byte of the result should be zero.
 *	The record contents depend on the record type.
 *	Records containing symbol names have a one byte name
 *	length followed by the name itself.  The name is not
 *	terminated by a special character.
 */


/*
 *	Defines for record type:
 */
#define MRHEADR	0x6e	/* rel module header */
#define MREGINT	0x70	/* register initialization */
#define MREDATA	0x72	/* explicit (enumerated) data image */
#define MRIDATA	0x74	/* repeated (iterated) data image */
#define MOVLDEF	0x76	/* overlay definition */
#define MENDREC	0x78	/* block or overlay end record */
#define MBLKDEF	0x7a	/* block definition */
#define MBLKEND	0x7c	/* block end */
#define MDEBSYM	0x7e	/* debug symbols */
#define MTHEADR	0x80	/* module header, usually first in a rel file */
#define MLHEADR	0x82	/* link module header */
#define MPEDATA	0x84	/* absolute data image */
#define MPIDATA	0x86	/* absolute repeated (iterated) data image */
#define MCOMENT	0x88	/* comment record */
#define MMODEND	0x8a	/* module end record */
#define M386END	0x8b	/* 32 bit module end record */
#define MEXTDEF	0x8c	/* external definition */
#define MTYPDEF	0x8e	/* type definition */
#define MPUBDEF	0x90	/* public definition */
#define MPUB386	0x91	/* 32 bit public definition */
#define MLOCSYM	0x92	/* local symbols */
#define MLOC386	0x93	/* 32 bit local symbols */
#define MLINNUM	0x94	/* source line number */
#define MLIN386	0x95	/* 32 bit source line number */
#define MLNAMES	0x96	/* name list record */
#define MSEGDEF	0x98	/* segment definition */
#define MSEG386	0x99	/* 32 bit segment definition */
#define MGRPDEF	0x9a	/* group definition */
#define MFIXUPP	0x9c	/* fix up previous data image */
#define MFIX386	0x9d	/* fix up previous 32 bit data image */
#define MNONE1	0x9e	/* none */
#define MLEDATA	0xa0	/* logical data image */
#define MLED386	0xa1	/* 32 bit logical data image */
#define MLIDATA	0xa2	/* logical repeated (iterated) data image */
#define MLID386	0xa3	/* 32 bit logical repeated (iterated) data image */
#define MLIBHED	0xa4	/* library header */
#define MLIBNAM	0xa6	/* library names record */
#define MLIBLOC	0xa8	/* library module locations */
#define MLIBDIC	0xaa	/* library dictionary */
#define	MCOMDEF	0xb0	/* communal names definition */
#define MLIBHDR	0xf0	/* library header */
#define MLIBDHD	0xf1	/* library dictionary header */


/*
 *	The maximum length of an identifier.
 */

#define NAMELENGTH	40


/*
 *	Defines for segment descriptor.
 */

	/* type of alignment required */
#define SD_ABS		0x00		/* absolute */
#define SD_BYTE		0x20		/* byte */
#define SD_WORD		0x40		/* word */
#define SD_PARA		0x60		/* paragraph */
#define SD_PAGE		0x80		/* page */
#define SD_DWORD	0xa0		/* double word */
#define SD_UABS		SD_DWORD	/* unnamed absolute */
#define SD_LTL		0xc0		/* load-time locatable */
#define SD_ALIGN	0xe0		/* segment alignment mask */
#define SD_ASHIFT	5		/* align. shift */

	/* ways in which segments can be combined */
#define SD_PRIV		0x00		/* private, can't be combined */
#define SD_HCOMM	0x04		/* common, place in high mem */
#define SD_PUBLIC	0x08		/* public, sequential */
#define SD_BAD		0x0c		/* undefined */
#define SD_C4		0x10		/* not used */
#define SD_STACK	0x14		/* stack segment */
#define SD_COMM		0x18		/* common segment */
#define SD_RCOMM	0x1c		/* not used, reverse common segment */
#define SD_COMBO	0x1c		/* combination mask */
#define SD_CSHIFT	2		/* comb. shift */

#define SD_PGRES	0x01		/* page resident */
#define SD_64K		0x02		/* segment size is exactly 64k */


	/* definitions for LTL descriptor */
#define LTL_64K		0x01		/* max segment size is exactly 64k */
#define LTL_GRP		0x80		/* is a group member */


	/* definitions for C common MTYPDEF records */
#define	TD_CNEAR	0x62		/* near .comm variable */
#define	TD_CFAR		0x61		/* far .comm variable */


	/* for DOS support */
#define DOSMAGIC	0x5a4d		/* DOS executable magic number */

struct dosexec {
	unsigned short	dx_magic;	/* magic number */
	unsigned short	dx_pagrem;	/* image length mod 512 */
	unsigned short	dx_npages;	/* file size in 512 byte pages */
	unsigned short	dx_nreloc;	/* # of reloc items */
	unsigned short	dx_hsize;	/* header size in 16 byte paragraphs */
	unsigned short	dx_minpar;	/* min par's above end of image */
	unsigned short	dx_maxpar;	/* max par's above end of image */
	unsigned short	dx_stkoff;	/* offset of stack (in segment form) */
	unsigned short	dx_initsp;	/* initial sp */
	unsigned short	dx_chksum;	/* file check sum */
	unsigned short	dx_initip;	/* initial ip */
	unsigned short	dx_textoff;	/* offset of code (in segment form) */
	unsigned short	dx_reloff;	/* offset of first reloc item */
	unsigned short	dx_ovly;	/* overlay number */
};


/*
 *	Relocation for 8086 segmented x.out executable files, XS_R86SEG.
 */
struct segrel86 {
	unsigned sel;			/* xs_seg selector of target */
	unsigned off;			/* offset within seg */
};


/*
 *	Relocation for executable files, XR_R86ABS.
 *	
 *	This relocation must be attached to middle and large
 *	model executables to be run on an 8086.  Relocation is
 *	performed on all segment references when the file is
 *	loaded into memory.
 *
 *	This relocation must start on an even sizeof(struct srel86)
 *	boundary.  The size of this structure MUST BE an even
 *	power of 2.  In order to accomplish the padding, the
 *	appropriate number of null bytes should be written at the
 *	start of the relocation, and the relocation size in the
 *	header bumped up to reflect the padding.
 */

struct srel86 {
	char		srtyp;	/* type of segment relocation */
	char		srhib;	/* high byte of reloc address */
	unsigned short srlow;	/* low word of reloc address */
};


/*
 *	Defines for srel86.srtyp
 */

#define R86_CTC 0		/* code reference to code */
#define R86_CTD 1		/* code reference to data */
#define R86_DTC 2		/* data reference to code */
#define R86_DTD 3		/* data reference to data */


/*
 *	Macros applicable to XR_R86ABS relocation padding:
 *
 *	SRELPOS() must be given a pointer to an x.out header;
 *	    it returns the seek position of the first relocation
 *	    structure in an object file, skipping any padding.
 *	SRELPAD() is also given an x.out header pointer; it
 *	    returns the number of bytes of padding required
 *	    to properly align the relocation records.  The
 *	    x_reloc field in the header is not used in the
 *	    computation; it need not be accurate.
 *	SRELSIZE() should be given a long value, usually the
 *	    x_reloc field of an x.out header; it returns the
 *	    size of actual relocation records in an object file,
 *	    compensating for any padding.
 */

#define SRELMSK		((long) (sizeof(struct srel86) - 1)) /* 2^n-1 */
#define SRELPOS(xp)	((XRELPOS(xp) + SRELMSK) & ~SRELMSK)
#define SRELPAD(xp)	((int) ((~XRELPOS(xp) + 1) & SRELMSK))
#define SRELSIZE(x)	((long) x & ~SRELMSK)



/*
 *	LDT/GDT descsriptor table information for executable files, XR_R286ABS.
 *
 *	dtab structure without union to allow static initialization.
 *	desctab table structure with union to allow efficient reference.
 */

struct dtab {
	unsigned short	dt_limit;	/* offset of last byte in segment */
	unsigned short	dt_loaddr;	/* low word of physical address */
	char		dt_hiaddr;	/* high byte of physical address */
	char		dt_acc;	   	/* access control byte */
	unsigned short	dt_sw;		/* used by 80386 */
};

struct desctab {
	unsigned short	d_limit;	   /* offset of last byte in segment */
	union {
	    struct {
		unsigned short	du_loaddr; /* low word of physical address */
		char		du_hiaddr; /* high byte of physical address */
		char		du_acc;	   /* access control byte */
	    } du_sep;
	    long  du_paddr;
	} d_un;
	unsigned short	d_sw;		   /* used by 80386 */
};

#define	d_loaddr	d_un.du_sep.du_loaddr
#define	d_hiaddr	d_un.du_sep.du_hiaddr
#define	d_acc		d_un.du_sep.du_acc
#define	d_paddr		d_un.du_paddr

#ifdef M_WORDSWAP
# define DESCRADDR(dtab)       (dtab.d_paddr & 0x00ffffffL)
#else
# define DESCRADDR(dtab)       (((long) (dtab.d_hiaddr & 0xff)) | dtab.d_loaddr)
#endif


#define DSA_PRESENT	0x80		/* present */
#define DSA_PRIV	0x60		/* priviledge level mask */
#define DSA_VALID	0x10		/* segment valid (else control descr) */
#define DSA_EXEC	0x08		/* executable */
#define DSA_TCONF	0x04		/* if text, conforming */
#define DSA_DEDOWN	DSA_TCONF	/* if data, expand down */
#define DSA_TREAD	0x02		/* if text, readable */
#define DSA_DWRITE	DSA_TREAD	/* if data, writeable */
#define DSA_ACCESSED	0x01		/* has been accessed */

#define DSA_TYPE	0x1f		/* descr type field mask */
#define DSA_RING3	DSA_PRIV	/* all bits on */

#define	DSA_CODE  (DSA_PRESENT|DSA_VALID|DSA_EXEC|DSA_TREAD)  /* 9a, text acc */
#define	DSA_DATA  (DSA_PRESENT|DSA_VALID|DSA_DWRITE)	      /* 92, data acc */
#define DSA_VP	  (DSA_PRESENT|DSA_VALID)		    


/*
 * parts of a selector
 */
#define	SEL_INDEX	0xfff8		/* index into table */
#define	SEL_LDT		0x0004		/* set if ldt, else gdt */
#define	SEL_PRIV	0x0003		/* requested priv level */

#define	SEL_RING3	SEL_PRIV	/* all bits on */

/*
 * Some defines for the 386 extension "word" (d_sw)
 */
#define DSA_32BIT	(1 << 6)	/* segment is 32 bit code/data */
#define DSA_PAGE	(1 << 7)	/* set page granularity */

#define DRELMSK		(sizeof(struct desctab) - 1)	      /* 2^n-1 */
#define DRELPOS(xp)	((XRELPOS(xp) + (long) DRELMSK) & ~((long) DRELMSK))
#define DRELPAD(xp)	((int) ((~XRELPOS(xp) + 1) & (long) DRELMSK))
#define DRELSIZE(x)	((long) x & ~((long) DRELMSK))
