/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  NOTE: this file is shared accross Motorola and Intel product
	lines.  Any machine specific code is in the appropriate ifdefs
*/

#ident	"@(#)FROM: kern-port:sys/rbuf.h	10.1.2.3"
#ident	"@(#)rbuf.h	1.7	2/19/88 08:41:19"

/*
 *  	New parameters and macros for RFS network cache. rbuf structure
 *	defines contents of buffer header when buffer contains remote (RFS)
 *	server file data.
 *
 *      WARNING:  do not change size of the buf structure (sys/buf.h) without 
 *	making a corresponding size change in the the rbuf structure 
 *	(sys/rbuf.h), and vice versa.  The two structures define the two 
 *	possible formats of the buffer header (the format used depends on 
 *	whether the buffer contains local data or RFS data).  
 *
 *      This overlay of the two structures is an interim solution
 *	that is expected to change in a future release.  Users
 *	should be aware that the rbuf structure will probably go
 *	away at that time.
 */
#ifdef m68k
 typedef struct	rbuf	{
	long	b_flags;		
	mplock_t b_mplock;		/* multiprocessor lock */
	index_t	b_mntindx;      	/* remote mount index */
	struct	rbuf *b_forw;		/* position in RFS block hash table */
	struct	rbuf *b_back;		/*  "  */
	struct	rbuf *av_forw;		/* position on RFS free list, */
	struct	rbuf *av_back;		/*     if not BUSY*/
	struct	rbuf *f_forw;		/* position in RFS file hash table */
	struct	rbuf *f_back;		/*  "  */
	unsigned long	b_reltime;      /* previous release time */
	caddr_t		*b_pt;
	union {
	    caddr_t b_addr;		/* low order core address */
	} b_un;
	rib_t	b_rib;
	long   		b_fhandle;	/* buffer remote file ID */
	struct queue	*b_queue;       /* buffer remote server ID */
	unsigned long	b_vcode;        /* remote file version code */
 } rbuf_t;
#else  i386
# define	rbuf	buf
# define	f_forw	b_u.rfsbuf.rfs_forw
# define	f_back	b_u.rfsbuf.rfs_back
# define	b_vcode	b_u.rfsbuf.rfs_vcode
# define	b_fhandle b_u.rfsbuf.rfs_fhandle
# define	b_queue	b_u.rfsbuf.rfs_queue
# define	b_mntindx	b_u.rfsbuf.rfs_mntindx
 typedef struct  rbuf	rbuf_t;
#endif m68k

#define	RBSIZE		FsBSIZE(SBUFSIZE)
#define RBSHIFT		FsBSHIFT(SBUFSIZE)
#define	RBMASK		FsBMASK(SBUFSIZE)
#define LGET		0
#define	RGET		1
#define BUFAGE		300	/* Maximum buffer age time for NREMOTE minimum*/

#define off_to_blkoff(x)     ((unsigned long)(x) >> (RBSHIFT))
					/*convert offset to 1024 block-size*/
#define ct_to_blkct(x,y)     ((x)<=0?0:((off_to_blkoff((x)-1+(y))-off_to_blkoff(y))+1))
					/*no. of blocks in read/write request*/


/*  
 * Union defining dependency between buf and rbuf structure sizes
 * (this union is not actually used in kernel code because of dependencies of
 * old source code on buf structure).
 */
union unibuf {
	struct	buf	loc;
	rbuf_t	rem;
} ;

extern	rbuf_t	rbfreelist;	/* head of available list */
extern  int		rcache_enable;
extern  unsigned long	rfs_vcode;
extern  unsigned long	rbuf_ct;
extern  unsigned long	lbuf_ct;
extern	int		rhmask;
extern	int		nrhbuf;
extern	unsigned long	nlbuf;
extern	unsigned long	nrbuf;
extern	unsigned long	rcache_time;
extern	int		rc_time;
extern	unsigned long	nremote;
extern	unsigned long	nlocal;
extern	unsigned long	maxbufage;
rbuf_t 		*rget_cache();
rbuf_t 		*rgeteblk();
rbuf_t 		*chk_rlist();
uint			rcache_out();


/*
 *	Fast access to buffers in cache by hashing.
 */
#define rbhash(d,b)	((rbuf_t *)&rhbuf[((unsigned)d+(unsigned)b)&rhmask])

/*
 * Key value for rfhash is fhandle (file handle), which is a full-word aligned
 * memory address.  It therefore needs to be shifted right two places
 * before using it as a hash key.
 */
#define rfhash(d)	((rbuf_t *)&rhbuf[((unsigned)(d>>2))&rhmask])

/* note that rhbuf MUST match rbuf, at least as far as the flags and
	rbuf_t pointers go */
struct	rhbuf
{
	long	b_flags;
#ifdef m68k
	mplock_t b_mplock;
	short	b_unused;
	rbuf_t *b_forw;
	rbuf_t *b_back;
	rbuf_t *av_forw;
	rbuf_t *av_back;	
	rbuf_t *f_forw;			
	rbuf_t *f_back;		
#else  i386
	rbuf_t *b_forw;
	rbuf_t *b_back;
	rbuf_t *av_forw;
	rbuf_t *av_back;
	union {
		rfsbuf_t rfsbuf;
	} b_u;
#endif m68k
};

extern	struct	rhbuf	rhbuf[];

/*
 * Unlink a buffer from the remote freelist list and mark it busy.
 * Spls not needed since interrupts should
 * never return buffers to remote freelist.
 */
#define remnotavail(bp) \
{\
	bp->av_back->av_forw = bp->av_forw;\
	bp->av_forw->av_back = bp->av_back;\
	bp->b_flags |= B_BUSY;\
}
