/*
 * Copyright 1983,1984,1986 Intel Corporation
 *
 *         INTEL CORPORATION PROPRIETARY INFORMATION
 *
 *    This software is supplied under the terms of a license 
 *    agreement or nondisclosure agreement with Intel Corpo-
 *    ration and may not be copied or disclosed except in
 *    accordance with the terms of that agreement.
 */

/*
 * RAM disk device driver include file.
 *
 *	For UNIX 386, the physical address and size must
 *	be of 4k granularity.
 */

/*  @(#)ramd.h	1.2 88/03/19   */
struct	ramdcfg	{
		paddr_t	ramd_paddr;	/* phys address of first blk */
		ulong	ramd_size;	/* Size of disk in bytes */
		ushort	ramd_flag;	/* see defs below */
};

struct	ramddev	{
		caddr_t	ramd_addr;	/* Kernel virtual addr */
		ushort	ramd_state;	/* Exists??  Open?? */
};

#define	TPATTERN	0xAAAA
#define RAMD_GRAN	0x1000		/* Grannularity for ram disk
					 * starting address and size
					 */
/* Flag definitions for ramd_flags */
#define RAMD_NO_INIT	00		/* Do not pre-zero the RAM Disk */
#define RAMD_ZERO_FILL	01		/* Zero fill the RAM Disk at init */

/* State flags for the RAM Disks */
#define RAMD_CFGERR	01		/* Disk configuration is not usable */
#define RAMD_ALIVE	02		/* Disk is present */
#define RAMD_OPEN	04		/* Disk is open */

extern struct ramdcfg ramdcfg[];
extern struct ramddev ramddev[];
extern struct buf     ramd_buf[];
extern int	      numramd  ;
