/*
 *		@(#)pty.h	1.4 88/03/19 
 *
 *	Pseudo TTY driver
 */
#ident	"@(#)pty.h	1.4	2/19/88 08:41:09"

struct pty {
	int	pt_flags;		/*  0: flags */
	char	*pt_id;			/*  4: identifier for real driver */
	int	(*pt_fclose)();		/*  8: routine to call on close */
	int	(*pt_fioctl)();		/* 12: routine to call on ioctl */
	int	(*pt_fparam)();		/* 16: routine to call after ioctl */
	int	(*pt_fread)();		/* 20: routine to call before read */
	int	(*pt_fwrite)();		/* 24: routine to call after write */
	int	(*pt_fexit)();		/* 28: routine to call on exit */
};					/* 32: total */

extern struct tty	pt_tty[];
extern struct pty	pty[];
extern int		max_pty;

					/* PTY flags: */
#define PT_ALLOC	1		    /* allocated memory for device */
#define PT_USED		2		    /* in use */
#define PT_HOOKED	4		    /* hooked to a driver */
