/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	@(#)proc.h	1.25 88/03/19  */
/*	One structure allocated per active process. It contains all
**	data needed about the process while the process may be swapped
**	out.  Other per process data (user.h) may swapped with the
**	process but in fact it is not.
**	members are arranged to leave as few 'holes' as possible:
**	all byte fields first, followed by short, then int/long/ptr
*/

typedef struct	proc	{
	uchar_t	p_stat;			/* Status of process.	     */
	uchar_t	p_pri;			/* priority, negative is high */
	uchar_t	p_cpu;			/* cpu usage for scheduling */
	uchar_t	p_nice;			/* nice for cpu usage */
	uchar_t	p_time;			/* resident time for scheduling */
	uchar_t	p_cpubits;		/* where can it run now? */
	uchar_t	p_busy;		/* if set, proc is 'owned' by another
		process, and may not be made runnable or swapped */
	uchar_t	p_runon;		/* where did it last run */
	unchar	p_cursig;		/* current signal */
	unchar	p_FILLBYTE;		/* fill for alignment */
	ushort	p_uid;			/* real user id */
	ushort	p_suid;			/* saved (effective) user id from exec. */
	short	p_pgrp;			/* name of process group leader */
	short	p_pid;			/* unique process id */
	short	p_ppid;			/* process id of parent */
	ushort	p_sgid;			/* saved (effective) group id from exec. */
	ushort	p_mpgneed;		/* number of memory pages    */
					/* needed in memwant.	     */
	short	p_epid;			/* effective pid normally - same as p_pid */
					/* if server - p_pid that sent msg */
	sysid_t p_sysid;		/* normally - same as sysid */
					/* if server - system that sent msg */
	short	p_xstat;		/* exit status for wait */
	mplock_t	p_lock;			/* MULTIPROCESSOR LOCK for p_sig and p_cursig */
	ushort	p_whystop;		/* Reason for process stop */
	ushort	p_whatstop;		/* More detailed reason */
	uint	p_flag;			/* Flags defined below.	     */
	ulong	p_sig;			/* signals pending to this process     */
	struct	proc	*p_flink;	/* linked list of processes */
	struct	proc	*p_blink;	/* linked list of processes */
	caddr_t	p_wchan;		/* Wait addr for sleeping processes.    */
	struct	proc	*p_parent;	/* ptr to parent process    */
	struct	proc	*p_child;	/* ptr to first child process */
	struct	proc	*p_sibling;	/* ptr to next sibling	    */
					/* process on chain	    */
	int	p_clktim;		/* time to alarm clock signal */
	uint	p_size;			/* size of swappable image in pages.    */
	time_t	p_utime;		/* user time, this proc */
	time_t	p_stime;		/* system time, this proc */
	struct  proc *p_mlink;		/* link list of processes    */
					/* sleeping on memwant or swapwant.	     */
	paddr_t	p_cr3;			/* physical address of page directory */
	pde_t	*p_ubptbl;		/* pointer to u-block page table */

	preg_t	*p_region;		/* process regions */
	struct	rcvd  *p_minwd;		/* server msg arrived on this queue */
	struct	proc  *p_rlink;		/* linked list for server */
	int	p_trlock;
	struct inode *p_trace;		/* pointer to /proc inode */
	ulong	p_sigmask;		/* tracing signal mask for /proc */
	ulong	p_hold;			/* hold signal bit mask */
	ulong	p_chold;		/* defer signal bit mask, sigset turns on
			this bit, signal does not turn on this bit */
	struct sd *p_sdp;		/* For sd */
	dbd_t	p_ubdbd[USIZE];		/* DBDs for ublock when swapped out */
	struct  v86dat *p_v86;          /* pointer to v86 structure */
	
} proc_t;

#define	p_link	p_flink

extern struct proc *proc;	/* the proc table itself (alloc in startup.c) */

/* stat codes */
#define	SSLEEP	1	/* Awaiting an event. */
#define	SRUN	2	/* Runnable. */
#define	SZOMB	3	/* Process terminated but not waited for. */
#define	SSTOP	4	/* Process stopped by signal */
			/* since it is being traced by its parent. */
#define	SIDL	5	/* Intermediate state in process creation. */
#define	SONPROC	6	/* Process is being run on a processor. */
#define SXBRK	7	/* process waiting for memory (short term) */

/* flag codes */
#define	SSYS	0x00001	/* System (resident) process.	*/
#define	STRC	0x00002	/* Process is being traced.	*/
#define	SWTED	0x00004	/* Stopped process has been given to parent by
		wait system call.  Don't return	this process to parent
		again until it runs first.		*/
#define SNWAKE	0x00008		/* Process cannot wakeup by a signal. */
#define SLOAD	0x00010		/* in core                      */
#define SLOCK   0x00020		/* Process cannot be swapped.	*/
#define	SRSIG	0x00040		/* Set when signal goes remote	*/
#define SPOLL	0x00080		/* Process in stream poll	*/
#define SPRSTOP	0x00100		/* process is being stopped via /proc */
#define SPROCTR	0x00200		/* signal tracing via /proc */
#define SPROCIO	0x00400		/* doing I/O via /proc, so don't swap */
#define SSEXEC	0x00800		/* stop on exec */
#define SPROPEN	0x01000		/* process is open via /proc */
#define SRUNLCL	0x04000		/* set proc runnin on last /proc close */
#define SNOSTOP	0x08000		/* proc asleep, stop not allowed */
#define SPTRX	0x10000		/* proc exiting via ptrace() */
#define	SASLEEP	0x20000	/* proc is stopped within a call to sleep() */
#ifdef u3b2
#define SULOAD	0x02000		/* ublock is in core */
#define	SUSWAP	0x40000	/* u-block is being swapped in or out */
#define	SUWANT	0x80000	/* waiting for u-block swap to complete */
#endif u3b2
#define SWKNET	0x1000000		/* process is using WORKNET */


#define PTRACED(p)	((p)->p_flag&(STRC|SPROCTR|SSEXEC|SPROPEN))

#define	ubptbl(PP)	((PP)->p_ubptbl)

/* Flags for newproc() */

#define NP_FAILOK	0x1	/* don't panic if cannot create process */
#define NP_NOLAST	0x2	/* don't use last process slot */
#define	NP_SYSPROC	0x4	/* system (resident) process */

/* Reasons for stopping (values of p_whystop) */

#define	REQUESTED	1
#define	SIGNALLED	2
#define	SYSENTRY	3
#define	SYSEXIT		4

/* Macros to reduce unnecessary calls to issig(). */
#define	ISSIG(p, why) \
  ((p)->p_cursig || (((p)->p_sig || ((p)->p_flag & SPRSTOP)) && issig(why)))

/* Reasons for calling issig() */

#define	FORREAL		0	/* Usual side-effects */
#define	JUSTLOOKING	1	/* Don't stop the process */

#define PMAX	255	/* max value for p_cpu and p_pri */

extern	mplock_t	runqlock;	/* lock for runq */
extern	char	runrun[];	/* scheduling flag - one per processor */
extern	int	picky_cnt;	/* Number of picky processes (MP scheduling) */

#include "sys/multiproc.h"	/* should do in each file that needs it later */

/* MULTIPROCESSOR RULES */
/*

1)	p_stat, p_wchan can be changed only when runqlock is set.
2)	p_flags can be changed only when the process is owned by the processor.
3)	p_busy is used to indicate that the process is owned by some processor.

*/
