/*
 * Altos Computer Systems: @(#)power.h	1.4 86/11/24 
 */
/*	@(#)power.h	1.6 88/03/19 	*/

#define	SHUTSAVE	1
#define SHUTKILL	2
#define RESTART		3

#define TAGRAM		0x3000000	/* address in tag ram space */
#define RSMAGIC		0x54574954
#define MPVEC		(*(paddr_t *)phystokv(0x0))
#define SAVEVEC		(*(paddr_t *)phystokv(0x4))
#define MMUTRC		(*(unsigned long *)phystokv(0x20004))
#define MMURTP		(*(unsigned long *)phystokv(0x20000))

#define RSPART	"/dev/hd0.restart"
#define XRATE	(1024*120)		/* disk transfer rate (120K/sec) */
#define TOTMEM	(ctob(physmem))
#define FUDGE	10
#define WTIME	TOTMEM/XRATE

struct pwrval {
	long pwrtype;	/* power failure type */
	long failtime;	/* ticks kernel should wait after 1st interrupt */
	long upstime;	/* secs UPS unit can operate */
	long pwrtime;	/* secs kernel should wait after posting SIGPWR */
	long termtime;	/* secs kernel should wait after posting SIGTERM */
	long pwrcnt;	/* max interrupts allowed within "failtime" */
};

struct rstrthdr {
	unsigned long magic;	/* magic number */
	unsigned long count;	/* 1k pages of phys mem copied */
	unsigned long end;	/* end of saved kernel. */
	unsigned long ep;	/* physical entry point for saved kernel */
};

struct savehdr {
	unsigned long sp;		/* stack pointer */
	int (*pc)();			/* program counter */
};
