/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)param.h	1.21 88/03/19   */
#ifndef __SYSTYPE_h__
/* make sure that any #if SYS_TYPE == in later include files works correctly */
# include "sys/systype.h"
#endif

/*
 * fundamental variables
 * don't change too often
 */
#define	DEV_BSIZE	512
#include "sys/fs/s5param.h"

#define	MAXPID	30000		/* max process id */
#define	MAXUID	60000		/* max user id */
#define	MAXLINK	1000		/* max links */

#define	SSIZE	1		/* initial stack size (*4096 bytes) */
#define	SINCR	1		/* increment of stack (*4096 bytes) */
#define	USIZE	2		/* size of user block (*4096 bytes) */

#define	CANBSIZ	256		/* max size of typewriter line	*/
#define	HZ	50		/* 50 ticks/second of the clock */

#define	NCARGS	10240		/* MAX # characters in exec arglist */
				/*   must be multiple of NBPW.  */

#define ROOTINO	((ino_t)2)	/* i number of all roots */

/*	The following define is here for temporary compatibility
**	and should be removed in the next release.  It gives a
**	value for the maximum number of open files per process.
**	However, this value is no longer a constant.  It is a
**	configurable parameter, NOFILES, specified in the kernel
**	master file and available in v.v_nofiles.  Programs which
**	include this header file and use the following value may
**	not operate correctly if the system has been configured
**	to a different value.
*/

#define	NOFILE	50

/*	The following represent the minimum and maximum values to
**	which the paramater NOFILES in the kernel master file may
**	be set. MAX is 63 so dup() won't break (and possibly other
**  things).
*/

#define	NOFILES_MIN	20
#define	NOFILES_MAX	63

/*	The following defines apply to the kernel virtual
**	address space.
*/

#define	SYSSEGSZ 1024	/* The size of the kernel segment	*/
			/* sysseg in pages.  The starting	*/
			/* address comes from the vuifile.	*/

#define	MAXKSEG		127	/* max no of pages per kseg */

/*	To avoid prefetch errors at the end of a region, it must
**	be padded with the following number of bytes.
*/

#define	PREFETCH	0

/*
 * priorities
 * should not be altered too much
 */

#define	PMASK	0177
#define	PCATCH	0400
#define	PNOSTOP	01000
#define	PSWP	0
#define	PINOD	10
#define	PRIBIO	20
#define	PZERO	25
#define PMEM	0
#define	NZERO	20
#define	PPIPE	26
#define	PWAIT	30
#define	PSLEP	39
#define	PUSER	60
#define	PIDLE	127
#define PRAISE	10	/* Increment for a matching 'picky' process (MP) */

/*
 * fundamental constants of the implementation--
 * cannot be changed easily
 */

#define	NBBY	8		/* number of bits in a byte! */
#define	NBPW	sizeof(int)	/* number of bytes in an integer */
#define	NCPPT	1024		/* Number of clicks per page table */
#define	CPPTSHIFT	10	/* LOG2(NCPPT) if exact */
#define	NBPC	4096		/* Number of bytes per click */
#define	BPCSHIFT	12	/* LOG2(NBPC) if exact */
#define	NULL	0
#define	CMASK	0		/* default mask for file creation */
#define	CDLIMIT	(1L<<20)	/* default max write address */
#define	NODEV	(dev_t)(-1)
#define NBPSCTR         512     /* Bytes per LOGICAL disk sector. */
#define SCTRSHFT        9       /* Shift for BPSECT.            */

/* Following added because svid says ulimit works in 512 byte units, so we must
  have something independent of the blocksize of the file system implementation
 */
#define ULIMSHFT	9	/* Shift for bytes per ulimit block (512) */

#define	UMODE	3		/* current Xlevel == user */
#define	USERMODE(cs)	(((cs) & SEL_RPL) == UMODE)

#define	lobyte(X)	(((unsigned char *)&X)[0])
#define	hibyte(X)	(((unsigned char *)&X)[1])
#define	loword(X)	(((ushort *)&X)[0])
#define	hiword(X)	(((ushort *)&X)[1])

#define	MAXSUSE	255

/* REMOTE -- whether machine is primary, secondary, or regular */
#define SYSNAME 9		/* # chars in system name */
#define PREMOTE 39

/* Maximum size of physio */
#define MAXBLK	64

#define LIMHOST		30	/* max # of systems on WORKNET */

/* variables for the kernel profiler driver in io/prf.c */
# define PRFMAX  2048		/* maximum number of text addresses */
# define PRF_ON    1		/* profiler collecting samples */
# define PRF_VAL   2		/* profiler contains valid text symbols */

/* seg off to 286 far pointer */
#define SOTOFAR(seg, off) \
	((ulong)(((unsigned) (seg)) << 16) + (unsigned) (off))

/* far pointer (faddr_t) to segment (int) (get high 16 bits of faddr_t) */
/* for 286 style pointer only */
#define	ftoseg(x)		((unsigned) ((long) (x) >> 16))
