#ident	"@(#)net.h	1.22	3/17/88 13:55:49"

#ifndef NETSUCC	/* don't include file more than once */
#define NETSUCC	0	/* NSproto success (REQUEST-RESPONSE exchange OK) */
#define NETFAIL 1	/* NSproto failure */

/* Client-type for packet exchange protocol */
#define FILEREQ   (short)16  /* File request - work station to file server */
#define FILERESP  (short)17  /* File response - file server to work station */
#define POLLREQ   (short)18  /* Poll request */
#define POLLRESP  (short)19  /* Poll response */
#define FILEBUSY  (short)20  /* File busy response - server to work station */
#define FILEABORT (short)21  /* File abort request - work station to server */
#define FILEDEAD  (short)22  /* Fileserver dead response */ 
#define RUNREQ	  (short)24  /* Run request - formerly REMINREQ */
#define RUNRESP	  (short)25  /* Run response - formerly REMOUTREQ */
#define BOOTREQ	  (short)28  /* Boot request packet */
#define BOOTRESP  (short)29  /* Boot response packet */
#define PCREQ	  (short)30  /* PC file server request */
#define PCRESP	  (short)31  /* PC file server response */
#define NOTIFY    (short)64  /* Notify all machines we're alive */

/* Protocol parameters */
#define	WNMAXRETRY    10	/* maximum retry count, before giving up */
#ifndef INKERNEL
# define	MAXRETRY	WNMAXRETRY	/* servers use MAXRETRY */
#endif INKERNEL
#define NSTIMEOUT   7   /* min seconds for normal response */
#define NS0TIMEOUT 11   /* seconds for first socket 0 response */
#define RCVTIMEOUT 10	/* seconds for receive packet before discarding */
#define POLLTIMEOUT 2	/* seconds for poll response */
#define POLLFREQ   60	/* polling frequency */
#define MAXNOTIFY  60	/* maximum time for NOTIFY to happen */
#define MAXPNOTIFY 300	/* maximum time for packet from polled system */
#define MAXSNOTIFY 60	/* maximum time for NOTIFY to happen for servers */
#define NOTIFYFREQ 20	/* NOTIFY frequency */
#define RECLIM	  (LIMREQ+16)	/* maximum packet size, excluding protocol layers (LIMREQ + ???) */
#ifdef i386
# define NUMRBUFS  12	/* number of packet receive buffers */
#else	/* m68k */
# define NUMRBUFS  6	/* number of packet receive buffers */
#endif

#define netio(x)	(('n' << 8) | x)
/* Ioctl parameters for /dev/nsnet (called only by serverdaemon) */
#define SETMYHOST	netio(1)	/* set my host name and address */
#define SETHOST		netio(2)	/* set other host name and address */
#define SETDRIVER	netio(3)	/* initialize a network driver */
#define SETDAEMONPID	netio(4)	/* give kernel the server daemon pid */
#define SETTIMEOUT	netio(5)	/* set timeout times */
#define SETZTIMEOUT	netio(6)	/* set timeout times for socket 0 */
#define GETERRINFO	netio(7)	/* get error information */
#define GETVERNUM	netio(8)	/* get version information */
#define CHECKSTAT	netio(9)	/* check status of systems */
#define SETNOTIFY	netio(10)	/* set notify timeouts */
#define SETRCVTIME	netio(11)	/* set receive timeout */
#define SETFSTIME	netio(12)	/* set fileserver timeouts */
#define GETFSTIME	netio(13)	/* get fileserver timeouts */
#define SETPOLLTIME	netio(14)	/* set poll timeouts */
#define GETPOLLTIME	netio(15)	/* get poll timeouts */
#define SENDNOTIFY	netio(16)	/* send notify packet */

/* Ioctl parameters for /dev/nsnet (called only by netstat) */
#define SETONHOST	netio(21)	/* turn host on (accessible) */
#define SETOFFHOST	netio(22)	/* turn host off (not accessible) */
#define STATHOST	netio(23)	/* get host table entry */

/* Ioctl parameters for /dev/nsnet (called by server programs) */
#define SETSERVER	netio(31)	/* set server entry */
#define GETSERVER	netio(32)	/* get server entry */

/* Block pointer template */
struct segment {
	short	so_active;
	short	so_length;
	unchar *so_data;
};


#ifdef m68k	/* doesn't support pragmas yet. fix when it does! 10/87 */
# define pragma ident
#endif

#pragma pack(2)
/*	start of structs passed across net or from/to user progs, with
	different 2byte/4byte alignment */
/* Packet exchange protocol header template */
struct nshead {
	ushort	ns_chksum;
	ushort	ns_length;
	unchar	ns_control;
	unchar	ns_type;
	ulong_t	ns_dstnet;
	unchar	ns_dsthost[6];
	short	ns_dstsock;
	ulong_t	ns_srcnet;
	unchar	ns_srchost[6];
	short	ns_srcsock;
	ulong_t	ns_tranid;
	short	ns_client;
};

struct nethdr {
	unchar dest;	/* destination host */
	unchar src;	/* source host */
	unchar type0;	/* packet type byte 0 */
	unchar type1;	/* packet type byte 1 */
	struct nshead header;	/* protocol header */
};

/* Host table template */
struct host {
	unchar	ho_addr[6];	/* address of host */
	ulong_t	ho_net;		/* network of host */
	short	ho_type;	/* driver of next host */
	unchar	ho_next[6];	/* address of next host */
	short	ho_flags;	/* status of host */
	ulong_t	ho_time;	/* time last notify was sent */
	short	ho_load;	/* system load */
};

/* Network server process info structure */
struct netserv {
	short	nets_proc;	/* server (local) process number */
	short	nets_hostid;	/* remote host id */
	short	nets_socket;	/* remote socket number */
	ulong_t	nets_time;	/* time last notify was received */
};

/* Packet parameter template (items passed to/from NS read/write drivers */
struct packparam {
	short	pck_hostid;	/* src if receiving, dst if sending */
	short	pck_socket;	/* src id receiving, dst if sending */
	ulong_t	pck_tranid;
	short	pck_client;
	short	pck_length;
};

/*	end of structs passed across net or from/to user progs, with
	different 2byte/4byte alignment */
#pragma pack()

#define LIMTRAN		(2*LIMHOST)	/* limit of un-responded requests */
#define LIMSPROC	(4*LIMHOST)	/* limit of servers being kept track of */
#define LIMDRIVER	4	/* limit of drivers on system */
/* LIMHOST moved to param.h, because user.h uses it. Olson */

#define LIMDATA		512	/* maximum data xfer size */
#define	BSLOP	(sizeof(off_t)+4*sizeof(short))
	/* maximum overhead
	above LIMDATA (reads/writes):
	(short cmd + short fd + long offset + short len + short total) */
#define LIMREQ		(LIMDATA + BSLOP)		/* maximum request size */

/* Transaction status - legal transitions are:
PENDING -> [BUSY -> PENDING ->] ... [FAILURE -> PENDING ->] ... SUCCESS -> DONE
*/
#define TRANPENDING	1  /* request sent, no answer yet */
#define TRANSUCCESS	2  /* response received, it matches */
#define TRANFAILURE	3  /* bad response, or no response due to timeout*/
#define TRANDONE	4  /* transaction completed, entry can be re-used */
#define TRANBUSY	5  /* BUSY response received */
#define TRANABORT	6  /* transaction aborted by remote system */
#define TRANSIGNAL	7  /* got a signal while waiting for response */

/* Transaction table template */
struct transact {
	short	tr_dsthostid;		/* remote host id */
	short	tr_dstsock;		/* dest socket */	
	short   tr_srcsock;		/* source socket */
	ulong_t	tr_tranid;		/* unique transaction identifier */
	short	tr_status;		/* pending, success, failure, done */
	struct	segment tr_res;		/* response goes here */
};

#define BRDHOSTID	0xFF	
#define NF_ONLINE	0x01	/* system is on line */
#define NF_PC		0x02	/* system is a PC */
#define NF_NOTIFY	0x04	/* notify packet sent by system */
#define NF_FAST		0x08	/* system can send/receive FAST packets */

/*
 * Errors in kernel
 */

#define ERRORBASE	80	/* first error code */

/* Errors in nsnet.c */
#define TRANFULL	80	/* transaction table full */
#define NORESP		81	/* timeout - no response */
#define DISCARD		82	/* timeout - rcv packet discarded */
#define NOXBUFS		83	/* no xmit buffers available */
#define BADLEN		84	/* rcv bad packet length */
#define CHKERR		85	/* rcv checksum error */
#define BADRESP		86	/* rcv unknown NS response packet */
#define BADHOST		87	/* rcv unknown host */
#define NOSERVER	88	/* rcv unknown socket (i.e., process) */
#define NORBUFS		89	/* no rcv buffers available */
#define FAILRESP	91	/* timeout - retry limit reached */  
#define NOXNET		92	/* can't xmit - net disabled */

/* Error in sysn.c and net.c */
#define EXITERR		90	/* connection open when exiting process */
#define BADMAP		93	/* illegal network permission map */
#define MISCERR		94	/* misc error */

/* Errors in anet.c */
#define TXDEFER		100	/* defer too much */
#define TXFAIL		101	/* transmitter failure */
#define TXUNDER		102	/* transmitter unknown */
#define RXLOST		103	/* receive packets lost */
#define RXCRCERR	104	/* receive CRC error */
#define RXOVRERR	105	/* receive overrun error */
#define RXUNKNOWN	106	/* receive unknown packet type */

#define ERROREND	107	/* last error number */

/*
 * network commands and system calls
 */
#define NETBOOT		1
#define	NETOPEN		2
#define	NETCREAT	3
#define	NETWRITE	4
#define	NETREAD		5
#define	NETCLOSE	6
#define NETLSEEK	7
#define	NETFSTAT	8
#define	NETSTAT		9
#define NETEXIT		10
#define NETFORK		11
#define NETUMASK	12
#define	NETCHDIR	13
#define	NETCHOWN	14
#define NETCHMOD	15
#define NETACCESS	16
#define NETUNLINK	17
#define NETLINK		18
#define NETUTIME	19
#define NETLOCKF	20
#define NETMKNOD	21
#define NETIOCTL	22
#define NETIDSET	23
#define NETRDCHK	24
#define NETOPREXEC	25
#define NETCLREXEC	26
#define NETTRUNC	27
/*  was NETRDEQEX	28 */
#define NETSYMLN	29
#define NETREADLN	30
#define NETFCNTL	31
#define NETSRENV	32
#define NETRMDIR	33	/* new for 5.3 */
#define NETMKDIR	34	/* new for 5.3 */
#define NETGETDENT	35	/* new for 5.3 */


#define NETSLOCKF	40		/* Rev C I/O func's with implied seek */
#define NETSTRUNC	41

#define NETSIG		64

#define NETBUFF		98		/* buffered write: internal use only */
#define NETINIT		99

#define PCCREATE	128		/* IBM PC requests ... */
#define PCREMOVE	129
#define PCATTACH	130
#define PCDETACH	131
#define PCREAD		132
#define PCWRITE		133
#define PCSELECT	134
#define PCSPOOL		135
#define PCFLUSH		136
#define PCPASSWD	137

/*
 * network abort signal packet
 */
struct netsig {
	short	nsig_cmd;
	short	nsig_num;
};


#ifdef m68k
struct netinfo {
	char	neti_name[14];
	short	neti_addr;	/* Altos address of host */
};
#endif

/* Open file types */
#define F_NORMAL	0		/* normal file */
#define F_TTY		1		/* terminal (do buffering) */

/* misc constants */
#define TTYFD		19		/* file desc for remote /dev/tty */

#ifdef i386
# define ADDRBYTE	4	/* byte in 6-byte address of real address */
#else	/* m68k */
# define ADDRBYTE	5	/* byte in 6-byte address of real address */
#endif

#ifdef INKERNEL
#define splclock() spl7()	/* no clock intr, so no timeouts */
extern paddr_t	netbase;	/* physical address base of buffers...
				 * initialized by netspace() */
extern paddr_t	netoffset;	/* offset of next avail mem in net segment */
extern struct transact transact[];
extern struct host host[];
extern struct netserv netserv[];
#ifdef m68k
extern struct netinfo netinfo[];
#endif

/* this is used for casting the buffer info to the correct type of
	structure pointer.  'struct rtn' is analogous to the 'struct uap'
	in most 'regular' system calls.
*/
#define RETV(bp) ((struct rtn *)(bp))

/*	Set up args for worknet requests */
#define NETARG(seg, flag, len, addr) { \
	(seg).so_active = flag; \
	(seg).so_length = len; \
	(seg).so_data = (unchar *)(addr); \
}

extern struct inode *atdir;
#endif /* INKERNEL */
#endif NETSUCC	/* don't include file more than once */
