/*	@(#)multiproc.h	1.14 88/03/19 	*/
/*	Copyright (c) 1987 Altos Computer Systems	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Altos Computer Systems	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/
#if !defined(BDEVOK)	/* don't include in proc.h if already included */

/*	NONMP:NOTE: all lines from this line to end of file are deleted when
	generating the non-multi-processor source, so be careful
	where you put defines and extern declartions in this file!
*/

/*
	This file contains macros, extern declarations, etc. for the
	implementation of multiprocessors.  Individual header files often
	contain variables of type 'mplock_t', and the rules for their use.
	Mostly machine independent, but assumes at least a small amount
	of RAM local to each cpu for variables such as mycpu_id.
	5/87.
*/

/*	NOTE: the 'args' must be in form "(arg, arg, arg)" with the
	parentheses REQUIRED!  Switch to processor that supports this
	driver, if required.  Save and restore cpubits here.
	d_flags contains mask of cpus on which driver can run.
*/

# if SYS_TYPE == SYS_CINDY
#define BDEVOK(dev, func, args) { \
	unchar savbits = u.u_procp->p_cpubits; \
	u.u_procp->p_cpubits = bdevsw[bmajor(dev)].d_flags; \
	CHANGECPU(u.u_procp); \
	(*bdevsw[bmajor(dev)].func) args; \
	u.u_procp->p_cpubits = savbits; \
	CHANGECPU(u.u_procp); \
}
# else /* SYS_386E */		
#define BDEVOK(dev, func, args) (*bdevsw[bmajor(dev)].func) args
# endif

/*	NOTE: the 'args' must be in form "(arg, arg, arg)" with the
	parentheses REQUIRED!  Switch to processor that supports this
	driver, if required.  Save and restore cpubits here.
	d_flags contains mask of cpus on which driver can run.
*/
# if SYS_TYPE == SYS_CINDY
#define CDEVOK(dev, func, args) { \
	unchar savbits = u.u_procp->p_cpubits; \
	u.u_procp->p_cpubits = cdevsw[major(dev)].d_flags; \
	CHANGECPU(u.u_procp); \
	(*cdevsw[major(dev)].func) args; \
	u.u_procp->p_cpubits = savbits; \
	CHANGECPU(u.u_procp); \
}
# else /* SYS_386E */		
#define CDEVOK(dev, func, args) (*cdevsw[major(dev)].func) args
# endif
		
/* From 3068 - will eventually become the real stuff */
/*
 * Altos Computer Systems: @(#)multiproc.h	1.39 87/10/21 
 */
#ident	"Altos: @(#)multiproc.h	1.39 87/10/21 "

extern int	maxcpus;
extern short	CPUMASTER;
extern short	CPUMASTERBIT;

#define MAXCPUS		3		/* max number of cpu boards supported */
#define	ALLCPUS		0xff
#define	MPLOCKED	0x8080		/* for locks that start out locked */
#define	CPUOK(p)	((p)->p_cpubits & mycpu_bit)
#define MASTERONLY(p)	(((p)->p_cpubits & ~CPUMASTERBIT) == 0)
#define	CPUPRESENT(x)	(cpupresent[x])

#if SYS_TYPE==SYS_386E || SYS_TYPE==SYS_500
#define		GOMASTER(p)
#define		CHANGECPU(p)
#elif defined(MPCOUNT)
# define	GOMASTER(p)	{\
			p->p_cpubits = CPUMASTERBIT;\
			if (!CPUOK(p)) {\
				gmcounter++;\
				qswtch();\
			} }
# define	CHANGECPU(p)	{\
			if (!CPUOK(p)) {\
				qswtch();\
			} }
#else
# define	GOMASTER(p)	{\
			p->p_cpubits = CPUMASTERBIT;\
			if (!CPUOK(p)) qswtch();\
			}
# define	CHANGECPU(p)	{if (!CPUOK(p)) qswtch();}
#endif

#ifdef OSDEBUG
# define	CHECKDEV(dev)	\
			if (major(dev) >= bdevcnt) {\
			    printf("major dev out of range file: %s line:%d\n",\
					__FILE__, __LINE__);\
			    u.u_error = EINVAL;\
			} else
#else
# define	CHECKDEV(dev)
#endif
					

extern unchar	mycpu_id, mycpu_bit;
extern unchar	cpupresent[], floatcpus;
extern short	mpinited;
extern short	nprocessors;
extern short	multiproc;
extern short	masteronly;


#if SYS_TYPE != SYS_1668
extern int	holdmaster[];
extern int	holdslave;
#endif

#ifdef ONEPROC
# define	MPLOCK(lock, name) {\
			u.u_lockcnt++; \
		}

# define	MPRELE(lock, name) {\
			u.u_lockcnt--; \
			lock = 0; \
		}

# define	mprele(lock) {\
			u.u_lockcnt--; \
			lock = 0; \
		}

# define	MPASSERT(lock)

#else
#ifdef MPPRINT
extern short	mpprint;
# define	SWPRINT(name, lock, type) \
		if (mpinited && mpprint) \
			printf("<%c%d:%x:c%d>",\
				name, type, curpc(), u.u_lockcnt);
#else
# define	SWPRINT(name, lock, type)
#endif

#ifdef MPLOCKCNT
# define	LOCKINC()	{\
					u.u_lockcnt++;\
					MPASSERT(u.u_lockcnt >= 1);\
				}
# define	LOCKDEC()	{\
					u.u_lockcnt--;\
					MPASSERT(u.u_lockcnt >= 0);\
				}
#else
# define	LOCKINC()
# define	LOCKDEC()
#endif

#ifdef	MPTRACE
# define	TRACEMP(name, lock)	 ktraceall(curpc(), name, lock)
#else
# define	TRACEMP(name, lock)
#endif

#ifdef MPCOUNT
# define	COUNTUP(name, lock)	{\
				unsigned int 	xyzzy;\
				ASSERT(name < MP_MAX);\
				locktry[name]++;\
				if ((xyzzy = spinwait(&(lock))) == 0)\
					locknowait[name]++;\
				else {\
					counter[name] += xyzzy;\
					lockfail[name]++;\
				} }
#else
# define	COUNTUP(name, lock)		spinwait(&(lock))
#endif

#ifdef OSDEBUG
# define	LOCKREL(lock)		{\
					MPASSERT(lock); lock = 0;\
					}
#else
# define	LOCKREL(lock)		lock = 0
#endif
		
# define	MPLOCK(lock, name)	{\
			COUNTUP(name, lock);\
			LOCKINC();\
			TRACEMP(name, lock);\
			SWPRINT(name, lock, 'l');\
		}
	    
# define	MPRELE(lock, name)	{\
			LOCKDEC();\
			TRACEMP(name, lock);\
			SWPRINT(name, lock, 'u');\
			LOCKREL(lock);\
		}

# define	MPASSERT(lock)	ASSERT(lock)

/* mprele is used in slp.c for unknown types of locks */
# define	mprele(lock)		{\
			LOCKDEC();\
			TRACEMP(-1, lock);\
			SWPRINT(-1, lock, 'r');\
			LOCKREL(lock);\
		}

#endif /* ONEPROC */

#define	MP_INODE	0	/* individual inodes		*/
#define	MP_INOTAB	1	/* the inode table		*/
#define	MP_SLEEP	2	/* unknown type (in msleep!)	*/
#define	MP_FILETAB	3	/* the file table		*/
#define	MP_BUF		4	/* individual buffers		*/
#define	MP_BUFFREE	5	/* the buffer free list		*/
#define	MP_BUFCHAIN	6	/* the buffer chains		*/
#define	MP_BUFCNTLCK	7	/* the buffer reader count	*/
#define	MP_PFREE	8	/* physical buffer free list	*/
#define	MP_MOUNTTAB	9	/* the mount table		*/
#define	MP_FSBFREE	10	/* the file system free blocks	*/
#define	MP_FSIFREE	11	/* the file system free inodes	*/
#define	MP_CONTEXT	12	/* context allocation		*/
#define	MP_PROC		13	/* individual process		*/
#define	MP_PROCTAB	14	/* the process table		*/
#define	MP_PROCHASH	15	/* the sleep hash queues	*/
#define	MP_UINODE	16	/* the update inode		*/
#define	MP_RUNQ		17	/* the runq			*/
#define	MP_ZOMBIEQ	18	/* the zombieq			*/
#define	MP_RFLOCK	19	/* record/file locks		*/
#define	MP_MISC		20	/* anything else		*/
#define	MP_FREEMEM	21	/* freemem lock			*/
#define	MP_PFD		22	/* the free page list		*/
#define	MP_PFDAT	23	/* individual pages		*/
#define	MP_PANIC	24	/* panic			*/
#define	MP_SWAP		25	/* the swap device pages        */
#define	MP_REGTAB	26	/* the region table		*/
#define	MP_REGION	27	/* individual regions		*/
#define	MP_MALLOC	28	/* address space allocation	*/
#define	MP_CHILD	29	/* exit/wait lock		*/
#define	MP_MSG		30	/* messages			*/
#define	MP_MSGFREE	31	/* free message list		*/
#define	MP_SHM		31	/* shared memory		*/
#define	MP_SEM		32	/* semaphores			*/
#define	MP_FPPARM	33	/* file processor parameter blks*/
#define	MP_FPCHAIN	34	/* FP request chain		*/
#define	MP_2WRITES	35	/* getblk 2 chain modifiers	*/
#define MP_LOGIN	36	/* login limitting counters	*/
#define MP_S5IFREE	37	/* system 5 inodes		*/
#define MP_ACCT		38	/* the accounting inode		*/
#define	MP_FORKNET	39	/* worknet fork			*/
#define	MP_IOBUF	40	/* fp iobuf			*/
#define	MP_MEMLOCK	41	/* memlock			*/
#define	MP_PGLIST	42	/* page list			*/
#define	MP_BASYNC	43	/* basyncnt			*/
#define MP_TIMEOUT	44	/* timeout/untimeout (callout)	*/
#define	MP_PIPE		45	/* pipe 			*/
#define	MP_INITPROC	46	/* init child proc chain	*/
#define	MP_WNETBUF	47	/* worknet buffer		*/
#define	MP_DBUF	48	/* RFS dentcanon rfs_dbuf buffer */

# define	MP_MAX		50	/* Size of counter array 	*/

#define	GM_SYSNET	0	/* wnet				*/
#define	GM_NETRMSRV	1	/* wnet				*/
#define	GM_MSG		2	/* messages			*/
#define	GM_SEM		3	/* semaphores			*/
#define	GM_SHM		4	/* shared memory		*/
#define	GM_DUUSTAT	5	/* duustat 			*/
#define	GM_XALLOC	6	/* text 			*/
#define	GM_XRELE	7	/* text 			*/
#define	GM_XDUP		8	/* text 			*/
#define	GM_XUMOUNT	9	/* text 			*/
#define	GM_MEM		10	/* memory driver 		*/
#define	GM_ERRLOG	11	/* error logging		*/
#define	GM_EXEC		12	/* exec 			*/
#define	GM_LIBATT	13	/* libattach 			*/
#define	GM_LIBDET	14	/* libdetach 			*/
#define	GM_UBALLOC	15	/* fork 			*/
#define	GM_SBREAK	16	/* sbreak 			*/
#define	GM_PROCLOCK	17	/* lock/unlock processes	*/
#define	GM_FLUSHPG	18	/* flush page cache		*/
#define	GM_USERACC	19	/* useracc 			*/
#define	GM_COREDUMP	20	/* core 			*/
#define	GM_STREAM	21	/* various stream stuff		*/
#define	GM_MSGIO	22	/* msgio 			*/
#define	GM_POLL		23	/* poll 			*/
#define	GM_SWAPFUNC	24	/* add/delete swap areas	*/
#define	GM_MAXBREAK	25	/* find max break addr		*/
#define	GM_X25		26	/* x25 driver hook in syscall	*/
#define	GM_SYSM		27	/* sysm syscall to grow stack	*/
#define	GM_EXIT		28	/* exit				*/
#define	GM_PUMOUNT	29	/* pumount			*/
#define	GM_ALLOCMAP	30	/* s5allocmap			*/
#define	GM_FREEMAP	31	/* s5freemap			*/
#define	GM_NETPACK	32	/* netpacket			*/
#define	GM_UFAULT	33	/* user fault			*/
#define	GM_SFAULT	34	/* system fault			*/
#define	GM_SYSCHK	35	/* syschk			*/
#define	GM_MISC		36	/* misc				*/
#define	GM_WORKNET	37	/* worknet */

# define	GM_MAX		40	/* Size of gomaster count array */


#ifdef MPCOUNT

extern unsigned long	counter[];
extern unsigned long	locktry[];
extern unsigned long	locknowait[];
extern unsigned long	lockfail[];
extern unsigned long	gmcounter;

#endif

#endif !defined(BDEVOK)	/* don't include in proc.h if already included */
