/*
 * Byte ordering macros for the Multidrop Ethernet interface.
 *	These routines arrange bytes stored in an order that the board
 * understands to an order that the kernel understands.  This is machine
 * dependent, so if we don't understand the SYS_TYPE, we generate a syntax
 * error.  Byte ordering routines must be called with arguments that are
 * lvalues and do not have side effects, as the address can be taken, and/or
 * it is substituted more than once in the macro.
 *	This header file is used by the Multidrop Ethernet interface and
 * by the drivers that use the interface.
 */
#ident	"@(#)meswap.h	1.3	2/19/88 08:39:53"

#if SYS_TYPE == SYS_CINDY || SYS_TYPE == SYS_386E || SYS_TYPE == SYS_500
#define ME_SHORTORDER(cook)
#define ME_LONGORDER(cook)
#else /* 386 */

#if SYS_TYPE == SYS_3068 || SYS_TYPE == SYS_3068MP
#define ME_SHORTORDER(cook) ((cook) = ((((cook)&0xFF)<<8) | (((cook)>>8)&0xFF)))
#define ME_LONGORDER(cook)  (me_long (&(cook)))

#else /* 3068 */

/* unknown case here!! */
@@@@ severe syntax error !!
@@@@ severe syntax error !!

#endif /* 3068 */
#endif /* 386 */
