/*
 *	This defines ioctl calls for the Multidrop Ethernet interface.
 * They must be passed through a driver that communicates with this interface.
 * This is used by kernel and user level code.
 */
#ident	"@(#)meioctl.h	1.3	2/19/88 08:39:39"

#define ME_IO(x)	(('E' << 16) | (x))

#define ME_GETSTATS	ME_IO (0)	/* request statistics */
#define ME_CLRSTATS	ME_IO (1)	/* clear statistics */
#define ME_GETLINKADDR	ME_IO (2)	/* get link layer address */
#define ME_GETNETADDR	ME_IO (3)	/* get network layer address */
#define ME_GETBUFCNT	ME_IO (4)	/* get number of buffers on board */
#define ME_STATUS	ME_IO (5)	/* get status of board */
#define ME_GETVCNT	ME_IO (6)	/* get number of virtual circuits */

				/* status codes returned by ME_STATUS */
#define E_OK_CHEAPER	0x01	    /* all OK using Cheapernet */
#define E_OK_ETHER	0x02	    /* all OK using Ethernet */
#define E_FAIL_ENABLE	0x80	    /* bit set if FAILED */
#define E_FAIL_ALLOC	0x80	    /* FAILED in alloc() */
#define E_FAIL_LLC	0x81	    /* FAILED in LLC    module */
#define E_FAIL_IP	0x82	    /* FAILED in IP     module */
#define E_FAIL_TP4	0x83	    /* FAILED in TP4    module */
#define E_FAIL_SYSTEM	0x84	    /* FAILED in SYSTEM module */
#define E_FAIL_MAC	0x85	    /* FAILED in MAC    module */

				/* indices for statistics array */
				/* MAC counters */
#define ELS_FRAMES	 0	    /* frames received */
#define ELS_GFRAMES	 1	    /* good frames */
#define ELS_XMIT	 2	    /* valid xmit requests */
#define ELS_GXMIT	 3	    /* successful xmits */
#define ELS_CRC		 4	    /* frames with CRC error */
#define ELS_ALIGN	 5	    /* frames with alignment error */
#define ELS_NORSRC	 6	    /* frames with out of resources */
#define ELS_OVERRUN	 7	    /* RCV-DMA overrun */
#define ELS_SHORTRX	 8	    /* illegal short frame received */
#define ELS_NOCRS	 9	    /* no carrier sense during xmit */
#define ELS_NOCTS	10	    /* lost CTS */
#define ELS_UNDERRUN	11	    /* DMA underrun */
#define ELS_DEFER	12	    /* deferred due to traffic */
#define ELS_SQE		13	    /* SQE detected */
#define ELS_COLL	14	    /* number of collisions */
#define ELS_NOBUF	15	    /* no buffer => frames dropped */
#define ELS_BADTYPE	16	    /* illegal pdu length */

				/* LLC counters */
#define ELS_DSENT	17	    /* normal LSDU's sent */
#define ELS_DRCVD	18	    /* normal LSDU's received */
#define ELS_TCSENT	19	    /* TEST command LPDU's sent */
#define ELS_TCRCVD	20	    /* TEST command LPDUs received */
#define ELS_TRRCVD	21	    /* TEST response LPDU's received */
#define ELS_TRSENT	22	    /* TEST response LPDUs sent */
#define ELS_XCSENT	23	    /* XID command LPDU's sent */
#define ELS_XCRCVD	24	    /* XID command LPDUs received */
#define ELS_XRRCVD	25	    /* XID response LPDU's received */
#define ELS_XRSENT	26	    /* XID response LPDUs sent */
#define ELS_DISC	27	    /* incoming LPDUs discarded */

#define ELS_SIZE	28	/* number of link statistics */

				/* IP/Network layer statistics */
#define ENS_NORSRC	28	    /* dropped due to no resources */
#define ENS_SENT	29	    /* non_null protocol packets sent */
#define ENS_RCVD	30	    /* nun_null protocol packets rcvd */
#define ENS_NSENT	31	    /* null protocol packets sent */
#define ENS_NRCVD	32	    /* null protocol packets received */
#define ENS_ERCVD	33	    /* error PDUs received */
#define ENS_CKSM	34	    /* dropped due to chksm failure */
#define ENS_CONG	35	    /* dropped due to congestion */
#define ENS_TMO		36	    /* time out */
#define ENS_NORESP	37	    /* dropped due to time out */
#define ENS_NOADDR	38	    /* invalid remote address */
#define ENS_NOOPT	39	    /* packets with bad options */
#define ENS_PROTO	40	    /* procedure violations */
#define ENS_ESENT	41	    /* error PDUs sent */
#define ENS_DROPPED	42	    /* dropped PDUs */
#define ENS_NOOPT3	43	    /* unsupported type 3 options */

				/* number of network statistics */
#define ENS_SIZE	(44 - ELS_SIZE)

				/* transport layer statistics */
#define ETS_US_I_CON	44	    /* unsuccessful inbound connections */
#define ETS_US_O_CON	45	    /* unsuccessful outbound connections */
#define ETS_S_I_CON	46	    /* successful inbound connections */
#define ETS_S_O_CON	47	    /* successful outbound connections */
#define ETS_INV_TPDUS	48	    /* invalid TPDU's */
#define ETS_DAT_RETRAN	49	    /* retransmissions during data transfer */
#define ETS_DATA_SENT	50	    /* bytes of user data transmitted */
#define ETS_DATA_RECVD	51	    /* bytes of user data received */
#define ETS_XPD_SENT	52	    /* bytes of expedited data sent */
#define ETS_XPD_RECVD	53	    /* bytes of expedited data received */
#define ETS_TPDU_RETRAN	54	    /* TPDU retransmissions */
#define ETS_INACTIVE	55	    /* terminated inactive connections */
#define ETS_NO_MACHS	56	    /* refused connections (lack of machs) */
#define ETS_OPEN_CON	57	    /* open connections */
#define ETS_PROTO_ERRS	58	    /* protocol errors */
#define ETS_TPDU_SENT	59	    /* transmitted TPDUs */
#define ETS_TPDU_RECVD	60	    /* received TPDUs */
#define ETS_DISCONS	61	    /* user disconnects */
#define ETS_CRRETXMIT	62	    /* CR TPDU retransmissions */

				/* number of network statistics */
#define ETS_SIZE	(63 - (ENS_SIZE + ELS_SIZE))

#define ESTAT_SIZE	63	/* number of int's in stat array */
