/*
 *	@(#)mdc.h	1.19 88/03/19 
 *
 *	multi-drop (RS232/RS422 comm board) driver
 *  Original author: Dave Olson
 */

#undef NETOPEN	/* something is including net.h, and we don't want
	their definition */

#define CONSOLE		0	/* minor device # for console */
#define MDC_RCVSIZ		32	/* receive buffer size -- must be power of 2 */
#define M_RCVMSK		(MDC_RCVSIZ-1)	/* mask for keeping index in chc_rbuf in range */

#define RS232PORTS	5	/* RS 232 ports per board (chan 0-4) */
#define NETCHAN 4	/* chan 4 can be jumpered as worknet or RS 232 on
	386-2000 */
#define NCHANS 256

#define MAXMDROPS 3	/* max number of multidrop boards we support
	(on 386E, 2 and 3 have to be ACPA-E, first is the IOC) */

#define MAXCHANS 64	/* max number of channels supported per board. */

#if SYS_TYPE == SYS_386E
extern unchar num_mdc_onboard;	/* actual # of onboard ports */
	/* what board to send cmd to */
# define BDNUM(mdev) (mdev<num_mdc_onboard ? 0 : \
	1 + ((mdev-num_mdc_onboard)/MAXCHANS))

	/* usually used to fake a minor # for mdc_sendcmd
		so that the cmd goes to a pre-determined board */
# define BDTOMDEV(board) ((board)==0 ? 0 : num_mdc_onboard+((board)-1)*MAXCHANS)
# define MAX_ONBOARD 24	/* max on-board for 1000 */

#else			/* CINDY */

# define BDNUM(mdev) (mdev/MAXCHANS) /* board # from minor # */

	/* usually used to fake a minor # for mdc_sendcmd
		so that the cmd goes to a pre-determined board */
# define BDTOMDEV(board) ((board)*MAXCHANS)
#endif

/* get the board's attention */
# define MDC_ATTN(board) int_ioproc(mdc_attn[board])

typedef struct {
	unchar q_cmd;	/* cmd identifier */
	unchar q_chan;	/* chan identifier */
	unchar q_addr[4]; /* paramater block address (lo is byte 0) */
	unchar q_len0;	/* buffer length (low byte) */
	unchar q_len1;	/* buffer length (high byte) */
} cmdentry;

struct mdc_config	{ /* structure must be 32 bytes total */
	unsigned char ttyports;
	unsigned char for_future[31];
};	/* for BD_CONFIG command */

/* value for BD_INT_INTVL, used in both mdc.c and mdcwnet.c */
#define MD_INT_INTVL 20

/* values for q_cmd */
/* general board commands */
#define BD_RESET	0	/* reset board */
#define BD_ENABLE	1	/* enable board */
#define BD_CLRINT	2	/* clear board interrupt (all pending in
	intarray have been serviced) */
#define BD_INT_INTVL 3	/* minimum # of msecs between 'normal'
	interrupts. */
#define BD_ERR_INTVL 4	/* minimum # of seconds between 'error'
	interrupts */
#define BD_JMPMON	5	/* tell board to jump to monitor prom
	(functionally same as BD_RESET, except during board debug) */
#define BD_CONFIG	6	/* report 'board' configuration (supported only
	on the 386/1000 for now) */
/* 6 - 0xf reserved for future */

/* 422 terminal commands */
#define CHANOPEN	0x10	/* open async channel */
#define CHANCLOS	0x11	/* close async channel */
#define CHANPARM	0x12	/* set channel parameters */
#define CHANXMIT	0x13	/* transmit to channel */
#define CHANABRT	0x14	/* abort transmit on channel */
#define CHANFRGN	0x15	/* start foreign code */
#define CHANPOLL	0x16	/* Transmit one byte in 'polled mode',
	normally used only for kernel printf's. */
/* 0x17 - 0x1f reserved for future */

/* net cmds */
#define MNETOPEN	0x20	/* open network */
#define MNETXMIT	0x21	/* transmit packet (low speed) */
#define MNETFAST	0x22	/* transmit packet (high speed) */
#define MNETCLS	0x23	/* close network */

#ifdef WSENDLIM	
/* so we don't have to include net.h for everything that wants to
	include mdc.h */

/* net xmit buffer structure */
typedef struct {
	unchar nx_lenlo, nx_lenhi;	/* packet length */
	unchar nx_data[WSENDLIM];	/* data to transmit */
} mdnetXbuf;

/* net receive buffer structure */
typedef struct {
	unchar nr_lenlo, nr_lenhi;	/* board sets to actual packet length */
	unchar nr_data[WRECLIM];	/* data buffer filled in by board */
} mdnetRbuf;

/* net control block (same function as chanctrl, but for net ports) */
typedef struct {
	unchar n_errs[10];	/* error counts */
	unchar n_maxlo, n_maxhi;	/* length of n_rcvbuf */
	unchar n_nbuf;	/* number of net receive buffers */
	unchar n_in, n_out; /* indices into n_nbuf, n_in set by
		board, n_out set by driver */
	unchar n_addr;	/* network address */
	mdnetRbuf n_rbuf[NUMWRBUFS];
} mdnetctrl;
#endif /* WSENDLIM */


typedef struct {
	unchar int_type;	/* type of interrupt */
	unchar int_chan;	/* channel requiring service */
} intentry;

/* interrupt types (int_type) */
#define INTXMIT 0	/* finished copying chars from host (or parmset
	done) */
#define INTRCV 1	/* char(s) received */
#define INTDTR 2	/* dtr changed */
#define INTRTS 3	/* rts changed */
#define INTBRK 4	/* received break */
#define INTNETX 5	/* net transmit completed */
#define INTNETR 6	/* net receive completed */
#define INTFRGN 7	/* foreign code interrupt (future) */
#define INT_ERROR 8	/* board is reporting channel errors */
#define INT_BDERR 9	/* board is reporting a board firmware/hardware
	error */
#define INT_NETERR 0xA	/* board is reporting net errors */
#define LASTINTCHAN	0xff	/* no more pending interrupts */

#pragma pack(2)
struct mdcdev {
	unchar mdc_ver0, mdc_ver1;
	unchar mdc_index;	/* command queue input pointer */
	unchar mdc_out;	/* command queue output pointer (set by board) */
	cmdentry mdc_cmds[NCHANS];
	intentry mdc_intarray[NCHANS];
};
#pragma pack()

/* channel control block structure */
typedef struct {
	unchar chc_stat0, chc_stat1;	/* channel statuses */
	unchar chc_errs[16];	/* array containg counts of assorted errors */
	unchar chc_in;	/* receive buffer input index */
	unchar chc_out;	/* receive buffer output index */
	unchar chc_rbuf[MDC_RCVSIZ];	/* receive buffer */
} chanctrl;

/* chc_stat0 */
#define CHPOLL	1	/* polling enabled on this channel (422 only) */
#define	CHDTR	2	/* dtr present? (always 1 for 422 lines) */
#define	CHRTS	4	/* rts present? (always 1 for 422 lines) */
/* bit 3 not used by kernel (only by secondary/board firmware */
#define CHPARITY	0x10	/* receive parity error */
#define CHOVRRUN	0x20	/* receiver overrun (data lost) */
#define CHFRAME	0x40	/* framing error */
/* chc_stat1 is currently unused */

/* channel parameter block */
typedef struct {
	unchar ch_parm0, ch_parm1;	/* channel parameters */
	unchar ch_flow;	/* type of flow control */
	unchar ch_xoffchar;	/* suspend output */
	unchar ch_xonchar;	/* restart output (any char if 0xff) */
	unchar ch_enables;	/* mask of when to interrupt */
} chan_parm;

/* for 422 terminals, ch_parmX are ignored */
/* ch_parm0 */
#define NOPARITY	0
#define EVNPAR	1
#define ODDPAR	2
#define MARKPAR	3	/* mark parity ( bit 7 high ) */
#define SPCPAR	4	/* space parity ( bit 7 low ) */
#define STOPONE 8	/* 1 stop bits */
#define STOPONE5 0x10	/* 1.5 stop bits */
#define STOPTWO 0x18	/* 2 stop bits */
#define BIT5 0	/* 5 bits/char */
#define BIT6 0x40	/* 6 bits/char */
#define BIT7 0x20	/* 7 bits/char */
#define BIT8 0x60	/* 8 bits/char */
#define BRKENAB	0x80	/* break enable */

/* ch_parm1 */
/*  baud rate goes in bits 0-3 */
#define WANGFLOW	0x20	/* enable special Wang flow control */
#define CTSON	0x40	/* assert CTS */
#define DSRON	0x80	/* assert DSR */

/* ch_flow */
#define FLODTR 1	/* xmit dtr flow control */
#define FLORTS 2	/* xmit rts flow control */
#define	FLOXSFT 4	/* xmit software flow control (xon/xoff) */
#define FLODSR 0x8	/* rcv dsr flow control */
#define FLOCTS 0x10	/* rcv cts flow control */
#define	FLORSFT 0x20	/* rcv software flow control (xon/xoff) */
#define KEEPALIVE	0x40	/* if set secondary will NOT go offline
	even if not polled for > 2minutes */
#define INPUTPREFERRED 0x80	/* TCU only: use 'small' buffer for
	output and 'large' buffer for input (i.e. for high speed input) */

/* ch_enables */
#define E_INTXMIT	1	/* interrupt on transmits */
#define E_INTRCV	2	/* interrupt on receive */
#define E_INTDTR	4	/* interrupt on dtr change */
#define E_INTRTS	8	/* interrupt on rts change */
#define E_INTBRK	0x10	/* interrupt on break */
/* bits 5 -7 reserved */


/*
 *  structure for handling the print-screen function
 *
 *  There is a copy of this structure for each serial channel.
 *
 *  This structure resides outside of kernel's data space in the clist
 *  segment.
 *  pskey is first in struct for faster dereferencing
 */
typedef struct {
	unchar pskey[10];		/* print-screen key sequence */
	unchar  psindx;		/* index of current char in key sequence */
	/* number of chars in print-screen key and esc sequences */
	unchar pskeylen:4, psesclen:4;
	unchar psesc[10];		/* print-screen escape sequence */
} mpscrn;


/* first multidrop interrupt vector.  It is the same as SIOVEC
in sc.h, since mdrop and sio boards share same RANGE of interrupt
vectors. */
#if SYS_TYPE == SYS_386E
# define MDCVEC	1	
#else			/* CINDY */
# define MDCVEC	2	
#endif

typedef struct mdcdev *mdc_ctrl;

#define INT_FC(x) (0x10+x) /* 0x10 to 0x1F are foreign code ints */
#define INT_MEM	   0x20 /* Memory command complete */
#define INT_FCE(x) 0x30 /* 0x30 through 0x3F are foreign code exits */
#define INT_FCMASK 0xF0 /* mask to get foreign code interrupt type */

/* MDC memory manipulation commands					*/
#define	MEM_READ	0x40
#define	MEM_WRITE	0x41
#define	MEM_CNTL	0x42

/* Foreign code commands: 0x50 to 0x5F */
#define FC_CMD(x)	(0x50 + x)


#ifdef INKERNEL
extern unchar mdcvecs[];

/* these are all allocated in the startup code, so we don't waste
	memory if no boards are present.  (We allocate enough for
	each board, if more than one board.
*/
extern mdc_ctrl mdcdev;
extern chanctrl *mdc_chctrl;
extern mpscrn *mpsbuf;
extern chan_parm *chparms;
extern struct tty *mdc_tty;
extern short num_mdcports;
extern unchar mdcdevnum;	/* major device number for multidrop */

/* defined in mdc.c */
extern unchar mdc_attn[];

/* are we using netport for net, or rs232? (GLOBAL)*/
extern char mdcnetuse[];

#define	MDCVER(cont)	(cont->mdc_ver >> 3)
/* multidrop boards have version #'s of MIN_MDC_VERS and above,
	version #'s lower are assigned to sio boards.  (Actually the
	firmware downloaded to the board.)
*/
#define MIN_MDC_VERS 0x10	/* temporary, fix later. 2/86 */

#endif /* INKERNEL */
