/*
 *	@(#)locking.h	1.6 3/14/88 
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 *   Flag values for locking system call
 */
#include "lockcmn.h"

#define LK_UNLCK  CMN_UNLCK		/* unlock request */
#define LK_LOCK   CMN_WRLCK		/* lock request */
#define LK_RLCK   CMN_RDLCK		/* read permitted only lock request */
#define LK_NBLCK  20		/* non-blocking lock request */

#ifdef INKERNEL
/* 286 and altos 5.2 386 style */
#define OLK_UNLCK  OCMN_UNLCK		/* unlock request */
#define OLK_LOCK   OCMN_WRLCK		/* lock request */
#define OLK_RLCK   OCMN_RDLCK		/* read permitted only lock request */
#define OLK_NBLCK  2		/* non-blocking lock request */
#endif

#define LK_NBRLCK 4		/* non-blocking read only lock request */
			/* KSAM-X5 */
#define LK_GETLK  5		/* V2 request to find first blocking lock */
#define LK_SETLK  6		/* V2 non-blocking lock request */
#define LK_SETLKW 7		/* V2 blocking lock request */
#define LK_TESTLK 8		/* V2 request to test for locks */

#define LWANT     0x10
#define USE_PID		1
#define IGN_PID		2

struct locklist {
	    /* NOTE: ll_link must be first in struct */
	struct locklist	*ll_link;	/* link to next lock region */
	struct locklist	*ll_slp;	/* pointer to lock being slept on */
	ushort  	ll_flags;	/* misc flags ** sleeping */
	ushort		ll_pid; 	/* process which owns region */
	sysid_t		ll_sysid;	/* system process is on */
	off_t		ll_start;	/* starting offset */
	off_t		ll_end;		/* ending offset, zero is eof */
};


#ifdef INKERNEL
extern struct locklist *locklist;
#endif

/* ll_flags */
#define LROLOCK   01	/* record is locked & is read only */

#define	MAXLOCKSZ ((off_t) (1L << 30))

/* flags for the locked() routine. */

#define BLOCK	0x00	/* A001 */
#define READCHK	0x01	/* A001 */
#define NBLOCK 	0x02	/* A001 */
#define RDLOCK 	0x04	/* A001 */
#define TESTLK 	0x08	/* A001 */
#define GETLK	0x10	/* A001 */
