
/*  @(#)ld0.h	1.2 88/03/19   */
/* tty line discipline 0 processing for
 * pushable line discipline streams module.
 */

struct ld
{
	short ld_iflags;	/* input mode: ioctl message can set */
	short ld_oflags;	/* output mode: ioctl can set */
	short ld_lflags;	/* line discipline mode: ioctl can set */
	short ld_state;		/* internal state of tty ld */
	char ld_col;		/* output column of tty */
	char ld_erase;		/* erase char */
	char ld_kill;		/* line kill char */
	char ld_intrc;		/* interrupt char */
	char ld_quitc;		/* quit char */
	char ld_startc;		/* start char */
	char ld_stopc;		/* stop char */
	char ld_eofc;		/* end-of-file char */
	char ld_eol;		/* input delim char (like NL) */
	char ld_eol2;		/* 2nd input delim char */
	char ld_swtchc;		/* switch char for shl */
	char canonb[CANBSIZ];   /* input buffer for line formation */
	char *op;		/* pointer for input buffer */
	/* short ld_ttypgid;	process group id for tty signalling */
};


#define CANBSIZ	256
#define	CTRL(c)	('c'&037)
#define	EOT	CTRL(d)


/* define partab character types */
#define	ORDINARY	0
#define	CONTROL		1
#define	BACKSPACE	2
#define	NEWLINE		3
#define	TAB		4
#define	VTAB		5
#define	RETURN		6

/* internal states for ld module */
#define	TTSTOP	01		/* stopped by ^S */
#define	TTESC	02		/* have just seen '\' (ldinsrv)  */
#define TTCR	04		/* mapping NL to CR-NL */
#define	TTUSE	010		/* this structure in use */
#define	TTBLOCK	020		/* have sent STOP message */
#define TTIOC	040		/* TCGETA just went down */
#define TTESC2  0100		/* 2nd '\' in a row */
#define TTESC1	0200		/* have just seen `\` (ldin) */

/* delay values	*/
#define TICK1  1
#define TICK2  2
#define TICK3  3
#define TICK4  4
#define TICK6  6
#define TICK9  9
#define MANYTICK  127
