/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	@(#)kdef.h	1.19 88/03/19  */

#define SYS	"unix"
#define NODE	""		/* set to null so /etc/systemid will be read */
#define REL	"5.3.1"
#define VER	"1"
#if SYS_TYPE == SYS_CINDY
#define MACH	"386/2000"
#endif
#if SYS_TYPE == SYS_386E
#define MACH	"386/1000"
#endif
#if SYS_TYPE == SYS_2086
#define MACH	"2086"
#endif
#if SYS_TYPE == SYS_500
#define MACH	"386/500"
#endif

/*
 * The following entries form the tuneable parameter table.
 */

#define NBUF 1024
#define NINODE 500
#define NS5INODE 500
#define NWNINODE 100
#define NFILE 500
#define NMOUNT 25
#define NCALL 60
#define NPROC 200
#define NCLIST 200
#define NFLOCKS 200
#define NSDSEGS 25 /* xenix shared data */
#define NSDSLOTS 1
#define XSEMMAX	200 /* xenix semaphores */

/* define maximums for tuneable parameters */
#define MAXNPROC 	2000
#define MAXNFILE 	3200
#define MAXNCLIST	2500
#define MAXNINODE	 500


#define MINBUF   20	/* the minimum number of I/O buffers */

#ifndef NOSTREAMS

/* The following stuff is for streams. */

#define NQUEUE  96
#define NSTREAM  32
#define NBLK4096  4
#define NBLK2048  32
#define NBLK1024  32
#define NBLK512  16
#define NBLK256  16
#define NBLK128 32
#define NBLK64  40
#define NBLK16  40
#define NBLK4  40
#define NMUXLINK  87
#define NSTRPUSH  9
#define NSTREVENT  256
#define MAXSEPGCNT  1
#define STRLOFRAC  80
#define STRMEDFRAC  90
#define STRMSGSZ  4096
#define STRCTLSZ  1024

#else   /* NOSTREAMS */

/* This is reasonable for kernels with no streams */

#define	NQUEUE 1
#define	NSTREAM 1
#define	NBLK4096 4
#define	NBLK2048 0
#define	NBLK1024 0
#define	NBLK512 0
#define	NBLK256 0
#define	NBLK128 0
#define	NBLK64 0
#define	NBLK16 0
#define	NBLK4 0
#define	NMUXLINK 1
#define	NSTRPUSH 9
#define	NSTREVENT 1
#define	MAXSEPGCNT 0
#define	STRLOFRAC 80
#define	STRMEDFRAC 90
#define	STRMSGSZ 4096
#define	STRCTLSZ 1024

#endif  /* NOSTREAMS */

/* maxup is the maximum number of processes per user */

#define	MAXUP 30

/* hashbuf must be a power of 2 */

#define	NHBUF 128
#define	NPBUF 8

/* File region locking */

#define	FLCKREC 100

/* Shared Libraries:  Maximum number of libraries that can be
 *                    attached to a process at one time.
 */

#define	SHLBMAX 2

/* Delay for delayed writes */

#define	NAUTOUP 10

/* Maximum number of open files per process.  Now a configurable
 * parameter but only applies to direct open and close calls (i.e
 * stdio, sh, etc will not make use of more than 20 in this release).
 */
#define	NOFILES 50

/* added for paging */

/*	every process typically has 4 regions (data, text, stack, uarea),
	and possibly more if using shared memory.
*/
#define	NREGION (NPROC*4)
#define	SPTMAP 50
#define	VHNDFRAC 16
#define	MAXPMEM 0
#define	GPGSLO 25
#define	GPGSHI 40
#define	GPGSMSK GETPGSMSK
#define	VHANDR 1
#define	VHANDL 10
#define	MAXSC 1
#define	MAXFC 1
#define MAXUMEM 2560
#define	BDFLUSHR 1
#define	MINARMEM 25
#define	MINASMEM 25
#define	PUTBUFSZ 256

/* DU */

#define	NSRMOUNT	10
