/*
 * @(#)kd.h	1.1 88/03/19 
 *
 * definitions for PC AT keyboard/display driver
 */

/*
 * Copyrighted as an unpublished work.
 * (c) Copyright 1986 INTERACTIVE Systems Corporation
 * All rights reserved.
 *
 * RESTRICTED RIGHTS
 *
 * These programs are supplied under a license.  They may be used,
 * disclosed, and/or copied only as permitted under such license
 * agreement.  Any copy must contain the above copyright notice and
 * this restricted rights notice.  Use, copying, and/or disclosure
 * of the programs is strictly prohibited unless otherwise provided
 * in the license agreement.
 */

/*
 * Types of displays supported
 */
#define	KD_MONO		01	/* IBM monochrome display adapter */
#define	KD_HERCULES	02	/* Hercules monochrome graphics adapter */
#define	KD_CGA		03	/* IBM color graphics adapter */
#define	KD_EGA		04	/* IBM enhanced graphics adapter */

/*
 * Virtual display constants
 */
#define	KD_WIDTH	80		/* normal screen width */
#define	KD_NARROWWIDTH	40		/* narrow screen width */
#define	KD_HEIGHT	25		/* screen height */
#define	KD_MAXSCRSIZE	(KD_WIDTH * KD_HEIGHT)	/* max supported screen size */
#define	KD_SCRTOBUF	0		/* transfer from screen to buffer */
#define	KD_BUFTOSCR	1		/* transfer from buffer to screen */

/*
 * keyboard controller I/O port addresses
 */
#define KB_OUT	0x60		/* output buffer R/O */
#define KB_IDAT 0x60		/* input buffer data write W/O */
#define KB_STAT 0x64		/* keyboard controller status R/O */
#define KB_ICMD 0x64		/* input buffer command write W/O */

/*
 * keyboard controller commands and flags
 */
#define KB_INBF		0x02	/* input buffer full flag */
#define KB_OUTBF	0x01	/* output buffer full flag */
#define KB_GATE20	0x02	/* set this bit to allow addresses > 1Mb */
#define KB_ROP		0xD0	/* read output port command */
#define KB_WOP		0xD1	/* write output port command */
#define	KB_RCB		0x20	/* read command byte command */
#define	KB_WCB		0x60	/* write command byte command */
#define	KB_ENAB		0xae	/* enable keyboard interface */
#define	KB_INHIB	0x10	/* keyboard inhibited */
#define	KB_DISAB	0x10	/* disable keyboard */
#define	KB_EOBFI	0x01	/* enable interrupt on output buffer full */
#define	KB_INOV		0x08	/* override keyboard inhibit function */
#define KB_ACK		0xFA	/* Acknowledgement byte from keyboard */
#define	KB_RESETCPU	0xFE	/* command to reset AT386 cpu */
#define	KB_READID	0xF2	/* command to read keyboard ID */

/*
 * The keyboard translation tables are laid out as follows:
 * There are four tables, one for unaugmented keypresses,
 * one for shifted keypresses, one for alted keypresses, and
 * one for shift-alted keypresses.  Each table has 128 16 bit 
 * entries, containing flags in the top 8 bits and the character
 * to send in the lower 8 bits.
 *
 *	 1 1 1   1
 *	 5 4 3   1  8 7      0
 *	+-+-+-+-+----+--------+
 *	|n|c|t| |type| char   |
 *      +-+-+-+-+----+--------+
 *
 *	n - key affected by num lock flag
 *	c - key affected by caps lock flag
 *	t - key affected by control key flag
 *	type - type of key, prefix specifier
 *	char - character to send
 *
 */
/*
 * keyboard translation modes
 */
#define	K_RAW		0x00	/* keyboard just sends raw up/down scan codes */
#define	K_XLATE		0x01	/* keyboard translates scan codes to ascii */
/*
 * table selectors
 */
#define	K_NORMTAB	0x00	/* select unaugmented keyboard table */
#define	K_SHIFTTAB	0x01	/* select shifted keyboard table */
#define	K_ALTTAB	0x02	/* select alted keyboard table */
#define	K_ALTSHIFTTAB	0x03	/* select alt-shifted keyboard table */
/*
 * character table flag bits.
 */
#define	NUMLCK		0x8000	/* flag key as affected by num lock key */
#define	CAPLCK		0x4000	/* flag key as affected by caps lock key */
#define	CTLKEY		0x2000	/* flag key as afected by control keys */
/*
 * character table key types
 */
#define	NORMKEY		0x0000	/* key is a normal key, send with no prefix */
#define	SHIFTKEY	0x0100	/* key is a shift key */
#define	BREAKKEY	0x0200	/* key is a break key */
#define	SS2PFX		0x0300	/* prefix key with <ESC> N */
#define	SS3PFX		0x0400	/* prefix key with <ESC> O */
#define	CSIPFX		0x0500	/* prefix key with <ESC> [ */
#define	NOKEY		0x0f00	/* flag a key as nonexistant */
#define	TYPEMASK	0x0f00	/* select key type bits */

/*
 * kb_state bit definitions
 */
#define LEFT_SHIFT	0x01	/* left shift key depressed */
#define	LEFT_ALT	0x02	/* left alt key depressed */
#define	LEFT_CTRL	0x04	/* left control key depressed */
#define	RIGHT_SHIFT	0x08	/* right shift key depressed */
#define	RIGHT_ALT	0x10	/* right alt key depressed */
#define	RIGHT_CTRL	0x20	/* right control key depressed */
#define	CAPS_LOCK	0x40	/* caps lock key down */
#define	NUM_LOCK	0x80	/* num lock key down */
#define	ALTSET		(LEFT_ALT|RIGHT_ALT)
#define	SHIFTSET	(LEFT_SHIFT|RIGHT_SHIFT)
#define	CTRLSET		(LEFT_CTRL|RIGHT_CTRL)
#define	NONTOGGLES	(ALTSET|SHIFTSET|CTRLSET)

/* keyboard scan codes */
#define SYS_REQ	0x54		/* system request key */
#define DEL_KEY	0x53		/* delete key */
#define D_KEY	0x20		/* 'd' key */
#define N_KEY	0x31		/* 'n' key */
#define P_KEY	0x19		/* 'p' key */
#define F_KEY	0x21		/* 'f' key */
#define F1_KEY	0x3B		/* F1 key */
#define F2_KEY	0x3C		/* F2 key */
#define F3_KEY	0x3D		/* F3 key */
#define F4_KEY	0x3E		/* F4 key */
#define F5_KEY	0x3F		/* F5 key */
#define F6_KEY	0x40		/* F6 key */
#define F7_KEY	0x41		/* F7 key */
#define F8_KEY	0x42		/* F8 key */
#define F9_KEY	0x43		/* F9 key */
#define F10_KEY	0x44		/* F10 key */

#define	ESCTBLSIZ	18	/* no. of entries in 101/102 key index tbl */

#define SIZETTY (sizeof(struct tty))

/*
 * character flags, should not conflict with FRERROR and friends
 * in tty.h
 */
#define GEN_ESCLSB	0x0800		/* generate <ESC> [ prefix to char */
#define GEN_ESCN	0x0400		/* generate <ESC> N prefix to char */
#define GEN_ESCO	0x0200		/* generate <ESC> O prefix to char */
#define NO_CHAR		0x8000		/* did not generate a char */

#define MAXTAB	10		/* maximum number of tab stops */

/* Commands for LED and typematic start/rate on the AT */
#define	KDCQMAX		8	/* length of keyboard command queue */
#define LED_WARN	0xED	/* Tell kbd that following byte is led status */
#define LED_SCR         0x01    /* Flag bit for scroll lock */
#define LED_NUM		0x02	/* Flag bit for num lock */
#define LED_CAP		0X04	/* Flag bit for cap lock */
#define	ACK_WAIT	0x01	/* flag for waiting for kbd response */
#define	TYPE_WARN	0xF3	/* command--next byte is typematic values */
#define	TYPE_VALS	0x20	/* max speed (30/s) and 1/2 sec delay */
#define	SCAN_WARN	0xF0	/* kbd command to set scan code set */

/*
 * type of adapter installed, matches bits in CMOS ram
 */
#define	MCAP_UNK	0xff	/* adapter not determined yet */
#define MCAP_MONO	0x03	/* mono adapter installed */
#define MCAP_COLOR	0x02	/* color adapter installed in 80 column mode */
#define MCAP_COLOR40	0x01	/* color adapter installed in 40 column mode */
#define MCAP_EGA	0x00	/* EGA adapter installed */

/* offsets from 6845 base address for various registers */
#define DATA_REG	0x1
#define MODE_REG	0x4
#define COLOR_REG	0x5	/* color adapter only */
#define STATUS_REG	0x6

/* definitions for bits in ad_colmode */
#define MODE_TYPE	0x07   	/* mask for alpha/graphic modes */
#define MODE_GRAPH	0x04  	/* graphics modes */
#define MODE_40		0x00	/* 40x25 alphanumeric */
#define MODE_80		0x01	/* 80x25 alphanumeric */
#define MODE_GRLRES	0x04	/* 160x100 graphics */
#define MODE_GRMRES	0x05	/* 320x200 graphics */
#define MODE_GRHRES	0x06	/* 640x200 graphics */
#define MODE_BLINK	0x00	/* 8 background colors, blink */
#define MODE_BG16	0x08	/* 16 background colors, no blink */
#define MODE_CO		0x00	/* color adaptor, enable color */
#define MODE_BW		0x10	/* color adaptor, disable color */

/* definitions for bits in the color adapter mode register */
#define M_ALPHA40	0x00	/* 40 by 25 alphanumeric */
#define M_ALPHA80	0x01	/* 80 by 25 alphanumeric */
#define M_GRAPH		0x02	/* 320x200 or 640x200 graphics */
#define M_BW		0x04	/* black & white */
#define M_ENABLE	0x08	/* video enable */
#define M_HIGHRES	0x10	/* 640x200 B&W graphics */
#define M_BLINK		0x20	/* enable blink attribute */

/* definitions for bits in the color adapter status register */
#define S_UPDATEOK	0x01	/* safe to update regen buffer */
#define S_VSYNC		0x08	/* raster is in vertical retrace mode */

/* definitions for loading data into CRT controller registers */
#define R_STARTADRH	12	/* start address, high word */
#define R_STARTADRL	13	/* start address, low word */
#define R_CURADRH	14	/* cursor address, high word */
#define R_CURADRL	15	/* cursor address, low word */

/* definitions for the EGA */
#define IN_STAT_0	0x3c2	/* input status register zero */
#define MISC_OUT	0x3c2	/* miscellaneous output register */
#define IN_STAT_1	6	/* offset of input status register 1 */
#define FEAT_CTRL	6	/* offset of feature control register */
#define SW_SENSE	0x10	/* switch sense bit in input status zero */
#define CLKSEL		2	/* shift to select switch number */
#define GRAPH_1_POS	0x3cc	/* graphics 1 position */
#define GRAPH_2_POS	0x3ca	/* graphics 2 position */
#define GRAPHICS1	0	/* value for graphics 1 */
#define GRAPHICS2	1	/* value for graphics 2 */
#define SEQ_RUN		0x03	/* start sequencer */
#define PALETTE_ENABLE	0x20	/* palette address source in attribute reg */
#define CHGEN_BASE	0xa0000	/* base address for character generator */
#define CHGEN_SIZE	8192	/* character generator is 8K */
#define MONO_BASE	0xb0000	/* location of mono display memory */
#define MONO_SIZE	4096	/* mono has 4K of memory */
#define COLOR_BASE	0xb8000	/* location of color display memory */
#define COLOR_SIZE	16384	/* color has 16K of memory */
#define	EGA_BASE	0xa0000	/* location of enhanced display memory */
#define EGA_SIZE	32768	/* EGA has at least 32K in planes 0,1 */
#define NSEQ		5	/* number of sequencer registers */
#define NATTR		20	/* number of attribute registers */
#define NGRAPH		9	/* number of graphics registers */
#define LOAD_COLOR	4	/* mode number for loading color characters */
#define LOAD_MONO	5	/* mode number for loading mono characters */

/* definitions for bits in the attribute byte */
#define BLINK		0x80
#define BRIGHT		0x08
#define REVERSE		0x70
#define NORM		0x07
#define UNDERLINE	0x01	/* underline on mono, blue on color */

#define CLEAR		(NORM<<8|0x20)
#define BCLEAR		(NORM|BRIGHT<<8|0x20)
#define ALLATTR		(BLINK|BRIGHT|REVERSE|NORM|UNDERLINE)
#define NOTBGRND	(ALLATTR&(~REVERSE))
#define NOTFGRND	(ALLATTR&(~NORM))

/* definitions for ringing the bell */
#define NORMBELL	1331	/* initial value loaded into timer */
#define BELLLEN		(HZ/10)	/* ring for 1/10 sec. between checks */
#define BELLCNT		2	/* check bell twice before turning off */
#define TONE_ON		3	/* 8254 gate 2 and speaker and-gate enabled */
#define TIMER		0x40	/* 8254.2 timer address */
#define TIMERCR		TIMER+3	/* timer control register address */
#define TIMER2		TIMER+2	/* timer tone generation port */
#define T_CTLWORD	0xB6	/* value for timer control word */
#define TONE_CTL	0x61	/* address for enabling timer port 2 */


struct adtstruct {
	ushort	*ad_scraddr;	/* address of adaptor memory */
	ushort	ad_scrmask;	/* size-1 in shorts of adaptor memory */
	ushort	ad_address;	/* address of corresponding M6845 or EGA */
	unchar	ad_type;	/* adapter type */
	unchar	ad_colmode;	/* color adapter mode */
	unchar	ad_colsel;	/* color select register byte */
	unchar	ad_modesel;	/* mode register byte */
	unchar	ad_undattr;	/* attribute to use when underlining */
};


struct kdvtinfo {	/* device specific info for kd vt driver */
	unchar			kbmode;		/* keyboard mode */
	unchar			dmode;		/* display mode */
	unchar			flags;		/* flags */
	struct ansistate	as;	/* ansi terminal state */
};

#define	KD_TEXT		0	/* ansi x3.64 emulation mode */
#define KD_TEXT0        0       /* same as above */
#define KD_TEXT1        2       /* new text mode doesnt load char generator */
#define	KD_GRAPHICS	1	/* graphics mode */

#define	KD_MAPPED	0x01	/* set when display is mapped */

/*
 * Types for indexing into reginfo table.
 */
#define I_6845MONO	0
#define I_6845COLOR	1
#define I_EGAMONO	2
#define I_EGACOLOR	3
#define I_SEQ		4
#define I_GRAPH		5
#define I_ATTR		6

/*
 * Macro for setting a particular EGA register.
 */
#define out_reg(riptr, index, data)	outb((riptr)->ri_address, (index)); \
					outb((riptr)->ri_data, (data));
	
struct reginfo {
	ushort	ri_count;	/* number of registers */
	ushort	ri_address;	/* address register */
	ushort	ri_data;	/* data register */
};

struct m6845init {
	unchar  mi_hortot;	/* Reg  0: Horizontal Total     (chars) */
	unchar  mi_hordsp;	/* Reg  1: Horizontal Displayed (chars) */
	unchar  mi_hsnpos;	/* Reg  2: Hsync Position       (chars) */
	unchar  mi_hsnwid;	/* Reg  3: Hsync Width          (chars) */
	unchar  mi_vertot;	/* Reg  4: Vertical Total   (char rows) */
	unchar  mi_veradj;	/* Reg  5: Vtotal Adjust   (scan lines) */
	unchar  mi_vsndsp;	/* Reg  6: Vertical Display (char rows) */
	unchar  mi_vsnpos;	/* Reg  7: Vsync Position   (char rows) */
	unchar  mi_intlac;	/* Reg  8: Interlace Mode               */
	unchar  mi_maxscn;	/* Reg  9: Max Scan Line   (scan lines) */
	unchar  mi_curbeg;	/* Reg 10: Cursor Start    (scan lines) */
	unchar  mi_curend;	/* Reg 11: Cursor End      (scan lines) */
	unchar  mi_stadh;	/* Reg 12: Start Address (H)            */
	unchar  mi_stadl;	/* Reg 13: Start Address (L)            */
	unchar  mi_cursh;	/* Reg 14: Cursor (H)                   */
	unchar  mi_cursl;	/* Reg 15: Cursor (L)                   */
};

struct egainit {
	unchar  ei_hortot;	/* Reg  0: Horizontal Total */
	unchar  ei_hde;		/* Reg  1: Horizontal Display End */
	unchar  ei_shb;		/* Reg  2: Start horizontal blank */
	unchar  ei_ehb;		/* Reg  3: End horizontal blank */
	unchar  ei_shr;		/* Reg  4: Start horizontal retrace */
	unchar  ei_ehr;		/* Reg  5: End horizontal retrace */
	unchar  ei_vertot;	/* Reg  6: Vertical total */
	unchar  ei_ovflow;	/* Reg  7: Overflow */
	unchar  ei_prs;		/* Reg  8: Preset row scan */
	unchar  ei_maxscn;	/* Reg  9: Max Scan Line */
	unchar  ei_curbeg;	/* Reg 10: Cursor Start */
	unchar  ei_curend;	/* Reg 11: Cursor End */
	unchar  ei_stadh;	/* Reg 12: Start Address (H) */
	unchar  ei_stadl;	/* Reg 13: Start Address (L) */
	unchar  ei_cursh;	/* Reg 14: Cursor location (H) */
	unchar  ei_cursl;	/* Reg 15: Cursor location (L) */
	unchar	ei_vrs;		/* Reg 16: Vertical retrace start */
	unchar	ei_vre;		/* Reg 17: Vertical retrace end */
	unchar	ei_vde;		/* Reg 18: Vertical display end */
	unchar	ei_offset;	/* Reg 19: Offset */
	unchar	ei_undloc;	/* Reg 20: Underline location */
	unchar	ei_svb;		/* Reg 21: Start vertical blank */
	unchar	ei_evb;		/* Reg 22: End vertical blank */
	unchar	ei_mode;	/* Reg 23: Mode control */
	unchar	ei_lcomp;	/* Reg 24: Line compare */
};

struct reginit {
	unchar		seqtab[NSEQ];
	unchar		miscreg;
	struct egainit	egatab;
	unchar		attrtab[NATTR];
	unchar		graphtab[NGRAPH];
};

struct egastate {
	unchar	es_mode;
	unchar	es_chargen[CHGEN_SIZE];
};

struct adtmode {
	unchar	am_capability;
	unchar	am_colmode;
	unchar	am_colsel;
};

/* defines for keyboard and display ioctl's */
#define KIOC		('K'<<8)
#define	KDDISPTYPE	(KIOC|1)	/* return display type to user */
#define	KDMAPDISP	(KIOC|2)	/* map display into user space */
#define	KDUNMAPDISP	(KIOC|3)	/* unmap display from user space */
#define	KDGKBENT	(KIOC|4)	/* get keyboard table entry */
#define	KDSKBENT	(KIOC|5)	/* set keyboard table entry */
#define	KDGKBMODE	(KIOC|6)	/* get keyboard translation mode */
#define	KDSKBMODE	(KIOC|7)	/* set keyboard translation mode */
#define	KDMKTONE	(KIOC|8)	/* sound tone */
#define	KDGETMODE	(KIOC|9)	/* get text/graphics mode */
#define	KDSETMODE	(KIOC|10)	/* set text/graphics mode */
#define	KDADDIO		(KIOC|11)	/* add I/O address to list */
#define	KDDELIO		(KIOC|12)	/* delete I/O address from list */
#define	KDGKBTYPE	(KIOC|64)	/* get keyboard type */
#define KDGETLED        (KIOC|65)       /* get keyboard led status */
#define KDSETLED        (KIOC|66)       /* set keyboard led status */
#if TSSBITMAP || VPIX
#define	KDENABIO	(KIOC|60)	/* enable direct I/O to ports */
#define	KDDISABIO	(KIOC|61)	/* disable direct I/O to ports */
#endif
#ifdef VPIX
#define KIOCINFO        (KIOC|62)       /* tell user what device we are */
#define KIOCSOUND       (KIOC|63)       /* start sound generation */
#endif /* VPIX */

/* keyboard types */
#define	KB_84		1		/* 84-key keyboard */
#define	KB_101		2		/* 101/102-key keyboard */
#define	KB_OTHER	3		/* other type of keyboard */

struct kbentry {
	unchar	kb_table;	/* which table to use */
	unchar	kb_index;	/* which entry in table */
	ushort	kb_value;	/* value to get/set in table */
};

#define	MKDIOADDR	64	/* max no. of I/O addresses supported */

struct kd_disparam {
	long	type;	/* display type */
	char	*addr;	/* display memory address */
	ushort	ioaddr[MKDIOADDR];	/* valid I/O addresses */
};

struct kd_memloc {
	char	*vaddr;		/* virtual address to map to */
	char	*physaddr;	/* physical address to map from */
	long	length;		/* size in bytes to map */
	long	ioflg;		/* enable I/O addresses if non-zero */
};
