#ident	"@(#)iopmem.h	1.5	2/19/88 08:38:55"

#ifndef	IOMAXPAGE

#define	IOMAXPAGE	32	/* max # of pages needed */

#define MAXALLOC	32	/* max # 1k phys. pages that can be requested */
#define	MAXIOPUSERS	32	/* max #procs with signalling active per chan */
#define	MAXIOPS		8	/* max possible # iopmem chunks of memory */

#define SIGINTR		0x20	/* Signal byte offset from 0 in each iopmem */
#define PTR_IND		0x80	/* Indicates that address is pointer rather than
					physical block 3068 special */


/***
 *** USER extracts the least significant 5 bits of the minor device number
 ***  for the application
 ***/
#define USER(dev)	(minor(dev) & 0x1F)

/*** 
 *** IOPNUM extracts the iopmem identification bits (7,6,5) from the minor
 ***  device number; these bits tell which iopmem piece of memory a device
 ***  may access.
 ***/
#define	IOPNUM(dev)	( (short) ((minor(dev) & 0xE0) >> 5) )

/*** ceioctl cmds ***/
#define	GETMEM		1		/* allocate memory for iopmem device */
#define POLLSIG 	2		/* enable poll signaling for dev */
#define INTRSIG 	3		/* enable intr signaling for dev */
#define STARTFOR	4		/* start foreign code in fep */
#define FSTAT		5		/* enquiry: STARTFOR issued? */
#define STOPFOR 	6		/* free allocated iopmem */
#define SENDSIG 	7		/* change signal number sent */
#define GETADDR 	8		/* get physical address of iopmem */


/*** error message defines ***/
#define	E_NOSIG		EBADF		/* another process already enabled
					 * signalling/signal type for this dev*/
#define E_STARTED	EBUSY		/* foreign code already started on
					 * specified channel */
#define	E_ISALLOC	EEXIST		/* iopmem already allocated */
#define	E_EFAULT	EFAULT		/* read/write data copy error */
#define E_EINVAL	EINVAL		/* invalid ioctl channel/npages parm */
#define E_FCODE		ENOEXEC		/* specified foreign code version
					 * does not match loaded sio code */
#define	E_NOALLOC	ENODEV		/* iopmem not allocated yet, ie.
					 * no such device */
#define	E_NOMEM		ENOMEM		/* requested page count of contiguous
					 * memory not available */
#define E_ENXIO		ENXIO		/* read/write count/offset out of
					 * range */

/*** structure definitions ***/
#pragma pack(2)
struct iopmem {				/* all info about an iopmem */
	short ce_fchan;			/* foreign code channel,if started */
	char ce_fversion;		/* version of foreign code allowed */
	char ce_npages;			/* #1k pages allocated, initially 0 */
	caddr_t ce_laddr;		/* logical addr # of 1st memory page */
	short ce_hotcode;		/* set if fcode executing in iopmem */
	char ce_started;		/* set if foreign code started */
	char ce_sigtype;		/* type of signalling set, 0 if none */
	short ce_pid[MAXIOPUSERS];		/* pids of procs to send signals to */
} ;
#pragma pack()
#endif
