/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)ioctl.h	1.7 88/03/19   */

/*
 *	Ioctl commands
 */
#define	IOCTYPE	0xff00


#define	TIOC	('T'<<8)
#define	TCGETA	(TIOC|1)
#define	TCSETA	(TIOC|2)
#define	TCSETAW	(TIOC|3)
#define	TCSETAF	(TIOC|4)
#define	TCSBRK	(TIOC|5)
#define	TCXONC	(TIOC|6)
#define	TCFLSH	(TIOC|7)

#define	TCDSET	(TIOC|32)
#define	TCRDCHK	(TIOC|68)	/* return number of bytes in tty raw queue,
	for compatiblity with 3068, and also used by durdchk() */

#define	LDIOC	('D'<<8)
#define	LDOPEN	(LDIOC|0)
#define	LDCLOSE	(LDIOC|1)
#define	LDCHG	(LDIOC|2)
#define	LDGETT	(LDIOC|8)
#define	LDSETT	(LDIOC|9)


#define	tIOC	('t'<<8)
#define TIOCGETD        (tIOC|0)                /* V7 */
#define TIOCSETD        (tIOC|1)                /* V7 */
#define TIOCHPCL        (tIOC|2)                /* V7 */
#define TIOCGETP        (tIOC|8)
#define TIOCSETP        (tIOC|9)
#define TIOCSETN        (tIOC|10)               /* V7 */
#define TIOCEXCL        (tIOC|13)               /* V7 */
#define TIOCNXCL        (tIOC|14)               /* V7 */
#define TIOCFLUSH       (tIOC|16)               /* V7 */
#define TIOCSETC        (tIOC|17)               /* V7 */
#define TIOCGETC        (tIOC|18)               /* V7 */
#define	TIOCBRK		(tIOC|20)		/* V7 */
#define TIOXESCO	(tIOC|21)
#define TIOXESCC	(tIOC|22)
#define SETMODEM	(tIOC|23)
#define SETFLOW		(tIOC|24)
#define GETFLOW		(tIOC|25)
#define GETMODEM	(tIOC|26)
#define PSKEY		(tIOC|27)
#define PSESC		(tIOC|28)

/* [gs]et Wang terminal flow control.  Available only on Multidrop
	async ports (not RS422). */
#define	TIOCKCMLSET		(tIOC|29)
#define	TIOCKCMLGET		(tIOC|30)

#define	LIOC	('l'<<8)
#define	LIOCGETP	(LIOC|1)
#define	LIOCSETP	(LIOC|2)
#define	LIOCGETS	(LIOC|5)
#define	LIOCSETS	(LIOC|6)

#define	DIOC	('d'<<8)
#define	DIOCGETC	(DIOC|1)
#define	DIOCGETB	(DIOC|2)
#define	DIOCSETE	(DIOC|3)
#define DIOCGETP        (DIOC|8)                /* V7 */
#define DIOCSETP        (DIOC|9)                /* V7 */

#define	VPM	('V'<<8)
#define	VPMCMD	(VPM|8)
#define	VPMERRS	(VPM|9)
#define	VPMRPT	(VPM|10)
#define	VPMTRCO	(VPM|16)

#define FIOCLEX         (('f'<<8)|1)            /* V7 */
#define FIONCLEX        (('f'<<8)|2)            /* V7 */
#define FIORDCHK        (('f'<<8)|3)            /* V7 */

/* modem ioctl's for sio and multidrop boards */
#define	MIOBGET		(('a'<<8)|0)	/* get the input bits */
#define	MIOBSET		(('a'<<8)|1)	/* set explicitly the output bits */
#define	MIOBIGET	(('b'<<8)|1)	/* get the input bits */

/* input bits */
#define	RTS	0x08		/* request to send */
#define	DTR	0x02		/* data terminal ready */

/* output bits */
#define	CTS	0x40		/* clear to send */
#define	DSR	0x80		/* data set ready */

/*
 * modem bits:  controls whether or not HUPCL and CLOCAL bits can be set
 */
#define	MDM_USER	0	/* user sets modem bits */
#define MDM_ON		1	/* forces HUPCL, ~CLOCAL */
#define MDM_OFF		2	/* forces ~HUPCL, CLOCAL */

/* for [SG]ETMODEM ioctls. (values go in t_flow). FWANG can only be
	set/interrogated via the TIOCKCML[SG]ET ioctls. */
#define TXHARD 1
#define RXHARD 0x10
#define WANGMODE 0x20	/* use special wang terminal flow control (async
	MDC ports only, not RS422).  Persists across last close. */

/* special quoting chars when WANGMODE is on */
#define WG_FKEY 0xFD	/* sent as first char of function key */
#define WG_QUOT 0xFE	/* Wang 'file transfer' quot  char */

/*
**	Union for use by all device handler ioctl routines.
*/
union ioctl_arg {
	struct termio	*stparg;	/* ptr to termio struct */
	struct Generic	*sparg;		/* ptr to generic struct */
	char		*cparg;		/* ptr to character */
	char		carg;		/* character */
	int		*iparg;		/* ptr to integer */
	int		iarg;		/* integer */
	long            *lparg;         /* ptr to long */
	long            larg;           /* long */
};
/*	Transparent printer ioctl's.  Note that as of the Xenix 3.4a
	release, the XIOCTTY ioctl takes the ENTIRE dev_t, not minor(dev_t).
*/
#define	XIOCOPEN	(('x' << 8) | 1)
#define	XIOCCLOSE	(('x' << 8) | 2)
#define XIOCTTY		(('x' << 8) | 3)
#define XIOCHUP		(('x' << 8) | 4)

/*	This structure and the IOCHOWMANY ioctl are used to create
	the appropriate entries in the /dev directory.  It is currently
	used only by the sio and multidrop drivers.  The values returned
	indicate the value to be appended to the 'standard' prefix, and
	does not indicate the actual minor device number.  By convention
	for the ttys, if first == 0, that is the driver which the kernel
	thinks is the console.  For this ioctl, the first argument is
	the major device number of a character device, NOT a file descriptor.
	Olson, 4/86.
*/
#define IOCHOWMANY (('h'<<8)|0)

struct io_howmany {
	unsigned char i_first;
	unsigned char i_last;
	unsigned char i_type;	/* device type, for future expansion */
};


/*	New ioctl for maximum number of simultaneous users logged in.
	third arg is &int, into which is placed the max number allowed.
*/
#define IOMAXLOGIN ('m' << 8)

#define	DISKIOC	('S'<<8)	/* S for Storage... */
#define DISKSPARE    (DISKIOC|1)	/* when done on a hard disk device,
	tells the fileprocessor code to re-examine the badblock map.  This is
	used for 'dynamic' bad block sparing (i.e., after the disk has
	been formatted and mkfs'ed */
#define DISKNOERRMSG (DISKIOC|2) /* don't display error message after disk
	error (currently only used on Series 500 ) */
#define DISKERRMSG   (DISKIOC|3)   /* display error message after disk error
	(currently only used on Series 500 ) */
#define DISKPARAM    (DISKIOC|4)   /* returns no. of cyls, heads, and sectors
	for the drive (currently only used on Series 500 ) */
