/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)iobuf.h	1.10 88/03/19   */

/*
 * Each IDFC controller has an iobuf, which contains private state data
 * and 2 list heads: the b_forw/b_back list, which is doubly linked
 * and has all the buffers currently associated with that major
 * device; and the b_actf/b_actl list, which is private to the
 * controller but in fact is always used for the head and tail
 * of the I/O queue for the device.
 * The 'struct buf *' and b_flags members must be at the same offsets as
 * in the buf and rbuf structs (buf.h/rbuf.h),
 * but the rest is private to each device controller.
 */

typedef struct iobuf
{
	long	   b_flags;
	struct buf *b_forw;
	struct buf *b_back;
	struct buf *b_actf;
	struct buf *b_actl;
	union b_u  b_u;
	mplock_t	   b_lock;
} iobuf_t;
#define	hd_c0		b_u.ddbuf.dd_hd_c0
#define	hd_c1		b_u.ddbuf.dd_hd_c1
#define	hd_c2		b_u.ddbuf.dd_hd_c2
#define	hd_c3		b_u.ddbuf.dd_hd_c3
#define	tp_c0		b_u.ddbuf.dd_tp_c0
#define	tp_c1		b_u.ddbuf.dd_tp_c1
#define	tp_c2		b_u.ddbuf.dd_tp_c2
#define	tp_c3		b_u.ddbuf.dd_tp_c3
#define	b_active	b_u.ddbuf.dd_b_active
#define	b_errcnt	b_u.ddbuf.dd_b_errcnt
#define	io_erec		b_u.ddbuf.dd_io_erec
#define	io_nreg		b_u.ddbuf.dd_io_nreg
#define	io_stp		b_u.ddbuf.dd_io_stp

#define tabinit(dv,stat) {0,0,0,0,0,0,0,0,0,0,0,0,0,makedev(dv,0),0,0,0,0,0,stat}
#define NDEVREG	(sizeof(struct device)/sizeof(int))

#define	B_ONCE	01	/* flag for once only driver operations */
#define	B_TIME	04	/* for timeout use */
