/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	@(#)immu.h	1.33 88/03/19 	*/

/*
 * NOTE: Page Table entries are caled pde's (page descriptors)
 *	 and Page Directory entries are called pdte's. This is
 *	 not the best naming scheme but it minimizes the changes
 *	 required to the base source.
 */

#ifndef PNUMSHFT
/*
 * Page Table (descriptor) Entry Definitions
 */

typedef union pde {    /*  page descriptor (table) entry  */
/*    	                                                */
/*  +---------------------+---+--+--+--+-+-+--+-+-+-+  */
/*  |        pfn          |lck|nr|cw|  |m|r|  |u|r|p|  */
/*  +---------------------+---+--+--+--+-+-+--+-+-+-+  */
/*             20            1  1  1  2 1 1  2 1 1 1   */
/*                                                      */
	struct {
		uint pg_pres	:  1,	/* Page is present in memory */
		     pg_rw	:  1,	/* read/write */
		     pg_us	:  1,	/* user/supervisor */
		     		:  2,	/* Reserved by hardware.	*/
		     pg_ref	:  1,	/* Page has been referenced */
		     pg_mod	:  1,	/* Page has been modified */
				:  2,	/* Reserved by hardware.	*/
		     pg_cw	:  1,	/* Copy on write (fault	*/
		     pg_ndref	:  1,	/* Needs reference (software).	*/
		     pg_lock	:  1,	/* Lock in core (software) */
		     pg_pfn	: 20;	/* Physical page frame number */
	} pgm;

	struct {
		uint	pg_pde;		/* Full page table entry */
	} pgi;
} pde_t;

#define pg_v	pg_pres		/* present bit = valid bit */

/*
 *	Page Table
 */

#define NPGPT		1024		/* Nbr of pages per page table */
typedef union ptbl {
	int page[NPGPT];
} ptbl_t;

/* Page table entry dependent constants */

#define	NBPP		4096		/* Number of bytes per page */
#define	NBPPT		4096		/* Number of bytes per page table */
#define	BPTSHFT		12 		/* LOG2(NBPPT) if exact */
#define NDPP            8               /* Number of disk blocks per page */
#define DPPSHFT         3               /* Shift for disk blocks per page. */
/* Following added because svid says ulimit works in 512 byte units, so we must
  have something independent of the blocksize of the file system implementation
 */
#define NUPP		8		/* Number ulimit blocks per page    */
#define UPPSHFT		3		/* Shift for ulimit blocks per page */

#define PNUMSHFT	12		/* Shift for page number from addr. */
#define POFFMASK        0xFFF		/* Mask for offset into page. */
#define	PTOFFMASK	0x3FF		/* Mask for offset into page table/dir*/
#define	PNDXMASK	PTOFFMASK	/* Mask for offset into kptbl.*/
#define PGFNMASK	0xFFFFF		/* Mask page frame nbr after shift. */
#define PTNUMSHFT	22		/* Shift for page table num from addr */

#define	NPTPP		1		/* Nbr of page tables per page.	*/
#define	NPTPPSHFT	0		/* Shift for NPTPP. */

/* Page descriptor (table) entry field masks */

#define PG_ADDR		0xFFFFF000	/* physical page address */
#define PG_LOCK		0x00000800	/* page lock bit (software) */
#define PG_NDREF	0x00000400	/* need reference bit (software) */
#define PG_COPYW	0x00000200	/* copy on write bit */
#define PG_M		0x00000040	/* modify bit */
#define PG_REF		0x00000020	/* reference bit */
#define	PG_US		0x00000004	/* 0=supervisor, 1=user */
#define	PG_RW		0x00000002	/* 0=read-only, 1=read/write */
#define PG_P		0x00000001	/* page present bit */
#define PTE_RW		(PG_RW|PG_US)

#define PTSIZE		4096		/* page table size in bytes */
#define PTSZSHFT	12		/* page table size shift count */


/* byte addr to virtual page within page table */
#define pnum(X)   (((uint)(X) >> PNUMSHFT) & PTOFFMASK) 

/* page offset */

#define poff(X)   ((uint)(X) & POFFMASK)

/* page table num (page dir entry) */

#define ptnum(X)	((uint)(X) >> PTNUMSHFT)

#define pgndx(X)	(((X) >> PNUMSHFT) & PNDXMASK)

/* Round up page table address */

#define ptround(p)	((int *) (((int)p + PTSIZE-1) & ~(PTSIZE-1)))

/* Round down page table address */

#define ptalign(p)	((int *) ((int)p & ~(PTSIZE-1)))

/* Following added because svid says ulimit works in 512 byte units, so we must
  have something independent of the blocksize of the file system implementation

	Ulimit blocks (512 bytes each) and pages.
 */

#define utop(UU)	(((UU) + NUPP -1) >> UPPSHFT)

/*	Disk blocks (sectors) and pages.
*/

#define	ptod(PP)	((PP) << DPPSHFT)
#define	dtop(DD)	(((DD) + NDPP - 1) >> DPPSHFT)
#define dtopt(DD)	((DD) >> DPPSHFT)

/*	Disk blocks (sectors) and bytes.
*/

#define	dtob(DD)	((DD) << SCTRSHFT)
#define	btod(BB)	(((BB) + NBPSCTR - 1) >> SCTRSHFT)
#define	btodt(BB)	((BB) >> SCTRSHFT)

/*	Page tables to pages.
*/

#define	pttopgs(X)	((X + NPTPP - 1) >> NPTPPSHFT)
#define	pttob(X)	((X) << BPTSHFT)
#define	btopt(X)	(((X) + NBPPT - 1) >> BPTSHFT)

union ptbl *getptbl();		/* page table allocator */

extern int		nptalloced;
extern int		nptfree;

/* Form page descriptor (table) entry from modes and page frame
** number
*/

#define	mkpde(mode,pfn)	(mode | ((pfn) << PNUMSHFT))

/*	The following macros are used to check the value
 *	of the bits in a page descriptor (table) entry 
 */

#define pg_isvalid(pde) 	((pde)->pgm.pg_pres)
#define pg_islocked(pde)	((pde)->pgm.pg_lock)

/*	The following macros are used to set the value
 *	of the bits in a page table entry 
 *
 *	Atomic instruction is available to clear the present bit,
 *	other bits are set or cleared in a word operation.
 */

#define pg_setvalid(P)	((P)->pgi.pg_pde |= PG_P) /* Set valid bit.	*/
#define pg_clrvalid(P)	((P)->pgi.pg_pde &= ~PG_P) /* Clear valid bit.	*/

#define pg_setndref(P)	((P)->pgi.pg_pde |= PG_NDREF)
						/* Set need ref bit.	*/
#define pg_clrndref(P)	((P)->pgi.pg_pde &= ~PG_NDREF)
						/* Clr need ref bit.	*/

#define pg_setlock(P)	((P)->pgi.pg_pde |= PG_LOCK)	
						/* Set lock bit.	*/
#define pg_clrlock(P)	((P)->pgi.pg_pde &= ~PG_LOCK) /* Clear lock bit.	*/

#define pg_setmod(P)	((P)->pgi.pg_pde |= PG_M)	
						/* Set modify bit.	*/
#define pg_clrmod(P)	((P)->pgi.pg_pde &= ~PG_M)	
						/* Clear modify bit.	*/

#define pg_setcw(P)	((P)->pgi.pg_pde |= PG_COPYW), \
			((P)->pgi.pg_pde &= ~PG_RW)
						/* Set copy on write
						 * and clear r/w
						 */

#define pg_clrcw(P)	((P)->pgi.pg_pde &= ~PG_COPYW) /* Clr copy on write.*/

#define pg_setref(P)	((P)->pgi.pg_pde |= PG_REF) 	/* Set ref bit.	*/
#define pg_clrref(P)	((P)->pgi.pg_pde &= ~PG_REF) /* Clear ref bit.	*/

#define pg_setprot(P,b)	((P)->pgi.pg_pde |= b)	/* Set r/w access */

#define	SOFFMASK	0x3FFFFF	/* Mask for page table alignment */
#define	SGENDMASK	0x3FFFFF	/* mask for checking that downward
	growing regions have p_regva in last slot of a page table.
	Should work correctly for any fault address in these regions.
	Since 386 supports stack aligned on arbitrary boundaries, need
	an F in last nibble for byte-align, E for word-align (like all
	current 386 x.out binaries), C for dword align. */

/*  access modes  */

#define KNONE  (unsigned char)  0x00
#define KEO    (unsigned char)  0x40	/* KRO on WE32000	*/
#define KRE    (unsigned char)  0x80
#define KRWE   (unsigned char)  0xC0	/* KRW on WE32000	*/

#define UNONE  (unsigned char)  0x00
#define UEO    (unsigned char)  0x01	/* URO on WE32000	*/
#define URE    (unsigned char)  0x02
#define URWE   (unsigned char)  0x03	/* URW on WE32000	*/

#define UACCESS (unsigned char) 0x03
#define KACCESS (unsigned char) 0xC0

#define SEG_RO	(KRWE|URE)
#define SEG_RW	(KRWE|URWE)

/*	The following variables describe the memory managed by
**	the kernel.  This includes all memory above the kernel
**	itself.
*/

extern int	kpbase, kpbase_click;		/* The address of the start of	*/
				/* the first physical page of	*/
				/* memory above the kernel.	*/
				/* Physical memory from here to	*/
				/* the end of physical memory	*/
				/* is represented in the pfdat.	*/
				/* kpbase_click == ctob(kpbase) */
extern int	syssegs[];	/* Start of the system segment	*/
				/* from which kernel space is	*/
				/* allocated.  The actual value	*/
				/* is defined in the vuifile.	*/
extern int	win_ublk[];	/* A window into which a	*/
				/* u-block can be mapped.	*/
extern pde_t	*kptbl;		/* Kernel page table.  Used to	*/
				/* map sysseg.			*/

extern int	maxmem;		/* Maximum available free	*/
				/* memory.			*/

extern int	freemem;	/* Current free memory.		*/

extern int	availrmem;	/* Available resident (not	*/
				/* swapable) memory in pages.	*/
				/* Should always equal          */
				/* maxmem -			*/
				/* "committed unswappable space"*/
				/* These are the sptalloc()ed	*/
				/* pages.			*/

extern int	availsmem;	/* Available swapable memory in	*/
				/* pages.			*/
				/* Should always be equal to    */
				/*maxmem+nswap-"committed space"*/
				/* (The UAREA of a process,	*/
				/*  sptalloc()ed pages,		*/
				/*  the data pages of a region,	*/
				/*  plus the DBD & page tables	*/
				/*  should all be counted as	*/
				/*  committed space!)		*/

/*	Conversion macros
*/

/*	Get page number from system virtual address.  */

#define svtop(vaddr)    (((vaddr) - KVBASE) >> PNUMSHFT)

/*	Get system virtual address from page number.  */

#define ptosv(paddr)    (((paddr) << PNUMSHFT) + KVBASE)


/*	These macros are used to map between kernel virtual
**      and physical address.
*/

#define kvtophys(vaddr) (svirtophys(vaddr))
#define phystokv(paddr) ((unsigned)(paddr)+(unsigned)KVBASE)

/*	Between kernel virtual address and physical page frame number.
*/

#define kvtopfn(vaddr) (kvtophys(vaddr) >> PNUMSHFT)
#define pfntokv(pfn)   (phystokv ((pfn) << PNUMSHFT))

/*	Between kernel virtual addresses and the kernel page
**	table.
*/

#define	kvtokptbl(X)	(&kptbl[pgndx((uint)(X) - (uint)syssegs)])

/*	The following routines are involved with the pfdat
**	table described in pfdat.h
*/

#define	kvtopfdat(kv)	(&pfdat[kvtopfn(kv) - kpbase_click])
#define	pfntopfdat(pfn)	(&pfdat[pfn - kpbase_click])
#define	pfdattopfn(pfd)	(pfd - pfdat + kpbase_click)

/*
 * pde_t *
 * vatopdte(v)
 * returns the page directory entry location of v.
 */

#define	vatopdte(v)	((pde_t *)phystokv(_cr3()) + ptnum(v))

/*
 * pde_t *
 * vatopde(v, pdte)
 * returns the page table entry location of v.
 */

#define	vatopde(v, pdte) ((pde_t *)phystokv(ctob(pdte->pgm.pg_pfn)) + pnum(v))

/*
 * pde_t *
 * svtopde(v)
 * returns the pt entry location of v.
 *
 * This macro works only with paged virtual address.
 *
 */

#define svtopde(v) ((pde_t *)phystokv(ctob((uint)(vatopdte(v)->pgm.pg_pfn))) + pnum(v))

/* system virtual to physical page frame number */
#define svtopfn(v) (svirtophys(v)>>PNUMSHFT)

/*	Page frame number to kernel pde.  */
#define	pfntokptbl(P)	(kvtokptbl(pfntokv(P)))

/* flags used in ptmemall() call */
#define PHYSCONTIG 02
#define NOSLEEP    01

/* Kernel space addresses (virtual==linear) (must be aligned on 4M for 386) */
#define KVBASE	 (unsigned)0xC0000000L	/* base address of the kernel	*/
#define UVUBLK	 (unsigned)0xFF800000L	/* ublock virtual address       */
#define UVBASE	 (unsigned)0x00000000L	/* base address of user space	*/
/* this is where the uarea for another process is mapped by
	uaccess().  Can't use &u[1] because
	sizeof(struct user) != ctob(USIZE)
*/
#define P_MAPPED_UAREA ((char *)&u + ctob(USIZE))

#define MINKVADR KVBASE		/* minimum kernel virtual address.  */
#define MAXKVADR UVUBLK		/* maximum kernel virtual address that is NOT
				   shared among processes.  */

/* User space addresses (NOTE: these are user's idea of the addresses!) */
#define UVTEXT	 0x00000000L	/* Text beginning in user space	4M aligned */
#define UVSTACK	 (unsigned)0x7FFFFFFFL	/* stack bottom in user space, ONLY for
	startup, use 'u.u_slb' after that! */
#define UVSHM	 (unsigned)0x80000000L	/* Shared memory in user space	4M aligned */
#define SHLIB_BASE (unsigned)0x80000000	/* offset in users data segment for
	start of shared library.  May change later.  (If nothing else,
	we have to include the HIGHEST data address the shared library(s)
	use for this program.  If more than one, we are going to have to
	ensure that the text pages are NOT writable.
	Olson */

#define MINUVADR UVTEXT			/* minimum user virtual address.    */
#define MAXUVADR (KVBASE-UVBASE-1)	/* maximum user virtual address.    */

/* true if address is in kernel virtual address space that is NOT
	shared between processes (i.e., does NOT include uarea) */
#define KADDR(v)        ((v) >= KVBASE && (v) < (ulong)MAXKVADR)

#define	SEL_RPL		0x03

# if SYS_TYPE == SYS_386E
/*	LIOBASE defines where memory mapped I/O is located
	on the 386E.
*/
#define	LIOBASE		(0x04000000+KVBASE)

	/* local status ports */
#define LIO_PORT_A	(*(uchar_t *)(LIOBASE+0x400))
#define LIO_PORT_0	(*(uchar_t *)(LIOBASE+0x400))
#define LIO_PORT_1	(*(uchar_t *)(LIOBASE+0x600))

	/* local control ports */
#define LIO_ENB_CACHE	(*(uchar_t *)(LIOBASE+0x800))
#define LIO_CACHE_MISS	(*(uchar_t *)(LIOBASE+0x802))
#define LIO_CTRLPORT	(*(uchar_t *)(LIOBASE+0x804))
#define LIO_ENB_NMI	(*(uchar_t *)(LIOBASE+0x804))
#define LIO_PARITY	(*(uchar_t *)(LIOBASE+0x808))
#define LIO_OFF_UPS	(*(uchar_t *)(LIOBASE+0x80A))
#define LIO_RST_DBG	(*(uchar_t *)(LIOBASE+0x80C))
#define LIO_UPS_LED	(*(uchar_t *)(LIOBASE+0x80E))
#define LIO_CLR_NMI	(*(uchar_t *)(LIOBASE+0xC00))

#define TAG_RAM	(LIOBASE + NBPP)	/* the tag ram */
#define TAG_RAMSIZE	(2 * NBPP)	/* size of the tag ram */

#define SIOBASE (TAG_RAM + TAG_RAMSIZE) /* system I/O space */

	/* generate a board attention. */
/*
 *  THE CHECK FOR newboard CAN BE REMOVED WHEN ALL CPU BOARDS
 *  HAVE BEEN RE-WORKED.  SEE sysio_chk() IN os/startup.c FOR DETAILS.
 *
 *  For the 386E the attention offset does not correspond to the board #.
 *  The conversion table follows:
 *  	to interrupt the IOC	board = 0x01
 *  	to interrupt ACPA #1	board = 0x10
 *  	to interrupt ACPA #2	board = 0x20
 *
 *  ACPA-E only works on 'new' mother-boards,
 *  .: no other board attentions are supported for the old mother-boards...kks
 */
#define int_ioproc(board) \
	{ extern int newboard; \
	  if (newboard) \
		*(char *)(SIOBASE+0x4000+(board)) = 0; \
	  else \
		outb(0x4001,0); \
	}

/* limits for the kernel's data and stack segments */
#define KDATALIM	((unsigned)UVUBLK/NBPP + 2*USIZE-1)
#define STACKLIM	((unsigned)UVUBLK/NBPP -1)

#endif /* 386E */
#if SYS_TYPE == SYS_CINDY
#define SIOBASE		(0x04000000+KVBASE)
#define	LIOBASE		(SIOBASE+0x10000)

/*	LMEMBASE defines where local memory is located. used for kernel
	stack, etc. to reduce writes to system bus.
*/
#define LMEMBASE	(SIOBASE+0x20000)

#define CIO_PORT_C	(*(uchar_t *)(LIOBASE+0x400))
#define CIO_PORT_B	(*(uchar_t *)(LIOBASE+0x402))
#define CIO_PORT_A	(*(uchar_t *)(LIOBASE+0x404))
#define CIO_CTRLPORT	(*(uchar_t *)(LIOBASE+0x406))

/* generate a board attention.  commboards are 1-5, fp is 0xE */
#define int_ioproc(board) *(char *)(SIOBASE+(board)) = 0

/* limits for the kernel's data and stack segments */
#define KDATALIM	((unsigned)UVUBLK/NBPP + 2*USIZE-1)
#define STACKLIM	((unsigned)LMEMBASE/NBPP -1)

/* MULTIPROCESSOR RULES

1) Avail[sr]mem are tested and changed only when memlocked() is true.
2) Avail[rs]mem should always be decremented BEFORE space is committed,
   and incremented AFTER space is decommitted.

*/
# endif /* CINDY */

#if SYS_TYPE == SYS_500

#define int_ioproc(board) { *(char *)((board)) = 0; outb(0x308,0); }

/* limits for the kernel's data and stack segments */
#define KDATALIM	((unsigned)UVUBLK/NBPP + 2*USIZE-1)
#define STACKLIM	((unsigned)UVUBLK/NBPP -1)

#endif /* 500 */


#endif
