/*
 *	@(#)i8259.h	1.3 88/03/19 
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE WHICH IS SPECIFIC TO THE
 * INTEL 286/310 COMPUTER AND MAY REQUIRE MODIFICATION
 * WHEN ADAPTING XENIX TO NEW HARDWARE.
 */

#if SYS_TYPE == SYS_500
#define NUM_8259	2
#else
#define NUM_8259	1
#endif
#define MAX8259		9
#define MAXLEV		8
	

/*
 * PIC  Initialization Constants 
 */
#define	PIC_SINGLE	0x02		/* no cAscade mode */
#define	PIC_NEED_ICW4	0x01		/* ICW4 needed */
#define	PIC_LEVEL_MODE	0x08		/* set PIC in level mode */
#define	PIC_ICW1	0x10		/* base for ICW1 */
#define	PIC_VECT_BASE	0x40		/* start vectors at 64 */
#define	PIC_SPF_MODE	0x10		/* special fully nested mode */
#define	PIC_SLAVE_BUF	0x08		/* buffered mode, slave */
#define	PIC_MASTER_BUF	0x0C		/* buffered mode, master */
#define	PIC_AUTO_EOI	0x02		/* set to auto eoi */
#define	PIC_86_MODE	0x01		/* MCS 86 mode */

/*
 * PIC commands
 */
#define	PIC_EOI		0x20		/* Non-specific EOI command */
/*#define PIC_SEOI	0x30		/* specific EOI command */
/* why is SCO's SEOI different ? */
#define PIC_SEOI	0x60		/* specific EOI command */
#define PIC_SET_PRI	0xC0		/* set priority */
#define	PIC_ISR_READ	0x0B		/* Select ISR for input */
#define	PIC_IMR_READ	0x0A		/* Select IMR for input */

/*
 * Generate masks to turn on/off a given level.
 * PIC_MASK: bit(i) = 1 ==> masked; 0 ==> enabled.
 */

#define	PIC_MON(i)	(0xFF & ~(1<<(i)))
#define	PIC_MOFF(i)	(1<<(i))

/*
 * define master & slave levels
 * encoding for master levels
 *	lev = master#
 * encoding for slave levels
 *	lev = (master# + 1) * 8 + slave#
 *
 * or,
 *	   7   6   5   4   3   2   1   0
 *	-----------------------------------
 *	|      pic index     | active lev |
 *	-----------------------------------
 */
#define PIC_ML0	0
#define PIC_ML1	1
#define PIC_ML2	2
#define PIC_ML3	3
#define PIC_ML4	4
#define PIC_ML5	5
#define PIC_ML6	6
#define PIC_ML7	7
#define PIC_MCL0	8
#define PIC_MCL1	16
#define PIC_MCL2	24
#define PIC_MCL3	32
#define PIC_MCL4	40
#define PIC_MCL5	48
#define PIC_MCL6	56
#define PIC_MCL7	64
#define PIC_SL0	0
#define PIC_SL1	1
#define PIC_SL2	2
#define PIC_SL3	3
#define PIC_SL4	4
#define PIC_SL5	5
#define PIC_SL6	6
#define PIC_SL7	7

/*
 * macro for building interrupt entry points
 */
#define	MAKEINTR(lev)	PUSHIB(lev) ##NL jmp	_int_call
