/*
 *	@(#)i8042.h	1.1 88/03/19 
 *
 *	definitions for 8042 keyboard controller
 *	on the Series 500 and PC/ATs.
 */

/*
 * keyboard controller I/O port addresses
 */
#define KB_OUT	0x60		/* output buffer R/O */
#define KB_IDAT 0x60		/* input buffer data write W/O */
#define KB_STAT 0x64		/* keyboard controller status R/O */
#define KB_ICMD 0x64		/* input buffer command write W/O */

/*
 * keyboard controller commands and flags
 */
#define KB_INBF		0x02	/* input buffer full flag */
#define KB_OUTBF	0x01	/* output buffer full flag */
#define KB_GATE20	0x02	/* set this bit to allow addresses > 1Mb */
#define KB_ROP		0xD0	/* read output port command */
#define KB_WOP		0xD1	/* write output port command */
#define	KB_RCB		0x20	/* read command byte command */
#define	KB_WCB		0x60	/* write command byte command */
#define	KB_ENAB		0xae	/* enable keyboard interface */
#define	KB_INHIB	0x10	/* keyboard inhibited */
#define	KB_DISAB	0x10	/* disable keyboard */
#define	KB_EOBFI	0x01	/* enable interrupt on output buffer full */
#define	KB_INOV		0x08	/* override keyboard inhibit function */
#define KB_ACK		0xFA	/* Acknowledgement byte from keyboard */
#define	KB_RESETCPU	0xFE	/* command to reset AT386 cpu */

/* definitions for ringing the bell */
#define NORMBELL	1331	/* initial value loaded into timer */
#define BELLLEN		(HZ/10)	/* ring for 1/10 sec. between checks */
#define BELLCNT		2	/* check bell twice before turning off */
#define TONE_ON		3	/* 8254 gate 2 and speaker and-gate enabled */
#define TIMER		0x40	/* 8254.2 timer address */
#define TIMERCR		TIMER+3	/* timer control register address */
#define TIMER2		TIMER+2	/* timer tone generation port */
#define T_CTLWORD	0xB6	/* value for timer control word */
#define TONE_CTL	0x61	/* address for enabling timer port 2 */
