/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  NOTE: this file is shared accross Motorola and Intel product
	lines.  Any machine specific code is in the appropriate ifdefs
*/

#ident	"@(#)FROM: kern-port:sys/hetero.h	10.3"
#ident	"@(#)hetero.h	1.7	2/19/88 08:38:27"

/*
 *	Define machine attributes for heterogeneity.
 *
 *	Machine attribute consists of three components -
 *	byte ordering, alignment, and data unit size.
 *	The machine attributes are defined in a byte (8 bits),
 *	the lower 2 bits are used to define the byte ordering,
 *	the middle 3 bits are used to define the alignment,
 *	the higher 3 bits are used to define the data unit size.
 *
 *
 *	BYTE_ORDER	0x01	3B, IBM byte ordering
 *			0x02	VAX byte ordering
 *	ALIGNMENT	0x04	word aligned (4 bytes boundary)
 *			0x08	half-word aligned (2 bytes boundary)
 *			0x0c	byte aligned
 *	UNIT_SIZE	0x20	4 bytes integer, 2 bytes short, 4 bytes pointer
 *			0x40	2 bytes integer, 2 bytes short, 2 bytes pointer
 */


/*
 *	Define masks for machine attributes
 */

#define BYTE_MASK	0x03
#define ALIGN_MASK	0x1c
#define UNIT_MASK	0xe0


/*
 *	Define what need to be converted - header or data parts
 */

#define ALL_CONV	0	/* convert both header and data parts */
#define DATA_CONV	1	/* convert data part */
#define NO_CONV		2	/* no conversion needed */



/*
 *	Define machine attributes for:
 */
#ifdef u3b2 /* Original 3b2 */
#define BYTE_ORDER	0x01
#define ALIGNMENT	0x04
#define UNIT_SIZE	0x20
#endif

/* Altos 68020 systems */
#ifdef m68k
#define BYTE_ORDER	0x01
#define ALIGNMENT	0x08
#define UNIT_SIZE	0x20
#endif

/* Altos i80286 systems */
#ifdef i286
#define BYTE_ORDER	0x02
#define ALIGNMENT	0x08
#define UNIT_SIZE	0x40
#endif

/* Altos i80386 systems */
#ifdef i386
#define BYTE_ORDER	0x02
#define ALIGNMENT	0x04
#define UNIT_SIZE	0x20
#endif
/*
 *	End of machine attributes
 */

#define MACHTYPE	(BYTE_ORDER | ALIGNMENT | UNIT_SIZE)

/* alignment macros,  used by canon.c and rfcanon.c */

/*	CANALIGN must be the same for ALL machines.  Original code
	used LALIGN, but that won't work for systems like the
	Altos 68020 that place longwords in structs on an
	even (not necessarily longword) boundary.  Olson, 1/88
*/
# define	CANALIGN(p)		(char *)(((int)p+3) & ~3)

#ifdef	pdp11
# define	SALIGN(p)		(char *)(((int)p+1) & ~1)
# define	IALIGN(p)		SALIGN(p)
	/* this looks wrong: +1, but ~3 ? */
# define	LALIGN(p)		(char *)(((int)p+1) & ~3)
#else
# if defined(vax) || defined(u3b2) || defined(i386)
#  define	SALIGN(p)		(char *)(((int)p+1) & ~1)
#  define	IALIGN(p)		(char *)(((int)p+3) & ~3)
#  define	LALIGN(p)		IALIGN(p)
# else
#  ifdef	m68k
#   define	SALIGN(p)		(char *)(((int)p+1) & ~1)
#   define	IALIGN(p)		SALIGN(p)
#   define	LALIGN(p)		SALIGN(p)
#  else
this ; is a bad " very bad error
#  endif
# endif
#endif


#define SNEXT(p)		(char *)((int)p + sizeof (short))
#define INEXT(p)		(char *)((int)p + sizeof (int))
#define LNEXT(p)		(char *)((int)p + sizeof (long))

