/* 
 *	@(#) flp.h 1.3 88/03/19 
 */
# define	uchar	unsigned char
# define	uint	unsigned int
# define	ulong	unsigned long

# define	NDEVS	5
# define	NFDDEVS	8	/* number of supported floppy minor devices */

# define	DEV_HD  0	/* hard disk */
# define	DEV_FD  1	/* floppy disk */
# define	DEV_TP  2	/* tape */
# define 	DEV_PP  3	/* parallel printer */
# define	DEV_SC  4	/* SCSI */

# define	NREQS	32
# define	INCPTR(x)	((x) = ((x)+1)%NREQS)

# define	QEMPTY(h, t)	((h) == (t))


/* floppy control block; ie. req queue
 */
extern struct iobuf fdtab;

struct physbuf {
	paddr_t	xaddr[MAXBLK];
	unsigned short	xcntb[MAXBLK];
};

#ifdef FDPRINT	
#define	PR_START 0xd6d1
#define	PR_END	0xd6d9
#define	PRWSIZE	100
#endif
#define	SECTSZ	512


/*
** File Processor Commands
*/

# define	C_DISIN		1
# define	C_INTEN		2
# define	C_RESIN		3
# define	C_RELOC		4
# define	C_RESTART	5

/*
** File Processor Status
*/

# define	S_INTEN		0x01
# define	S_INTPEN	0x02


/*
** Operating Systems Type
*/

# define	OS_NONE		0
# define	OS_XENIX	1
# define	OS_UNIX		2
# define	OS_PICK		3
# define	OS_MPM		4
# define	OS_CDOS		5
# define	OS_DIAG		6

# define	OS_386		0x40
# define	OS_68K		0x80

/*
** Sector Lengths
*/
# define	SL_512		0x00
# define	SL_1024		0x01
# define	SL_2048		0x02
# define	SL_4096		0x03
# define	SL_WAKEUP	0x80	/* internal use only */

/*
** Flags which can be or'ed into the same byte as the sector lengths
*/
# define	F_DOBAD		0x80	/* Doing bad sector */

/*
** Request Commands
*/
# define	RC_OPEN		1
# define	RC_CLOSE	2
# define	RC_READ		3
# define	RC_WRITE	4
# define	RC_FORMAT	5
# define	RC_IOCTL	6
# define	RC_REWIND	7
# define	RC_RETEN	8	/* retension (tape only) */
# define	RC_ERASE	9       /* erase (tape only) */
# define	RC_TPSTAT	10      /* read status (tape only) */
# define	RC_SEEKFM	11	/* seek file mark (tape only) */
# define	RC_WRTFM	12	/* write file mark (tape only) */
# define	RC_CLRNMI	14	/* clear FP NMI flag */
# define	RC_SHUT		0x10	/* dump ram command */
# define	RC_RDMAP	0x0d	/* re-read bad-sector map */
# define	RC_MASK		0x1F	/*  effective command field */
# define	RC_DISINT	0x80	/* disable interrupt */
# define	RC_DISRETRY	0x40	/* disable retry */
# define	RC_CHAINIO	0x20	/* swap scattered data pages */


/*
** Request Errors
*/
# define	HE_DATAMARK	0x01	/* data mark not found */
# define	HE_TZERR	0x02	/* track zero error (recal failed) */
# define	HE_ABORT	0x04	/* drive not ready */
# define	HE_PFAIL	0x09	/* power fail error nmi */
# define	HE_IDNOTFND	0x10	/* ID not found */
# define	HE_NOTREADY	0x20	/* drive not ready */
# define	HE_CRC		0x40	/* CRC error */
# define	HE_BADBLOCK	0x80	/* Unmapped bad sector */

# define	SE_INVCMD	1	/* Invalid command */
# define	SE_DEVNPRES	2	/* Device not present */
# define	SE_NOTIMP	3	/* Device not implemented */
# define	SE_EOM		4	/* End of Media on tape */
# define	SE_NOTREADY	5	/* Device not Ready */
# define	SE_CORRECT	6	/* data was corrected (non fatal) */
# define	SE_RANGE	7	/* block number or drive out of range */
# define	SE_INUSE	8	/* device is in use, cmd is invalid */
# define	SE_ISOPEN	9	/* device is open, cmd is invalid */
# define	SE_ISCLOSE	10	/* device is closed, cmd is invalid */
# define	SE_LOGSIZ	11	/* logical incompatible with physical */
# define	SE_NOCONFIG	12	/* no configuration info on drive */
# define	SE_NOLAYOUT	13	/* no layout info on drive */
# define	SE_ISODD	14	/* hard disk xfer to odd address */
# define	SE_WPROTECT	15	/* tape is write protected */
# define	SE_EOF		16	/* End of File on tape */
# define	SE_PAPEROUT	17	/* paper out */
# define	SE_TIMEOUT	18	/* printer busy too long */
# define	SE_FAULT	19	/* printer fault */
# define	SE_NOPRINTER	20	/* printer is not connected */
# define	SE_NOCT		21	/* tape is not inserted */
# define	SE_TOOLONG	22	/* tape was active too long */
# define	SE_TAPERR	23	/* tape status = error */
# define	SE_BIE		24	/* tape status = BIE (block in error) */
# define	SE_NODATA	25	/* tape status = no data */

/*
 *	Floppy disk control parameters
 */
#define MAX_FSECS	32
#define MAX_FCYLS	80
#define MAX_FHEADS	2

struct fdparams {
	short fd_coding;		/* 0 = FM, 1 = MFM */
	short fd_speed;			/* 0 = lo speed, 1 = hi speed */
	short fd_cyldensity;		/* 0 = 48, 1 = 96 */
	short fd_sectors;		/* sectors per track */
	short fd_bytes;			/* 0..3 = 128, 256, 512, 1024 */
	short fd_cylinders;		/* cylinders per diskette */
	short fd_heads;			/* heads per drive */
	short fd_blocks;		/* physical sectors on disk */
	short fd_f_cylinder;		/* (heads * sectors) */
	short fd_gap1;			/* */
	short fd_gap2;			/* */
	short fd_recal;			/* set if recal required */
};

#define BPS128		0	/* 128 bytes per sector */
#define BPS256		1	/* 256 bytes per sector */
#define BPS512		2	/* 512 bytes per sector */
#define BPS1024		3	/* 1024 bytes per sector */

#define CPI48		0	/* 48 cylinders per inch */
#define CPI96		1	/* 96 cylinders per inch */


struct interlace {
	short il_cyl;			/* status .. updated if error */
	short il_head;			/* status .. updated if error */
	short il_sec[MAX_FSECS];
};

struct fdbuf {
	unsigned char cylno;
	unsigned char headno;
	unsigned char secno;
	unsigned char secsize;
};


/* ioctl assignments */
#define FDPGET		1
#define FDPPUT		2
#define FDFORMAT	3
