/*
 *	@(#)fl.h	1.1 88/03/19 
 *
 *	Copyright (C) The Santa Cruz Operation, 1985, 1986.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 *
 */

/*
 *	Floppy driver definitions.
 *
 *	***** ONYX 186 STARTING POINT *****
 */

#define FL_ERROR	-1

	/* Floppy Disk Controller port addresses */
#define P_FLCTL		0x03f2		/* FDC control register (write) M003 */
#define	P_FLMSR		0x03F4		/* FDC main status  register    M003*/
#define	P_FLDCR		0x03F5		/* FDC data control register */

#if SYS_TYPE == SYS_500
#define	P_FLDCT		0x03F7		/* FDC control register (write) */
#endif

#ifdef Q_PLUS
#define	P_FLDCT		0x0065		/* FDC control register (write) */
#endif

#define	P_FLDMA		0x0112		/* dma data port */
#define	P_FLTC		0x0140		/* dma terminal count port */

/*   from ibm fl.h   M003  */
#define FDC_ENB		0x04		/* high(FDC enable) low(reset)  M003 */
#define FL_ENB_DI	0x08		/* enable floppy dma & interrupts M003*/


	/* MSR bits for Floppy */
#define DA_BUSY		0x01	/* Drive A seeking */
#define DB_BUSY		0x02	/* Drive B seeking */
#define DC_BUSY		0x04	/* Drive C seeking */
#define DD_BUSY		0x08	/* Drive D seeking */
#define CB		0x10	/* FDC busy */
#define NON_DMA		0x20	/* Non DMA mode */
#define DIO		0x40	/* Data I/O: low(write) high(read) */
#define RQM		0x80	/* Request for Master - polled before
				   writing control bytes */
#define DRV_RDY		0x20	/* Drive Ready bit of status byte 3 */
#define WR_PROT		0x40	/* Write Protected bit of status byte 3 */

	/* Floppy command codes */
#define RD_TRK		(0x02)	/* Read A Track (Floppy) */
#define SPECIFY		(0x03)	/* Specify */
#define SENS_DR		(0x04)	/* Sense Drive Status */
#define WR_DATA		(0x05)	/* Write Data */
#define RD_DATA		(0x06)	/* Read Data */
#define RECAL		(0x07)	/* Recalibrate */
#define SENS_INTR	(0x08)	/* Sense Interrupt Status */
#define WR_DEL_DATA	(0x09)	/* Write Deleted Data */
#define RD_ID		(0x0A)	/* Read ID */
#define RD_DEL_DATA	(0x0C)	/* Read Deleted Data */
#define FORMAT		(0x0D)	/* Format */
#define SEEK		(0x0F)	/* Seek */

#define MT		0x80   		/* multi-track */
#define MF		0x40   		/* FM mode=0,MFM=1(dbl density)*/
#define SK		0x20   		/* skip deleted data mark */

/* Table for Number of Control Writes and Status Reads */

#define NCMDS	16	/* Number of commands */
#define MAX_WR	9	/* Maximum number of control writes */
#define MAX_RD	7	/* Maximum number of control reads */

/* Next defines are indexes into cmd array elements below */
#define NUM_WR	0	/* Number of control writes element */
#define NUM_RD	1	/* Number of status reads element */
#define EXEC    2	/* If cmd has execution phase with resulting intr */ 

/* Floppy Table */

int fl_cmd[NCMDS][3] = {

/* Code			Write	Read	Execute	*/
/************************************************/
/* Invalid  	*/     {0,	0,	0},
/* Invalid  	*/     {0,	0,	0},
/* RD_TRK	*/     {9,	7,	1},
/* SPECIFY	*/     {3,	0,	0},
/* SENS_DR	*/     {2,	1,	0},
/* WR_DATA	*/     {9,	7,	1},
/* RD_DATA	*/     {9,	7,	1},
/* RECAL	*/     {2,	0,	1},
/* SENS_INTR	*/     {1,	2,	0},
/* WR_DEL_DATA	*/     {9,	7,	1},
/* RD_ID	*/     {2,	7,	1},
/* Invalid  	*/     {0,	0,	0},
/* RD_DEL_DATA	*/     {9,	7,	1},
/* FORMAT	*/     {6,	7,	1},
/* Invalid  	*/     {0,	0,	0},
/* SEEK		*/     {3,	0,	1}

};

