/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)file.h	1.15 88/03/19   */
/*
 * One file structure is allocated for each open/creat/pipe call.
 * Main use is to hold the read/write pointer associated with
 * each open file.
 */

typedef struct file
{
	char	f_flag;
	char	f_WNmap;	/* WORKNET:  what fd is remotely mapped to */
	cnt_t	f_count;		/* reference count */
	union {
		struct inode *f_uinode;	/* pointer to inode structure */
		struct file  *f_unext;	/* pointer to next entry in freelist */
	} f_up;
	union {
		off_t	f_off;		/* read/write character pointer */
		struct file *f_slnk;    /* next waiter for xenix semaphore */
	} f_un;
} file_t;

#define f_inode		f_up.f_uinode
#define f_next		f_up.f_unext
#define	f_offset	f_un.f_off


extern struct file *file;	/* The file table itself (alloc in startup.c) */
extern struct file *ffreelist;	/* Head of freelist pool */

/* flags */
#define	FOPEN	0xffffffff
#define	FREAD	0x01
#define	FWRITE	0x02
#define	FNDELAY	0x04
#define	FAPPEND	0x08
#define FSYNC	0x10
#ifdef INKERNEL
#define OFSYNC	0x40	/* for 286 and altos 5.2 386 binaries */
#endif
#define FRCACH  0x20	/* Used for file and record locking cache */
#define FNOSEEK	0x40	/* no implied seeks WORKNET */
#define FNET	0x80	/* needed by 3bnet */

/*	FMASK sets bits allowed to be changed via F_SETFL (excludes
	FNET, WORKNET stuff, and any unused bits) */
#define	FMASK	0x1f

/* open only modes */

#define	FCREAT	0x100
#define	FTRUNC	0x200
#define	FEXCL	0x400


/* MULTIPROCESSOR SUPPORT **************************************************

RULES

1) File table must be locked while allocating or freeing an entry.
2) Since f_count keeps track, all accesses to it must have filtab locked.
3) Since no interrupt can allocate or free a file, spl is NOT necessary!

*/
extern mplock_t file_mplock;
