/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)fcntl.h	1.7 88/03/19   */

#include "lockcmn.h"

/* Flag values accessible to open(2) and fcntl(2) */
/*  (The first three can only be set by open) */
#define	O_RDONLY 0
#define	O_WRONLY 1
#define	O_RDWR	 2
#define	O_NDELAY 04	/* Non-blocking I/O */
#define	O_APPEND 010	/* append (writes guaranteed at the end) */
#define O_SYNC	 020	/* synchronous write option */
#define O_OSYNCW 0100	/* old synchronous write option */

/* Flag values accessible only to open(2) */
#define	O_CREAT	00400	/* open with file create (uses third open arg)*/
#define	O_TRUNC	01000	/* open with truncation */
#define	O_EXCL	02000	/* exclusive open */

/* fcntl(2) requests */
#define	F_DUPFD	0	/* Duplicate fildes */
#define	F_GETFD	1	/* Get fildes flags */
#define	F_SETFD	2	/* Set fildes flags */
#define	F_GETFL	3	/* Get file flags */
#define	F_SETFL	4	/* Set file flags */
#define	F_GETLK	5	/* Get file lock */
#define	F_SETLK	6	/* Set file lock */
#define	F_SETLKW	7	/* Set file lock and wait */
#define F_CHKFL		8	/* Check legality of file flag changes */
#define	F_ALLOCSP	10	/* reserved */
#define	F_FREESP	11	/* reserved */

/* file segment locking set data type - information passed to system by user */
struct flock {
	short	l_type;		/* F_RDLCK, F_WRLCK, F_UNLCK */
	short	l_whence;	/* flag to choose starting offset */
	long	l_start;	/* relative offset in bytes */
	long	l_len;		/* len = 0 means until end of file */
        short   l_sysid; 	/* return with F_GETTLK */
        short   l_pid;		/* return with F_GETTLK */ 
};

#ifdef INKERNEL
/* 286 and altos5.2 style */
struct flock_286 {
	short	l_type;		/* F_RDLCK, F_WRLCK, F_UNLCK */
	short	l_whence;	/* flag to choose starting offset */
	long	l_start;	/* relative offset in bytes */
	long	l_len;		/* len = 0 means until end of file */
        short   l_pid;		/* return with F_GETTLK */
        short   l_sysid;	/* return with F_GETTLK */
};

#define	OF_RDLCK	OCMN_RDLCK /* Read lock (same as for locking() */
#define	OF_WRLCK	OCMN_WRLCK /* Write lock (same as for locking() */
#define	OF_UNLCK	OCMN_UNLCK /* Remove lock(s) (same as for locking() */
#endif

/* file segment locking types */
#define	F_RDLCK	CMN_RDLCK /* Read lock (same as for locking() */
#define	F_WRLCK	CMN_WRLCK /* Write lock (same as for locking() */
#define	F_UNLCK	CMN_UNLCK /* Remove lock(s) (same as for locking() */

#ifdef nodef
#define	UNIX_F_RDLCK	01	/* these are UNIX values for l_type */
#define	UNIX_F_WRLCK	02
#define	UNIX_F_UNLCK	03
#endif
