/*
 *  @(#)etioctl.h	1.5 88/03/19 
 *
 *	This defines ioctl calls for the Ethernet Transport layer driver.
 * This is used by kernel and user level code.
 */
#ident	"@(#)etioctl.h	1.5	2/19/88 08:37:55"
#define ET_IO(x)	(('T' << 24) | ME_IO(x))

#define ET_SETBOARD	ET_IO(0)	/* set board number */
#define ET_GETBOARD	ET_IO(1)	/* get board number */
#define ET_DEFBOARD	ET_IO(2)	/* get default board number */
#define ET_PTY		ET_IO(3)	/* hook to pseudo-tty */
#define ET_PTYREM	ET_IO(4)	/* indicate remote is pseudo-tty */

#define ETP_CMD		0x03		/* commands from pty server */
#define ETP_DATA	    0x00	    /* data only (no command) */
#define ETP_FLUSH	    0x01	    /* flush data */
#define ETP_PARAM	    0x02	    /* change parameters */
#define ETP_WAIT	    0x03	    /* wait for output to drain */

					/* flush bits */
#define ETP_RFLUSH	0x04		    /* flush input */
#define ETP_WFLUSH	0x08		    /* flush output */

					/* change parameter bits */
#define ETP_FLOW	0x0C		    /* flow control bits */
#define ETP_FLOWANY	    0x04		/* ixon ixany */
#define ETP_FLOWOFF	    0x08		/* -ixon */
#define ETP_FLOWQ	    0x0C		/* ixon -ixany */
#define ETP_MODEM	0x30		    /* modem bits */
#define ETP_TXHARD	0x40		    /* hardware oflow */
#define ETP_RXHARD	0x80		    /* hardware iflow */

					/* command bits from pty client */
#define ETP_STOP	0x80		    /* block tty */
#define ETP_HUP		0x40		    /* received hang up */
#define ETP_ACK		0x01		    /* ack command from server */
