/*
 *	@(#)errno.h	1.7 88/03/19 
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/*
 * Error codes
 */

#define	EPERM	1	/* Not super-user			*/
#define	ENOENT	2	/* No such file or directory		*/
#define	ESRCH	3	/* No such process			*/
#define	EINTR	4	/* interrupted system call		*/
#define	EIO	5	/* I/O error				*/
#define	ENXIO	6	/* No such device or address		*/
#define	E2BIG	7	/* Arg list too long			*/
#define	ENOEXEC	8	/* Exec format error			*/
#define	EBADF	9	/* Bad file number			*/
#define	ECHILD	10	/* No children				*/
#define	EAGAIN	11	/* No more processes			*/
#define	ENOMEM	12	/* Not enough core			*/
#define	EACCES	13	/* Permission denied			*/
#define	EFAULT	14	/* Bad address				*/
#define	ENOTBLK	15	/* Block device required		*/
#define	EBUSY	16	/* Mount device busy			*/
#define	EEXIST	17	/* File exists				*/
#define	EXDEV	18	/* Cross-device link			*/
#define	ENODEV	19	/* No such device			*/
#define	ENOTDIR	20	/* Not a directory			*/
#define	EISDIR	21	/* Is a directory			*/
#define	EINVAL	22	/* Invalid argument			*/
#define	ENFILE	23	/* File table overflow			*/
#define	EMFILE	24	/* Too many open files			*/
#define	ENOTTY	25	/* Not a typewriter			*/
#define	ETXTBSY	26	/* Text file busy			*/
#define	EFBIG	27	/* File too large			*/
#define	ENOSPC	28	/* No space left on device		*/
#define	ESPIPE	29	/* Illegal seek				*/
#define	EROFS	30	/* Read only file system		*/
#define	EMLINK	31	/* Too many links			*/
#define	EPIPE	32	/* Broken pipe				*/
#define	EDOM	33	/* Math arg out of domain of func	*/
#define	ERANGE	34	/* Math result not representable	*/

#define	ENOMSG	35	/* No message of desired type		*/
#define	EIDRM	36	/* Identifier removed			*/

/* Microsoft XENIX-386 5.2 error numbers (37-44) - not used by Altos */

#define	EDEADLK	45	/* Deadlock condition.			*/
#define	ENOLCK	46	/* No record locks available.		*/

/* Convergent error numbers (50-56) - not used by Altos */

/* 57-59 not used */

#define ENOSTR	60	/* Device not a stream			*/
/*  61	not used */
#define ETIME	62	/* timer expired			*/
#define ENOSR	63	/* out of streams resources		*/

#define ENONET	64	/* Machine is not on the network	*/
#define ENOPKG  65	/* Package not installed                */
#define EREMOTE	66	/* The object is remote			*/
#define ENOLINK	67	/* the link has been severed 		*/
#define EADV	68	/* advertise error 			*/
#define ESRMNT	69	/* srmount error 			*/

#define	ECOMM	70	/* Communication error on send		*/
#define EPROTO	71	/* Protocol error			*/
#define	EMULTIHOP 74	/* multihop attempted 			*/
/* 75 not used */
#ifdef INKERNEL		/* used only internally to RFS code	*/
#define	EDOTDOT 76	/* Cross mount point (not really error) */
#endif
#define EBADMSG 77	/* trying to read unreadable message	*/

/* 79-82 not used */

#define ELIBACC	83	/* Can't access a needed shared lib.	*/
#define ELIBBAD	84	/* Accessing a corrupted shared lib.	*/
#define ELIBSCN	85	/* .lib section in a.out corrupted.	*/
#define ELIBMAX	86	/* Attempting to link in too many libs.	*/
#define ELIBEXEC 87	/* Attempting to exec a shared library.	*/


/* Microsoft XENIX-386 5.2 error numbers - used by Altos */

#define	ENOTNAM	137	/* Not a name file			*/
#define	ENAVAIL	138	/* Not available			*/
#define	EISNAM	139	/* Is a name file			*/

/* Microsoft XENIX-386 5.2 error numbers (135, 140-142) - not used by Altos */

#ifdef INKERNEL

/* Old Microsoft/Altos error numbers.  Used by Altos XENIX-386 5.2 and
   by Microsoft XENIX-286 5.x */

#define	OEDEADLOCK	36	/* Would deadlock		*/
#define	OENOTNAM	37	/* Not a name file		*/
#define	OENAVAIL	38	/* Not available		*/
#define	OEISNAM		39	/* Is a name file		*/

/* Altos XENIX-386 5.2 error numbers */

#define AENOMSG 	40	/* No message of desired type	*/
#define AEIDRM  	41	/* Identifier removed		*/
#define AENOLCK		42	/* No record locks available	*/

/* Microsoft/Altos XENIX-286 5.x error numbers */

#define MENOMSG 	43	/* No message of desired type	*/
#define MEIDRM  	44	/* Identifier removed		*/
#define MENOLCK 	45	/* No record locks available	*/

#endif
