/*
 *	@(#)drive.h	1.2 88/03/19 
 *
 *	hard disk drive config info laid out by manufacturing diagnostics
 */

#pragma pack(2)
struct drive {
	char	dc_jump[3];
	char	dc_unused[9];
	unsigned short	dc_magic;
	union {
		struct {
		    short	dr_cyls;
		    char	dr_heads;
		    char	dr_spt;
		} dc_hsc;
		unsigned long dc_nblocks;
	} dc_un;
	char	dc_secsize;
	char	dc_skew;
	char	dc_interleave;
	char	dc_manutype;
	unsigned short	dc_megabytes;
	unsigned short	dc_precomp;
	char	dc_drivetype;
};
#pragma pack()

#define dc_maxblks	dc_un.dc_nblocks
#define dc_cyls		dc_un.dc_hsc.dr_cyls
#define dc_heads	dc_un.dc_hsc.dr_heads
#define	dc_spt		dc_un.dc_hsc.dr_spt

