/*
 *	@(#) dma.h 1.1 88/03/19 
 *
 *	Copyright (C) The Santa Cruz Operation, 1985, 1986.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 *
 */

/*
 * Intel 8237 DMA Controller.
 */

/*
 * DMA I/O Port Assignments.
 */
/* 8 bit channel specific registers on controller 1 */
#define DMA_0ADR 	0x00	/* Channel  address register */
#define DMA_0WCNT 	0x01	/* Channel  word count */
#define DMA_1ADR 	0x02	/* Channel  address register */
#define DMA_1WCNT 	0x03	/* Channel  word count */
#define DMA_2ADR 	0x04	/* Channel  address register */
#define DMA_2WCNT 	0x05	/* Channel  word count */
#define DMA_3ADR 	0x06	/* Channel  address register */
#define DMA_3WCNT 	0x07	/* Channel  word count */

/* 16 bit channel specific registers on controller 1.
 * Chip A0 connected to bus A1, etc. so even address 
 * increments generated by this controller.  Hence, 
 * 16 bit dma, and only even i/o addresses. Channel 4
 * used to cascade controllers.
 */
#define DMA_5ADR 	0xC4	/* Channel  address register */
#define DMA_5WCNT 	0xC6	/* Channel  word count */
#define DMA_6ADR 	0xC8	/* Channel  address register */
#define DMA_6WCNT 	0xCA	/* Channel  word count */
#define DMA_7ADR 	0xCC	/* Channel  address register */
#define DMA_7WCNT 	0xCE	/* Channel  word count */

/* DMA controller 1, 8 bit channels */
#define CTL1_CMD	0x08	/* Command reg */
#define CTL1_STAT	0x08	/* Status reg */
#define CTL1_RES_MSK    0x0A	/* Mask set/reset register */
#define CTL1_MODE	0x0B	/* Mode reg */
#define CTL1_CLFF	0x0C	/* Clear byte pointer first/last flip-flop */

/* DMA controller 2, 16 bit channels */
#define CTL2_CMD	0xD0	/* Command reg */
#define CTL2_STAT	0xD0	/* Status reg */
#define CTL2_RES_MSK    0xD4	/* Mask set/reset register */
#define CTL2_MODE	0xD6	/* Mode reg */
#define CTL2_CLFF	0xD8	/* Clear byte pointer first/last flip-flop */

/* 8 bit channels */
#define DMA_0XADR	0x87	/* Channel 0 address extension reg */
#define DMA_1XADR 	0x83	/* Channel 1 address extension reg */
#define DMA_2XADR 	0x81	/* Channel 2 address extension reg */
#define DMA_3XADR 	0x82	/* Channel 3 address extension reg */

/* 16 bit channels */
#define DMA_5XADR 	0x8B	/* Channel 5 address extension reg */
#define DMA_6XADR 	0x89	/* Channel 6 address extension reg */
#define DMA_7XADR 	0x8A	/* Channel 7 address extension reg */


#define DMA_MSK		0x0A	/* Mask, enable disk, disable others */
#define DMA_CLEAR	0x1A	/* Master clear */
#define IOCR		0x56	/* IO controller */

/*
 * DMA Channels. d_chan field of dmareq.
 */

#define NCHANS		8

/* 8 bit channels */
#define DMA_CH0		0	/* Channel 0 */
#define DMA_CH1		1	/* Channel 1 */
#define DMA_CH2		2	/* Channel 2 */
#define DMA_CH3		3	/* Channel 3 */
/* 16 bit channels */
#define DMA_CH5		5	/* Channel 5 */
#define DMA_CH6		6	/* Channel 6 */
#define DMA_CH7		7	/* Channel 7 */

/*
 * DMA Masks.
 */
#define DMA_SETMSK	4	/* Set mask bit */
#define DMA_CLRMSK	0	/* Clear mask bit */

/*
 * DMA Commands. d_mode field of dmareq.
 */
/* from memory to device */
#define DMA_Wrmode	0x48	/* single, read, increment, no auto-init */
/* from device to memory */
#define DMA_Rdmode	0x44	/* single, write, increment, no auto-init */
#define DMA_Nomode	0x0C	/* illegal mode */

#define DMAPRI	PRIBIO

/* dma_alloc modes */
#define DMA_BLOCK	0	/* blocking task time allocation */
#define DMA_NBLOCK	1	/* non-blocking task time allocation */

struct dmareq
{   struct dmareq	*d_nxt;		/* reserved */
    unsigned short	 d_chan;	/* specifies channel */
    unsigned short	 d_mode;	/* direction of transfer */
    paddr_t		 d_addr;	/* physical src or dst */
    long		 d_cnt;		/* byte or word (16 bit chan) count */
    int		       (*d_proc)();	/* address of dma routine */
    char		*d_params;	/* driver defineable param block */
};
