/*
 *	@(#)debugtype.h	1.4 88/03/19 
 */

/*
 *	There is are three arrays constructed from the kernel's type information
 * in its symbol table. They contain unnamed types, name types, and field
 * definitions.  Each has a 32 bit information structure associated with it.
 * There is a lot of information packed in a complicated way into these bits.
 */

struct db_utype  {			/* unnamed types */
	unsigned short	db_width;
	unsigned short	db_type;
};

					/* named types: should be one of
					 * struct, union, or typedef */
#define DB_NAMESIZE	12
struct db_ntype  {
	unsigned short	db_width;
	unsigned short	db_type;
	char	db_name[DB_NAMESIZE];	/* doesn't need zero byte */
};

#define db_off	db_width		/* for struct/union fields */

/*
 * The db_type field is divided into two parts.  The TYPEMASK part
 * indicates the data type.  The OFFMASK part is usually an offset to
 * another entry.  For certain types (bit fields and "basic" types),
 * there are special meanings to this field.
 */
#define TYPEMASK	0xF000
#define OFFMASK		0x0FFF

/*
 * types for db_mask
 */

#define SIZE		0x0000		/* internal only: size of something */
#define BASIC		0x1000		/* fundamental types */
#define	DB_VOID			0x000
#define	DB_CHAR			0x001
#define	DB_SHORT		0x002
#define	DB_LONG			0x004
#define	DB_SIZE			0x007
#define	DB_UNSIGNED		0x010

					/* bit fields:  BITOFF is the bit
					 * position, BITNUM is the number of
					 * bits, BITSIZE is the size of the
					 * aggregate data type.  BITTYPE
					 * forms a type field from position
					 * and bit count parameters */
#define BITFIELD	0x2000
#define BITOFF(x)		((x)->db_type & 0x1F)
#define BITNUM(x)		(((x)->db_type >> 5) & 0x1F)
#define BITSIZE(x)		(((x)->db_type >> 10) & 0x3)
#define CHARBITS		1
#define SHORTBITS		2
#define LONGBITS		3
#define BITTYPE(x,y)		(((x) & 0x1F) | (((y) & 0x1F) << 5))

#define STRUCT		0x3000		/* offset points to first field */
#define TYPEDEF		0x4000		/* offset points to element type */
#define ARRAY		0x5000		/* offset points to element type */
#define FUNCTION	0x6000		/* offset points to return value type */
#define POINTER		0x7000		/* offset points to object type */

					/* fields can have the DUPFIELD
					 * bit set if the field name is used
					 * in more than one structure, and
					 * the LASTFIELD bit set if it is
					 * the last field of a structure.
					 * the PRINTFIELD bit is used for
					 * debugging, to see if the value
					 * of this field is currently being
					 * printed.  The fields of a structure
					 * are store in consecutive table
					 * entries in memory, ending with
					 * the LASTFIELD bit set. */
#define FIELD		0x8000
#define DUPFIELD		0x1000
#define LASTFIELD		0x2000
#define PRINTFIELD		0x4000
#define INDIR_TYPE	0xC000		/* mask for types with indirection */

/*
 * These are used in building the type table.  They are not used by
 * the debugger.
 */

#define NONAME		0x1000
#define NAME		0x2000
#define TYPELIST	0x3000
#define NAMELIST	0x4000

/*
 * The first few unnamed types are pre-allocated.  The first two entries
 * contain the size of unnamed types, named types (i.e., typedefs),
 * structures/unions, and fields.  The next thirteen are fundamental
 * types recognized by the (CMERGE) compiler.
 */

#define OFF_VOID	2
#define OFF_CHAR	3
#define OFF_SHORT	4
#define OFF_LONG	5
#define OFF_UCHAR	6
#define OFF_USHORT	7
#define OFF_ULONG	8
#define OFF_PCHAR	9
#define OFF_PSHORT	10
#define OFF_PLONG	11
#define OFF_PUCHAR	12
#define OFF_PUSHORT	13
#define OFF_PULONG	14
#define OFF_NEW		15		/* new types start here */

#define	MAX_TYPE 0x1000			/* maxmimum number of types */

					/* the last available CMERGE type
					 * number */
#define LAST_TYPE (MAX_TYPE + PRIM_TYPES - OFF_NEW)

extern struct db_utype	*noname_start;
extern struct db_ntype	*name_start;
extern struct db_ntype	*struct_start;
extern struct db_ntype	*field_start;

extern struct db_utype	*noname_end;
extern struct db_ntype	*name_end;
extern struct db_ntype	*struct_end;
extern struct db_ntype	*field_end;

extern int	noname_cnt;
extern int	name_cnt;
extern int	struct_cnt;
extern int	field_cnt;
extern int	type_cnt;
