/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)debug.h	1.8 88/03/19   */

#define	YES 1
#define	NO  0

#if DEBUG == YES
#define ASSERT(EX) if (!(EX))assfail("EX", __FILE__, __LINE__)
#else
#define ASSERT(x)
#endif

#ifdef DEBUGGER
/*	rest of stuff is for use in the various portions of the
	kernel debugger.  Were all in xdebug.c, but debugger now
	has more than one source file.
*/

#define DBGSEL 0x100	/* must match value in dbg.asm! */

#define NIBPW	4	/* nibbles per word */
#define NIBPL	8	/* nibbles per long word */
#define BITPW 16	/* bits per word */
#define BITPNIB 4	/* bits per nibble */

/* macros for setting/interpreting 386 debug registers */

/* turn off all the register specific bits for dr7 */
#define DR0mask (~0x000f0003L)
#define DR1mask (~0x00f0000CL)
#define DR2mask (~0x0f000030L)
#define DR3mask (~0xf00000C0L)

/*	Assumes len is 0,1, or 3, R is 0 or 1, and W is 0 or 1.  caller
	must be correct! */
#define DBG0_LENRW(len,RW) ((ulong)(((len)<<2) | (RW)) << 16)
#define DBG1_LENRW(len,RW) ((ulong)(((len)<<2) | (RW)) << 20)
#define DBG2_LENRW(len,RW) ((ulong)(((len)<<2) | (RW)) << 24)
#define DBG3_LENRW(len,RW) ((ulong)(((len)<<2) | (RW)) << 28)

/* detect in gdt and/or ldt */
#define DBG0_G_L(gl, loc)  (((gl)<<1) | (loc))
#define DBG1_G_L(gl, loc)  ((((gl)<<1) | (loc))<<2)
#define DBG2_G_L(gl, loc)  ((((gl)<<1) | (loc))<<4)
#define DBG3_G_L(gl, loc)  ((((gl)<<1) | (loc))<<6)

#define DBG_SET_GE() (dr7 |= 0x100)
#define DBG_SET_LE() (dr7 |= 0x200)
#define DBG_CLR_BAD() (dr7 &= ~(0xDC00L))	/* clear 'unused' bits */


#define B386 1 /* values for btype */
#define BINT3 2

#define DBG0 1 /* values for b386 */
#define DBG1 2
#define DBG2 4
#define DBG3 8

#define NBK     10	/* max number of brk pts */

struct brk {
	ulong	brkoff;		/* address (32 bit linear address) */
	ulong	brkbits;	/* used with 386 bkpts to skip if bits aren't set */
	ushort	oldinst;	/* old instruction */
	uchar_t btype;		/* 0 free, 386debug B386, INT3 BINT3 */
	uchar_t b386;	/* for matching dr6 on 386 breakpoints */
	uchar_t	b386size;	/* 1, 2, or 4 bytes */
	char brkname[20];	/* 'name' for breakpoint */
	char brk_cmds[40];	/* commands to auto execute at break */
};

/*	note that the addresses are relative to their segments, AND no
	segment info is passed, the user is expected to know what
	segment the symbol is in.  (This is more useful for things
	like text breakpoints.)
*/
struct dbgsym {
	char symname[11];
	char type;	/* D or T */
	ulong symaddr;	/* address in memory of symbol */
};
#define MAXSYMS 3000	/* as of 12/15/87, we have 2375 */

extern char *debug_cmdstr; /* if non-null, getchar() picks up chars from this string */
extern label_t debug_restart[];	/* see getchar() in sc.c */
extern int in_debug[];	/* for traps while in debugger, see prf.c */
extern int *savedreg[];		/* see doregisters() and trap.c */
extern int *debugbp[];		/* bp just after debug() was entered */
extern int *save_r0ptr[];	/* points to registers saved by last trap */

/* global copies for getting, setting debug registers */
extern ulong dr0, dr1, dr2, dr3, dr6, dr7;
extern ulong lastaddress;	/* so we can reuse last value from getnum */
extern char lastchar;
extern int not_a_number;	/* set by getnum if no digits entered */

extern char lastoutchar[];	/* last char output by a printf/putchar */
extern short dbgcol[];	/* keeps track of input column for BS handling */
extern struct dbgsym  dbgsyms[];
extern int dbgsymb_size;
extern struct brk brks[];
extern ushort resetbrk[];	/* for resetting breakpoints */
extern ulong xtextbase, xtextlimit;	/* kernel text base and limit */
extern char Version[];
extern int gdtsize;
extern struct dscr *ldgt;
extern struct dscr *ldgt_tmp;

/* function declarations */
ulong validate();
struct dbgsym *get_var(), *find_symbol();
ulong dscraddr(), dscrlimit();
char *text_symbol();
char *strchr();
#endif DEBUGGER

#if !defined(INHOUSE)
# if defined(DEBUG) || defined(DEBUGGER)
#  define INHOUSE 1
# else
#  define INHOUSE 0
# endif
#endif
