/*
 *	@(#)com.h	1.1 88/03/19 
 *
 *	Copyright (C) The Santa Cruz Operation, 1985, 1986, 1987.
 *	This Module contains Proprietary Information of
 *	The Santa Cruz Operation and should be treated as Confidential.
 *
 */


/*****************************************************************************
 *
 *	Defines for support of the AT COM1/COM2 ports as serial devices.
 *
 *	05-Jan-88	M. Anenberg
 *	Merged sio.h and sioconf.h. Removed all of the stuff for support
 *	of other serial cards.
 * 
 *****************************************************************************/


typedef struct com_device 
{
	char txbuffer;
	char intrenable;
	char intrident;
	char linctrlreg;
	char modemctrlreg;
	char linstatreg;
	char modemstatreg;
	char _xpadx;
} comdev_t;

#define rxbuffer	txbuffer
#define lsbdivlatch	txbuffer
#define msbdivlatch	intrenable

typedef struct com_device * sd;


typedef struct board {
	int bd_num;	/* board number */
	int bd_type;	/* each manufacturer gets a different one */
	int bd_pcnt;	/* port count on the board */
	int bd_vec;	/* interrupt vector */
	int bd_dev;	/* minor dev base */
	sd  bd_addr;	/* base address of board */
	int bd_poll;	/* interrupt poll addr */
	int bd_inc;	/* increment (spacing) of io ports on board */
	int bd_outbits;	/* value for OUT1/OUT2 bits in MCR */
} board_t;

/* Modem Control Register defines */
#define MCRDTR		0x01    /* Data Terminal Ready */
#define MCRRTS		0x02    /* Request To Send */
#define MCRBIT2		0x04	
#define MCRBIT3		0x08	/* Interrupt control for 8250 level4 */

/* Board Number defines */
#define IBM_BOARD	0
#define HOST_BOARD	1

/* Line Control Register defines */
#define CHAR_8		0x03	/* 8 Bit character */	
#define TWO_STP_BITS	0x04	/* two stop bits if set, else one */
#define PAR             0x08    /* Enable Parity */
#define EVENPAR         0x10    /* Select Even Parity */
#define BRK_GEN         0x40    /* Generate Break Condition */ 
#define DLAB		0x80	/* Divisor Latch Access Bit */

#define DLL		0x03F8	/* Divisor Latch Least significant byte */
#define DLM		0x03F9	/* Divisor Latch Most significant byte */

/* Line Status Register defines */
#define Rx_CHAR		0x01	/* Received Char Available */
#define Rx_OVER		0x02	/* Overrun Error */
#define PAR_ERR		0x04	/* Parity Error */
#define FRM_ERR		0x08	/* Framing Error */
#define BRK_INTR	0x10	/* Break Interrupt */
#define Tx_CLR		0x20	/* Transmitter Holding Reg Empty */

/* Interrupt Identification Register defines */
#define NOINT_PEND	0x01	/* No Interrupt Pending */
#define MOD_STAT	0x00	/* Modem Status */
#define Tx_INT		0x02	/* Transmitter Interrupt */
#define Rx_INT		0x04	/* Receiver Interrupt */
#define Rx_ERR		0x06	/* Receiver Error Interrupt */

/* Interrupt Enable Register defines */
#define ENB_RxINT	0x01	/* Enable Receiver Interrupts */
#define ENB_TxINT	0x02	/* Enable Transmitter Empty Interrupts */
#define ENB_RxSTAT	0x04	/* Enable Receiver Line Status Interrupt */
#define ENB_ModINT	0x08	/* Enable Modem Status Interrupts */

/* Modem Control Register defines */
#define DTR		0x01    /* Data Terminal Ready */
#define RTS		0x02    /* Request To Send */
#define BIT2		0x04	
#define BIT3		0x08	/* Interrupt control for 8250 level4 */

/* Modem Status Register defines */
#define DELTA_CTS       0x01
#define DELTA_DSR       0x02
#define DELTA_RING      0x04
#define DELTA_LINSIG    0x08
#define CTS             0x10
#define DSR             0x20
#define RING            0x40
#define LINSIG          0x80

/* internal state defines */
#define	SIO_BUSY	0001
#define	SIO_OUTPUT	0002
#define	SIO_CTS		0004
#define SIO_BLOCK       0020
#define SIO_ON          0040 
#define SIO_OFF         0100
#define	SIO_IOWAKE	0200
#define	SIO_MDWAKE	0400

#define	SIOWMASK	0600

/* internal minor defines */
#define SIO_MODEM       01
#define SIO_NOMODEM     02
#define SIO_CARRON      04
#define	SIO_CDEV	010
#define	SIO_CONS	020

/* external minor defines */
#define NOMODEMBIT      0x7F
#define MODEMBIT        0x80
#define NODSRBIT        0xBF
#define DSRBIT          0x40

#define LOBYTE(x) ((x) & 0xFF)
#define HIBYTE(x) (((x) >> 8 ) & 0xFF)

#define DELAY          0200

#define SIO_RCACHEMASK	0x00FF
#define SIO_WCACHEMASK	0x007F

#define	SIO_RCACHESIZE	((SIO_RCACHEMASK+1) * sizeof(char))
#define	SIO_ECACHESIZE	SIO_RCACHESIZE
#define	SIO_WCACHESIZE	((SIO_WCACHEMASK+1) * sizeof(short))

typedef struct com_queue {
	int  q_state;
	int  q_minor;
	comdev_t *q_addr;
	struct tty *q_tp;
	int  q_rstrt;
	int  q_rend;
	unsigned char *q_rcache;
	unsigned char *q_ecache;
	int  q_wstrt;
	int  q_wend;
	unsigned short *q_wcache;
} comqueue_t; 

#define	CHANNELS	2
#define	SIO_INTS	8	/* number of valid interrupt levels */
#define SYSTTY
#define CONSTTY		0
