/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)clock.h	1.4 88/03/19 	*/
 
#define	SECHR	(60*60)	/* seconds/hr */
#define	SECDAY	(24*SECHR)	/* seconds/day */
#define	SECYR	(365*SECDAY)	/* seconds/common year */

#if SYS_TYPE == SYS_ABBY
/*	IO address definition for National 58167 real time clock chip */
/* Real time clock IO address */
#define	CMONTH	0x000F		/* Month		*/
#define	CDAYOFM	0x000D		/* Day of month		*/
#define	CDAYOFW	0x000B		/* Day of week		*/
#define	CHOUR	0x0009		/* Hours		*/
#define	CMINUTE	0x0007		/* Minutes		*/
#define	CSECOND	0x0005		/* Seconds		*/
#define	C10MSEC	0x0003		/* Hundredths and tenths*/
#define	C1MSEC  0x0001		/* Mini second (left nibble only) */

/* Clock on-chip RAM IO address */
#define	RMONTH	0x001F		/* Month 		*/
#define	RDAYOFM	0x001D		/* Day of month 	*/
#define	RDAYOFW	0x001B		/* Day of week 		*/
#define	RHOUR	0x0019		/* Hours 		*/
#define	RMINUTE	0x0017		/* Minutes 		*/
#define	RSECOND	0x0015		/* Seconds 		*/
#define	R10MSEC	0x0013		/* Hundredths and tenths*/
#define	R1MSEC	0x0011		/* Mini second (left nibble only) */

#define	COLLAPSE(z)	(((z) & 0x3) | (((z) >> 2) & 0x0c))
#define	MKYEAR(lo, hi)	(COLLAPSE(lo) | (COLLAPSE(hi) << 4) )
#define	SPLIT(val)	(((val) & 0x3) | (((val) << 2) & 0x30))

#define	LOYR		RDAYOFM
#define	HIYR		RMONTH

/* Clock command IO address */
#define	TESTMOD	0x002F		/* Test mode		*/
#define	INT2ND	0x002D		/* standby interrupt	*/
#define	GOCMD	0x002B		/* Go command		*/
#define	STATUS	0x0029		/* Status bit		*/
#define	RRESET	0x0027		/* Ram area reset	*/
#define	CRESET	0x0025		/* Counters reset	*/
#define	INTCTRL	0x0023		/* Interrupt control register*/
#define	INTSTAT	0x0021		/* Interrupt status register*/
#endif

#if SYS_TYPE == SYS_CINDY
/*	IO address definition for Motorola M146818A TOD + static RAM chip */

#define TOD_BASE LIOBASE
/*	NOTE: the chip is available to the CPU only as the ODD bytes of
	each 2byte word.  We do NOT use any of the alarm or interrupt
	capabilties, the Zilog CIO chip is used for those.
	We keep the time in the BCD mode, not the binary mode.
	Daylight savings capability is enabled.
*/
/* offsets of the various chip registers and TOD fields */
#define SEC		0x1
#define SECALRM		0x3
#define MINUTE		0x5
#define MINALRM		0x7
#define HOUR		0x9
#define HRALRM		0xB
#define DAYWEEK		0xD
#define DAYMON		0xF
#define MONTH		0x11
#define YEAR		0x13
#define REG_A		0x15
#define REG_B		0x17
#define REG_C		0x19
#define REG_D		0x1B
#define STATIC_RAM	0x1D	/* start of static ram, continues to */
#define STATIC_END	0x7f	/* end of 50 bytes of static RAM */

#define TOD_RAMSIZE 0x32
/* interesting register bits */
/* we don't care about registers A, C, and D */

#define REGB_SET	0x80	/* when set, prevents chip from
    updating fields (fields may contain garbage if read during update */
#define REGB_PIE	0x40	/* periodic interrupt enable. always 0 */
#define REGB_AIE	0x20	/* alarm interrupt enable. always 0 */
#define REGB_UIE	0x10	/* update-end interrupt enable. always 0 */
#define REGB_SQWE	0x8	/* square-wave signal enable. always 0 */
#define REGB_DM		0x4	/*  1 for binary, 0 for BCD format */
#define REGB_24_12	0x2	/*  1 for 24 hour, 0 for 12 hour mode */
#define REGB_DSE	0x1	/*  1 for automatic daylight savings.
	(last Sunday in Oct to last Sunday in April) */

#endif	/* CINDY */

#if SYS_TYPE == SYS_500
/*	IO address definition for Motorola M146818A TOD + static RAM chip */

#define	SECONDS		0x0
#define	MINUTES		0x2
#define	HOURS		0x4
#define	DATEOFMONTH	0x7
#define	MONTH		0x8
#define	YEAR		0x9
#define STATUSA		0xA	/* register A */
#define STATUSB		0xB	/* register B */
#define STATIC_RAM	0x1D	/* start of static ram, continues to */
#define STATIC_END	0x7f	/* end of 50 bytes of static RAM */
#define TOD_RAMSIZE 0x32

/* packed binary coded decimal size of date string */
#define PCKBCDSIZ	6
/* character string size of date string */
#define CHRSTRSIZ	(PCKBCDSIZ * 2)

/* real time clock status register A defines */
#define RTCUIP		0x80	/* update in progress */

/* real time clock status register B defines */
#define	CLKOFF		0x80	/* disable time updating */
#define	MODE24		0x02	/* 24 hour mode */
#define	DAYSAV		0x01	/* daylight savings time */

/* ascii defines */
#define ASCIIZERO	0x30

/* nibble from byte extraction */
#define LONIBBLE(ch)	((ch) & 0xF)
#define HINIBBLE(ch)	(((ch) >> 4) & 0xF)

/* bcd nibble packing */
#define PACKLOBCD(ch)	(((ch) - ASCIIZERO) & 0xF)
#define PACKHIBCD(ch)	((((ch) - ASCIIZERO) << 4) & 0xF0)
 
/* Ports for interacting with chip at */
#define CMOSADDR	0x70 	/* Use to select RAM address */
#define CMOSDATA	0x71	/* R/W data */

#endif /* 500 */

#define	ATOBCD(x)	((x)&0xf)		/* ascii to bcd */
#define	BCDTOA(x)	(((x)&0xf) + '0')	/* bcd to ascii */
