/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	@(#)buf.h	1.22 88/03/19 	*/

/*
 *   The buffer header is used for multiple purposes, AND also by the IOPs
 *   (such as the File Processor and 386E IOP). The offset of the union
 *   b_u is therefore fixed forever. IOPs can only use the portion within the
 *   union. Note that the first 22 bytes are used by UNIX and so cannot be
 *   mismanaged by the IOP if it expects to cooperate with the UNIX kernel.
 *   IOPs can add stuff after this to their part of the union b_u.
 */


/*****************************************************************************/
/* UNIX interpretation of b_u in the buffer header */
/*****************************************************************************/
/* Because it is fixed by the FP, structure must aligned on 2-byte boundaries */
#pragma pack(2)
typedef struct {
	daddr_t	os_blkno;		/* block number */
	unsigned long os_bcount;	/* transfer count */
	paddr_t os_paddr;		/* physical buffer address */
	dev_t os_dev;			/* Device associated with this buf */
	char fp_command;		/* FP command */
	char os_error;			/* Error code */
	union {
		struct {
			char softerr;	/* FP soft error field */
			char lsize;	/* FP logical block size field */
		} _fp;
		short cylin;		/* cylinder number for 500 drivers */
	} un2;
	unsigned long os_resid;		/* Residual count of bytes */
} osbuf_t;
#define b_blkno		b_u.osbuf.os_blkno
#define b_bcount	b_u.osbuf.os_bcount
#define b_dev		b_u.osbuf.os_dev
#define b_error		b_u.osbuf.os_error
#define	b_resid		b_u.osbuf.os_resid
#define	b_cylin		b_u.osbuf.un2.cylin
#define fp_softerr  	un2._fp.softerr
#define fp_lsize  	un2._fp.lsize

/*****************************************************************************/
/* File processor interpretation of b_u in the buffer header */
/*****************************************************************************/
/*	This structure is informational only, it is not used anywhere
 *	in the kernel.  Also note that the download code aligns
 *	structures on even boundaries, NOT long boundaries!
 */
typedef struct
{
	osbuf_t fp_osbuf;		/* Should look like osbuf_t */
} fpbuf_t;

/*****************************************************************************/
/* RFS interpretation of b_u in the buffer header */
/*****************************************************************************/
typedef struct
{
	daddr_t		rfs_blkno;	/* logical block # (from offset)*/
	struct buf 	*rfs_forw;	/* position in RFS file hash table */
	caddr_t 	rfs_addr;	/* low order core address */
	unsigned long	rfs_vcode;	/* remote file version code */
	long   		rfs_fhandle;	/* buffer remote file ID */
	struct queue	*rfs_queue;	/* buffer remote server ID */
	struct buf	*rfs_back;	/* position in RFS file hash table */
	index_t		rfs_mntindx;	/* remote mount index */
} rfsbuf_t;
#define	rfsbufcheck() \
{ASSERT(&(rfsbuf_t *)0->rfs_blkno == &(osbuf_t *)0->os_blkno);\
 ASSERT(&(rfsbuf_t *)0->rfs_addr == &(osbuf_t *)0->os_un.b_addr);}

/*****************************************************************************/
/* 386E IOC interpretation of b_u in the buffer header */
/*****************************************************************************/
typedef struct
{
	osbuf_t ioc_osbuf;		/* Should look like osbuf_t */
	char ioc_scsi[6];
} iocbuf_t;

/*****************************************************************************/
/* DEVICE DRIVER interpretation of b_u in the buffer header */
/*****************************************************************************/
typedef struct
{
	int	dd_io_nreg;		/* number of registers for errors */
	uchar_t	dd_hd_c0;		/* space for drivers to leave things */
	uchar_t	dd_hd_c1;
	uchar_t	dd_hd_c2;
	uchar_t	dd_hd_c3;
	uchar_t	dd_tp_c0;		/* space for drivers to leave things */
	uchar_t	dd_tp_c1;
	uchar_t	dd_tp_c2;
	uchar_t	dd_tp_c3;
	dev_t	dd_b_dev;		/* major+minor device name */
	char	dd_b_active;		/* busy flag */
	char	dd_b_errcnt;		/* error count (for recovery) */
	struct	eblock *dd_io_erec;	/* error record */
	struct	iostat *dd_io_stp;	/* unit I/O statistics */
	int	dd_tp_c4;
	short	dd_tp_c5;
} ddbuf_t;
#define ddbufcheck() \
ASSERT(&(ddbuf_t *)0->dd_b_dev == &(osbuf_t *)0->os_dev)

/*
 *	Each buffer in the pool is usually doubly linked into 2 lists:
 *	the device with which it is currently associated (always)
 *	and also on a list of blocks available for allocation
 *	for other use (usually).
 *	The latter list is kept in last-used order, and the two
 *	lists are doubly linked to make it easy to remove
 *	a buffer from one list when it was found by
 *	looking through the other.
 *	A buffer is on the available list, and is liable
 *	to be reassigned to another disk block, if and only
 *	if it is not marked BUSY.  When a buffer is busy, the
 *	available-list pointers can be used for other purposes.
 *	Most drivers use the forward ptr as a link in their I/O active queue.
 *	A buffer header contains all the information required to perform I/O.
 *	Most of the routines which manipulate these things are in bio.c.
 */

#pragma pack()
struct	hbuf
{
	long	b_flags;		/* see defines below */
	struct	buf *b_forw;		/* headed by d_tab of conf.c */
	struct	buf *b_back;		/*  "  */
};

typedef struct	buf
{
	long	b_flags;		/* see defines below */
	struct	buf *b_forw;		/* headed by d_tab of conf.c */
	struct	buf *b_back;		/*  "  */
	struct	buf *av_forw;		/* position on free list, */
	struct	buf *av_back;		/*     if not BUSY*/
	union b_u {
		osbuf_t osbuf;		/* UNIX interpretation		 */
		fpbuf_t fpbuf;		/* File processor interpretation */
		rfsbuf_t rfsbuf;	/* RFS interpretation		 */
		iocbuf_t iocbuf;	/* 386E IOC interpretation	 */
		ddbuf_t	ddbuf;		/* Device driver interpretation	 */
	} b_u;

	mplock_t	b_mplock;			/* MULTIPROCESSOR SUPPORT */
# define b_lock b_mplock	/* till name changed in all users. Olson */
	union {
	    caddr_t b_addr;		/* low order core address */
	    int	*b_words;		/* words for clearing */
	    daddr_t *b_daddr;		/* disk blocks */
	} b_un;
	time_t	b_start;		/* request start time */
	unsigned long	b_reltime;      /* previous release time */
} buf_t;


#define paddr(X)	(X->b_u.osbuf.os_paddr)

extern	struct	buf	buf[];		/* The buffer pool itself */
extern	struct	buf	bfreelist;	/* head of available list */
extern	struct	buf	pfreelist;	/* head of available list for physio */
extern	int		pfreecnt;
extern	struct	buf	pbuf[];
typedef	char	buffer_t[BSIZE];
extern buffer_t *buffers;

/*
 *	These flags are kept in b_flags.
 */
#define B_WRITE   0x0000	/* non-read pseudo-flag */
#define B_READ    0x0001	/* read when I/O occurs */
#define B_DONE    0x0002	/* transaction finished */
#define B_ERROR   0x0004	/* transaction aborted */
#define B_BUSY    0x0008	/* not on av_forw/back list */
#define B_PHYS    0x0010	/* Physical IO potentially using UNIBUS map */
#define B_MAP     0x0020	/* This block has the UNIBUS map allocated */
#define B_WANTED  0x0040	/* issue wakeup when BUSY goes off */
#define B_AGE     0x0080	/* delayed write for correct aging */
#define B_ASYNC   0x0100	/* don't wait for I/O completion */
#define B_DELWRI  0x0200	/* delayed write - wait until buffer needed */
#define B_OPEN    0x0400	/* open routine called */
#define B_STALE   0x0800
#define B_VERIFY  0x1000
#define B_FORMAT  0x2000
#define B_REMOTE  0x4000	/* buffer contains remote (RFS) data */
#define B_IOCTL   0x10000
#define B_PRIVLG  0xfffff000	/* privileged operation (internal driver use) */


#ifdef INKERNEL
/*
 *	Fast access to buffers in cache by hashing.
 */

#define bhash(d,b)	((struct buf *)&hbuf[((unsigned)d+(unsigned)b)&v.v_hmask])

extern	struct	hbuf	*hbuf;

/*
 * Pick up the device's error number and pass it to the user;
 * if there is an error but the number is 0 set a generalized code
 */
#define geterror(bp) \
{ if (((bp)->b_flags&B_ERROR) && (u.u_error = (bp)->b_error)==0) \
		u.u_error = EIO;\
}

/*
 * Unlink a buffer from the available list and mark it busy.
 * (internal interface)  Must be at spl6 before calling.
 */
#define notavail(bp) \
{\
	bp->av_back->av_forw = bp->av_forw;\
	bp->av_forw->av_back = bp->av_back;\
	bp->b_flags |= B_BUSY;\
	bfreelist.b_bcount--;\
}


/* MULTIPROCESSOR SUPPORT

Rules

1) More than one process can search a hash chain, but when there is a process
   modifying a chain, no other process can be accessing ANY hash chain.
2) All accesses to the freelist chain must be done with bfreelist locked.
3) When bfreelist is locked, disk interrupts must be off.
4) All changes to b_flags must be done with b_lock held.
5) b_lock can be held only if disk interrupts are off.

*/

extern mplock_t bchainlock;
#endif INKERNEL
